/*
 * Decompiled with CFR 0.152.
 */
package squidpony.squidgrid.gui.gdx;

import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.utils.IntArray;

public class SquidKey
implements InputProcessor {
    private static final int KEY_DOWN = 0;
    private static final int KEY_UP = 1;
    private static final int KEY_TYPED = 2;
    private InputProcessor processor;
    private final IntArray queue = new IntArray();
    private final IntArray processingQueue = new IntArray();
    private boolean ignoreInput = false;

    public SquidKey() {
    }

    public SquidKey(InputProcessor processor) {
        this.processor = processor;
    }

    public SquidKey(InputProcessor processor, boolean ignoreInput) {
        this.processor = processor;
        this.ignoreInput = ignoreInput;
    }

    public void setProcessor(InputProcessor processor) {
        this.processor = processor;
    }

    public InputProcessor getProcessor() {
        return this.processor;
    }

    public boolean getIgnoreInput() {
        return this.ignoreInput;
    }

    public void setIgnoreInput(boolean ignoreInput) {
        this.ignoreInput = ignoreInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drain() {
        IntArray q = this.processingQueue;
        SquidKey squidKey = this;
        synchronized (squidKey) {
            if (this.processor == null) {
                this.queue.clear();
                return;
            }
            q.addAll(this.queue);
            this.queue.clear();
        }
        int i = 0;
        int n = q.size;
        while (i < n) {
            switch (q.get(i++)) {
                case 0: {
                    this.processor.keyDown(q.get(i++));
                    break;
                }
                case 1: {
                    this.processor.keyUp(q.get(i++));
                    break;
                }
                case 2: {
                    this.processor.keyTyped((char)q.get(i++));
                }
            }
        }
        q.clear();
    }

    public boolean hasNext() {
        return this.queue.size >= 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void next() {
        IntArray q = this.processingQueue;
        SquidKey squidKey = this;
        synchronized (squidKey) {
            if (this.processor == null || this.queue.size < 2) {
                this.queue.clear();
                return;
            }
            q.addAll(this.queue, 0, 2);
            this.queue.removeRange(0, 1);
        }
        if (q.size >= 2) {
            int e = q.get(0);
            int n = q.get(1);
            switch (e) {
                case 0: {
                    this.processor.keyDown(n);
                    break;
                }
                case 1: {
                    this.processor.keyUp(n);
                    break;
                }
                case 2: {
                    this.processor.keyTyped((char)n);
                }
            }
        }
        q.clear();
    }

    public void flush() {
        this.queue.clear();
    }

    public synchronized boolean keyDown(int keycode) {
        if (this.ignoreInput) {
            return false;
        }
        this.queue.add(0);
        this.queue.add(keycode);
        return false;
    }

    public synchronized boolean keyUp(int keycode) {
        if (this.ignoreInput) {
            return false;
        }
        this.queue.add(1);
        this.queue.add(keycode);
        return false;
    }

    public synchronized boolean keyTyped(char character) {
        if (this.ignoreInput) {
            return false;
        }
        this.queue.add(2);
        this.queue.add((int)character);
        return false;
    }

    public synchronized boolean touchDown(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    public synchronized boolean touchUp(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    public synchronized boolean touchDragged(int screenX, int screenY, int pointer) {
        return false;
    }

    public synchronized boolean mouseMoved(int screenX, int screenY) {
        return false;
    }

    public synchronized boolean scrolled(int amount) {
        return false;
    }
}

