/*
 * Decompiled with CFR 0.152.
 */
package squidpony.squidgrid.gui.gdx;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import squidpony.squidgrid.Direction;
import squidpony.squidgrid.gui.gdx.AnimatedEntity;
import squidpony.squidgrid.gui.gdx.SColor;
import squidpony.squidgrid.gui.gdx.SquidPanel;
import squidpony.squidgrid.gui.gdx.TextCellFactory;

public class SquidLayers
extends Group {
    protected int width;
    protected int height;
    protected int cellWidth;
    protected int cellHeight;
    protected SquidPanel backgroundPanel;
    protected SquidPanel lightnessPanel;
    protected SquidPanel foregroundPanel;
    protected int[][] bgIndices;
    protected int[][] lightnesses;
    protected ArrayList<SquidPanel> extraPanels;
    protected TextCellFactory textFactory;
    protected ArrayList<Color> palette;
    protected ArrayList<Color> lightingPalette;
    protected boolean[][] values;
    protected float animationDuration;
    public static final char EMPTY_CELL = '\u0000';

    public float getWidth() {
        return this.width * this.cellWidth;
    }

    public float getHeight() {
        return this.height * this.cellHeight;
    }

    public int getGridWidth() {
        return this.width;
    }

    public int getGridHeight() {
        return this.height;
    }

    public int getCellWidth() {
        return this.cellWidth;
    }

    public int getCellHeight() {
        return this.cellHeight;
    }

    public float getAnimationDuration() {
        return this.animationDuration;
    }

    public void setAnimationDuration(float animationDuration) {
        this.animationDuration = animationDuration;
    }

    public TextCellFactory getTextFactory() {
        return this.textFactory;
    }

    public ArrayList<Color> getPalette() {
        return this.palette;
    }

    public int[][] getLightnesses() {
        return this.lightnesses;
    }

    public int[][] getBgIndices() {
        return this.bgIndices;
    }

    public void setLightnesses(int[][] lightnesses) {
        this.lightnesses = lightnesses;
    }

    public void setBgIndices(int[][] bgIndices) {
        this.bgIndices = bgIndices;
    }

    public SquidLayers() {
        this(40, 40);
    }

    public SquidLayers(int gridWidth, int gridHeight) {
        this.initPalettes();
        this.width = gridWidth;
        this.height = gridHeight;
        this.cellWidth = 12;
        this.cellHeight = 12;
        this.bgIndices = new int[this.width][this.height];
        this.lightnesses = new int[this.width][this.height];
        this.values = new boolean[this.width][this.height];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.lightnesses[x][y] = 256;
            }
        }
        this.textFactory = new TextCellFactory().defaultSquareFont().width(12).height(12).initBySize();
        this.backgroundPanel = new SquidPanel(gridWidth, gridHeight, this.textFactory);
        this.lightnessPanel = new SquidPanel(gridWidth, gridHeight, this.textFactory);
        this.foregroundPanel = new SquidPanel(gridWidth, gridHeight, this.textFactory);
        this.animationDuration = this.foregroundPanel.DEFAULT_ANIMATION_DURATION;
        this.extraPanels = new ArrayList();
        super.addActorAt(0, (Actor)this.backgroundPanel);
        super.addActorAt(1, (Actor)this.lightnessPanel);
        super.addActorAt(2, (Actor)this.foregroundPanel);
        this.setSize(this.backgroundPanel.getWidth(), this.backgroundPanel.getHeight());
    }

    public SquidLayers(int gridWidth, int gridHeight, int cellWidth, int cellHeight) {
        this.initPalettes();
        this.width = gridWidth;
        this.height = gridHeight;
        this.cellWidth = cellWidth;
        this.cellHeight = cellHeight;
        this.bgIndices = new int[this.width][this.height];
        this.lightnesses = new int[this.width][this.height];
        this.values = new boolean[this.width][this.height];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.lightnesses[x][y] = 256;
            }
        }
        this.textFactory = new TextCellFactory();
        this.textFactory = cellHeight == cellWidth ? this.textFactory.defaultSquareFont() : this.textFactory.defaultNarrowFont();
        this.textFactory = this.textFactory.width(cellWidth).height(cellHeight).initBySize();
        this.backgroundPanel = new SquidPanel(gridWidth, gridHeight, this.textFactory);
        this.lightnessPanel = new SquidPanel(gridWidth, gridHeight, this.textFactory);
        this.foregroundPanel = new SquidPanel(gridWidth, gridHeight, this.textFactory);
        this.animationDuration = this.foregroundPanel.DEFAULT_ANIMATION_DURATION;
        this.extraPanels = new ArrayList();
        super.addActorAt(0, (Actor)this.backgroundPanel);
        super.addActorAt(1, (Actor)this.lightnessPanel);
        super.addActorAt(2, (Actor)this.foregroundPanel);
        this.setSize(this.backgroundPanel.getWidth(), this.backgroundPanel.getHeight());
    }

    public SquidLayers(int gridWidth, int gridHeight, int cellWidth, int cellHeight, String fontpath) {
        this.initPalettes();
        this.width = gridWidth;
        this.height = gridHeight;
        this.cellWidth = cellWidth;
        this.cellHeight = cellHeight;
        this.bgIndices = new int[this.width][this.height];
        this.lightnesses = new int[this.width][this.height];
        this.values = new boolean[this.width][this.height];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.lightnesses[x][y] = 256;
            }
        }
        this.textFactory = new TextCellFactory().font(fontpath).width(cellWidth).height(cellHeight).initBySize();
        this.backgroundPanel = new SquidPanel(gridWidth, gridHeight, this.textFactory);
        this.lightnessPanel = new SquidPanel(gridWidth, gridHeight, this.textFactory);
        this.foregroundPanel = new SquidPanel(gridWidth, gridHeight, this.textFactory);
        this.animationDuration = this.foregroundPanel.DEFAULT_ANIMATION_DURATION;
        this.extraPanels = new ArrayList();
        super.addActorAt(0, (Actor)this.backgroundPanel);
        super.addActorAt(1, (Actor)this.lightnessPanel);
        super.addActorAt(2, (Actor)this.foregroundPanel);
        this.setSize(this.backgroundPanel.getWidth(), this.backgroundPanel.getHeight());
    }

    private void initPalettes() {
        int i;
        this.palette = new ArrayList(256);
        this.palette.add(SColor.DARK_SLATE_GRAY);
        this.palette.add(SColor.CREAM);
        this.palette.add(SColor.FLATTERY_BROWN);
        this.palette.add(SColor.SILVER_GREY);
        this.palette.add(SColor.RUST);
        this.palette.add(SColor.WATER);
        this.palette.add(SColor.INTERNATIONAL_ORANGE);
        this.palette.add(SColor.WHITE);
        this.palette.add(SColor.LIGHT_GRAY);
        this.palette.add(SColor.DARK_GRAY);
        this.palette.add(SColor.RED_INCENSE);
        this.palette.add(SColor.RED);
        this.palette.add(SColor.COCHINEAL_RED);
        this.palette.add(SColor.PEACH_ORANGE);
        this.palette.add(SColor.ORANGE_PEEL);
        this.palette.add(SColor.TANGERINE);
        this.palette.add(SColor.LEMON_CHIFFON);
        this.palette.add(SColor.CORN);
        this.palette.add(SColor.GOLDEN_YELLOW);
        this.palette.add(SColor.TEA_GREEN);
        this.palette.add(SColor.LIME_GREEN);
        this.palette.add(SColor.GREEN_BAMBOO);
        this.palette.add(SColor.BABY_BLUE);
        this.palette.add(SColor.CYAN);
        this.palette.add(SColor.BLUE_GREEN);
        this.palette.add(SColor.COLUMBIA_BLUE);
        this.palette.add(SColor.ROYAL_BLUE);
        this.palette.add(SColor.PERSIAN_BLUE);
        this.palette.add(SColor.LAVENDER_BLUE);
        this.palette.add(SColor.THIN_VIOLET);
        this.palette.add(SColor.DARK_VIOLET);
        this.palette.add(SColor.CARNATION_PINK);
        this.palette.add(SColor.HOT_MAGENTA);
        this.palette.add(SColor.LIGHT_MAROON);
        this.palette.add(SColor.TAN);
        this.palette.add(SColor.DARK_TAN);
        this.palette.add(SColor.PALE_BROWN);
        this.palette.add(SColor.STEAMED_CHESTNUT);
        this.palette.add(SColor.DARK_CHESTNUT);
        this.palette.add(SColor.SAPPANWOOD_INCENSE);
        this.lightingPalette = new ArrayList(512);
        for (i = 0; i < 512; ++i) {
            this.lightingPalette.add(Color.CLEAR);
        }
        for (i = 1; i < 256; ++i) {
            this.lightingPalette.set(256 + i, new Color(1.0f, 0.99215686f, 0.84705883f, (float)i / 255.0f));
            this.lightingPalette.set(256 - i, new Color(0.0f, 0.0f, 0.0f, (float)i / 255.0f));
        }
    }

    public SquidLayers addExtraLayer() {
        SquidPanel sp = new SquidPanel(this.width, this.height, this.textFactory);
        super.addActor((Actor)sp);
        this.extraPanels.add(sp);
        return this;
    }

    public ArrayList<Color> extendPalette(Color color) {
        this.palette.add(color);
        return this.palette;
    }

    public ArrayList<Color> alterPalette(int index, Color color) {
        if (index >= 0 && index < this.palette.size()) {
            this.palette.set(index, color);
        }
        return this.palette;
    }

    public SquidLayers put(int x, int y, char c) {
        this.foregroundPanel.put(x, y, c);
        this.values[x][y] = true;
        return this;
    }

    public SquidLayers put(int x, int y, char c, int foregroundIndex) {
        this.foregroundPanel.put(x, y, c, foregroundIndex, this.palette);
        this.values[x][y] = true;
        return this;
    }

    public SquidLayers put(int x, int y, char c, Color foreground) {
        this.foregroundPanel.put(x, y, c, foreground);
        this.values[x][y] = true;
        return this;
    }

    public SquidLayers put(int x, int y, char c, int foregroundIndex, int backgroundIndex) {
        this.foregroundPanel.put(x, y, c, foregroundIndex, this.palette);
        this.backgroundPanel.put(x, y, backgroundIndex, this.palette);
        this.values[x][y] = true;
        return this;
    }

    public SquidLayers put(int x, int y, char c, Color foreground, Color background) {
        this.foregroundPanel.put(x, y, c, foreground);
        this.backgroundPanel.put(x, y, background);
        this.values[x][y] = true;
        return this;
    }

    public SquidLayers put(int x, int y, char c, int foregroundIndex, int backgroundIndex, int backgroundLightness) {
        backgroundLightness = this.clamp(backgroundLightness, -255, 255);
        this.foregroundPanel.put(x, y, c, foregroundIndex, this.palette);
        this.values[x][y] = true;
        this.lightnesses[x][y] = 256 + backgroundLightness;
        this.lightnessPanel.put(x, y, 256 + backgroundLightness, this.lightingPalette);
        this.backgroundPanel.put(x, y, backgroundIndex, this.palette);
        return this;
    }

    public SquidLayers put(int x, int y, char c, ArrayList<Color> alternatePalette, int foregroundIndex, int backgroundIndex, int backgroundLightness) {
        backgroundLightness = this.clamp(backgroundLightness, -255, 255);
        this.foregroundPanel.put(x, y, c, foregroundIndex, alternatePalette);
        this.values[x][y] = true;
        this.lightnesses[x][y] = 256 + backgroundLightness;
        this.lightnessPanel.put(x, y, 256 + backgroundLightness, this.lightingPalette);
        this.backgroundPanel.put(x, y, backgroundIndex, alternatePalette);
        return this;
    }

    public SquidLayers put(int x, int y, char c, Color foreground, Color background, int backgroundLightness) {
        backgroundLightness = this.clamp(backgroundLightness, -255, 255);
        this.foregroundPanel.put(x, y, c, foreground);
        this.values[x][y] = true;
        this.lightnesses[x][y] = 256 + backgroundLightness;
        this.lightnessPanel.put(x, y, 256 + backgroundLightness, this.lightingPalette);
        this.backgroundPanel.put(x, y, background);
        return this;
    }

    public SquidLayers put(int x, int y, char c, int foregroundIndex, ArrayList<Color> fgPalette, int backgroundIndex, ArrayList<Color> bgPalette, int backgroundLightness) {
        backgroundLightness = this.clamp(backgroundLightness, -255, 255);
        if (fgPalette == null) {
            fgPalette = this.palette;
        }
        if (bgPalette == null) {
            bgPalette = this.palette;
        }
        this.foregroundPanel.put(x, y, c, foregroundIndex, fgPalette);
        this.values[x][y] = true;
        this.lightnesses[x][y] = 256 + backgroundLightness;
        this.lightnessPanel.put(x, y, 256 + backgroundLightness, this.lightingPalette);
        this.backgroundPanel.put(x, y, backgroundIndex, bgPalette);
        return this;
    }

    public SquidLayers put(int x, int y, char[][] c) {
        this.foregroundPanel.put(x, y, c);
        for (int i = x; i < c.length && i < this.width; ++i) {
            for (int j = y; j < c[i].length && j < this.height; ++j) {
                this.values[i][j] = true;
            }
        }
        return this;
    }

    public SquidLayers put(int x, int y, char[][] c, int[][] foregroundIndex) {
        this.foregroundPanel.put(x, y, c, foregroundIndex, this.palette);
        for (int i = x; i < c.length && i < this.width; ++i) {
            for (int j = y; j < c[i].length && j < this.height; ++j) {
                this.values[i][j] = true;
            }
        }
        return this;
    }

    public SquidLayers put(int x, int y, char[][] c, int[][] foregroundIndex, int[][] backgroundIndex) {
        this.foregroundPanel.put(x, y, c, foregroundIndex, this.palette);
        for (int i = x; i < c.length && i < this.width; ++i) {
            for (int j = y; j < c[i].length && j < this.height; ++j) {
                this.values[i][j] = true;
            }
        }
        this.backgroundPanel.put(x, y, backgroundIndex, this.palette);
        return this;
    }

    public SquidLayers put(int x, int y, char[][] c, int[][] foregroundIndex, int[][] backgroundIndex, int[][] backgroundLightness) {
        this.foregroundPanel.put(x, y, c, foregroundIndex, this.palette);
        for (int i = x; i < this.width && i < backgroundLightness.length; ++i) {
            for (int j = y; j < this.height && j < backgroundLightness[i].length; ++j) {
                this.lightnesses[i][j] = 256 + this.clamp(backgroundLightness[i][j], -255, 255);
                this.values[i][j] = true;
            }
        }
        this.lightnessPanel.put(0, 0, this.lightnesses, this.lightingPalette);
        this.backgroundPanel.put(x, y, backgroundIndex, this.palette);
        return this;
    }

    public SquidLayers put(int x, int y, char[][] c, ArrayList<Color> alternatePalette, int[][] foregroundIndex, int[][] backgroundIndex, int[][] backgroundLightness) {
        if (alternatePalette == null) {
            alternatePalette = this.palette;
        }
        this.foregroundPanel.put(x, y, c, foregroundIndex, alternatePalette);
        for (int i = x; i < this.width && i < backgroundLightness.length; ++i) {
            for (int j = y; j < this.height && j < backgroundLightness[i].length; ++j) {
                this.lightnesses[i][j] = 256 + this.clamp(backgroundLightness[i][j], -255, 255);
                this.values[i][j] = true;
            }
        }
        this.lightnessPanel.put(0, 0, this.lightnesses, this.lightingPalette);
        this.backgroundPanel.put(x, y, backgroundIndex, alternatePalette);
        return this;
    }

    public SquidLayers put(int x, int y, char[][] c, Color[][] foregrounds, Color[][] backgrounds, int[][] backgroundLightness) {
        this.foregroundPanel.put(x, y, c, foregrounds);
        for (int i = x; i < this.width && i < backgroundLightness.length; ++i) {
            for (int j = y; j < this.height && j < backgroundLightness[i].length; ++j) {
                this.lightnesses[i][j] = 256 + this.clamp(backgroundLightness[i][j], -255, 255);
                this.values[i][j] = true;
            }
        }
        this.lightnessPanel.put(0, 0, this.lightnesses, this.lightingPalette);
        this.backgroundPanel.put(x, y, backgrounds);
        return this;
    }

    public SquidLayers put(int x, int y, char[][] c, int[][] foregroundIndex, ArrayList<Color> fgPalette, int[][] backgroundIndex, ArrayList<Color> bgPalette, int[][] backgroundLightness) {
        if (fgPalette == null) {
            fgPalette = this.palette;
        }
        if (bgPalette == null) {
            bgPalette = this.palette;
        }
        this.foregroundPanel.put(x, y, c, foregroundIndex, fgPalette);
        for (int i = x; i < this.width && i < backgroundLightness.length; ++i) {
            for (int j = y; j < this.height && j < backgroundLightness[i].length; ++j) {
                this.lightnesses[i][j] = 256 + this.clamp(backgroundLightness[i][j], -255, 255);
                this.values[i][j] = true;
            }
        }
        this.lightnessPanel.put(0, 0, this.lightnesses, this.lightingPalette);
        this.backgroundPanel.put(x, y, backgroundIndex, bgPalette);
        return this;
    }

    public SquidLayers putInto(int layer, int x, int y, char c) {
        SquidPanel p = this.backgroundPanel;
        switch (layer) {
            case 0: {
                break;
            }
            case 1: {
                p = this.lightnessPanel;
                break;
            }
            case 2: {
                p = this.foregroundPanel;
                break;
            }
            default: {
                p = this.extraPanels.get(layer - 3);
            }
        }
        p.put(x, y, c);
        this.values[x][y] = true;
        return this;
    }

    public SquidLayers putInto(int layer, int x, int y, char c, int colorIndex) {
        SquidPanel p = this.backgroundPanel;
        switch (layer) {
            case 0: {
                break;
            }
            case 1: {
                p = this.lightnessPanel;
                break;
            }
            case 2: {
                p = this.foregroundPanel;
                break;
            }
            default: {
                p = this.extraPanels.get(layer - 3);
            }
        }
        p.put(x, y, c, colorIndex, this.palette);
        this.values[x][y] = true;
        return this;
    }

    public SquidLayers putInto(int layer, int x, int y, char c, ArrayList<Color> alternatePalette, int colorIndex) {
        SquidPanel p = this.backgroundPanel;
        switch (layer) {
            case 0: {
                break;
            }
            case 1: {
                p = this.lightnessPanel;
                break;
            }
            case 2: {
                p = this.foregroundPanel;
                break;
            }
            default: {
                p = this.extraPanels.get(layer - 3);
            }
        }
        if (alternatePalette == null) {
            alternatePalette = this.palette;
        }
        p.put(x, y, c, colorIndex, alternatePalette);
        this.values[x][y] = true;
        return this;
    }

    public SquidLayers putInto(int layer, int x, int y, char[][] c) {
        SquidPanel p = this.backgroundPanel;
        switch (layer) {
            case 0: {
                break;
            }
            case 1: {
                p = this.lightnessPanel;
                break;
            }
            case 2: {
                p = this.foregroundPanel;
                break;
            }
            default: {
                p = this.extraPanels.get(layer - 3);
            }
        }
        p.put(x, y, c);
        for (int i = x; i < c.length && i < this.width; ++i) {
            for (int j = y; j < c[i].length && j < this.height; ++j) {
                this.values[i][j] = true;
            }
        }
        return this;
    }

    public SquidLayers putInto(int layer, int x, int y, char[][] c, int[][] colorIndex) {
        SquidPanel p = this.backgroundPanel;
        switch (layer) {
            case 0: {
                break;
            }
            case 1: {
                p = this.lightnessPanel;
                break;
            }
            case 2: {
                p = this.foregroundPanel;
                break;
            }
            default: {
                p = this.extraPanels.get(layer - 3);
            }
        }
        p.put(x, y, c, colorIndex, this.palette);
        for (int i = x; i < c.length && i < this.width; ++i) {
            for (int j = y; j < c[i].length && j < this.height; ++j) {
                this.values[i][j] = true;
            }
        }
        return this;
    }

    public SquidLayers putInto(int layer, int x, int y, char[][] c, ArrayList<Color> alternatePalette, int[][] colorIndex) {
        SquidPanel p = this.backgroundPanel;
        switch (layer) {
            case 0: {
                break;
            }
            case 1: {
                p = this.lightnessPanel;
                break;
            }
            case 2: {
                p = this.foregroundPanel;
                break;
            }
            default: {
                p = this.extraPanels.get(layer - 3);
            }
        }
        if (alternatePalette == null) {
            alternatePalette = this.palette;
        }
        p.put(x, y, c, colorIndex, alternatePalette);
        for (int i = x; i < c.length && i < this.width; ++i) {
            for (int j = y; j < c[i].length && j < this.height; ++j) {
                this.values[i][j] = true;
            }
        }
        return this;
    }

    public SquidLayers putInto(int layer, int x, int y, char[][] c, Color[][] colors) {
        SquidPanel p = this.backgroundPanel;
        switch (layer) {
            case 0: {
                break;
            }
            case 1: {
                p = this.lightnessPanel;
                break;
            }
            case 2: {
                p = this.foregroundPanel;
                break;
            }
            default: {
                p = this.extraPanels.get(layer - 3);
            }
        }
        p.put(x, y, c, colors);
        for (int i = x; i < c.length && i < this.width; ++i) {
            for (int j = y; j < c[i].length && j < this.height; ++j) {
                this.values[i][j] = true;
            }
        }
        return this;
    }

    public SquidLayers putString(int x, int y, String s) {
        this.foregroundPanel.put(x, y, s);
        return this;
    }

    public SquidLayers putString(int x, int y, String s, int foregroundIndex) {
        this.foregroundPanel.put(x, y, s, this.palette.get(foregroundIndex));
        return this;
    }

    public SquidLayers putString(int x, int y, String s, int foregroundIndex, int backgroundIndex) {
        this.foregroundPanel.put(x, y, s, this.palette.get(foregroundIndex));
        for (int i = x; i < s.length() && i < this.width; ++i) {
            this.backgroundPanel.put(i, y, this.palette.get(backgroundIndex));
        }
        return this;
    }

    public SquidLayers putString(int x, int y, String s, ArrayList<Color> alternatePalette, int foregroundIndex, int backgroundIndex) {
        this.foregroundPanel.put(x, y, s, alternatePalette.get(foregroundIndex));
        for (int i = x; i < s.length() && i < this.width; ++i) {
            this.backgroundPanel.put(i, y, alternatePalette.get(backgroundIndex));
        }
        return this;
    }

    public SquidLayers putString(int x, int y, String s, Color foreground, Color background) {
        this.foregroundPanel.put(x, y, s, foreground);
        for (int i = x; i < s.length() && i < this.width; ++i) {
            this.backgroundPanel.put(i, y, background);
        }
        return this;
    }

    public SquidLayers putBoxedString(int x, int y, String s) {
        if (y > 0 && y + 1 < this.height && x > 0 && x + 1 < this.width) {
            for (int j = y - 1; j < y + 2 && j < this.height; ++j) {
                for (int i = x - 1; i < s.length() + x + 2 && i < this.width; ++i) {
                    this.foregroundPanel.put(i, j, ' ');
                    this.backgroundPanel.put(i, j, this.palette.get(9));
                    this.lightnesses[i][j] = -255;
                    this.lightnessPanel.put(i, j, 1, this.lightingPalette);
                }
            }
        }
        this.foregroundPanel.put(x, y, s, this.palette.get(1));
        return this;
    }

    public SquidLayers highlight(int x, int y, int lightness) {
        lightness = this.clamp(lightness, -255, 255);
        this.lightnesses[x][y] = 256 + lightness;
        this.lightnessPanel.put(x, y, 256 + lightness, this.lightingPalette);
        return this;
    }

    public SquidLayers highlight(int x, int y, int[][] lightness) {
        for (int i = 0; i < lightness.length && x + i < this.width; ++i) {
            for (int j = 0; j < lightness[i].length && y + j < this.height; ++j) {
                lightness[i][j] = 256 + this.clamp(lightness[i][j], -255, 255);
                this.lightnesses[x + i][y + j] = lightness[i][j];
            }
        }
        this.lightnessPanel.put(x, y, lightness, this.lightingPalette);
        return this;
    }

    public boolean hasValue(int x, int y) {
        return this.values[x][y];
    }

    public SquidLayers clear(int x, int y) {
        this.foregroundPanel.clear(x, y);
        this.values[x][y] = false;
        return this;
    }

    public SquidLayers erase() {
        this.foregroundPanel.erase();
        this.lightnessPanel.erase();
        this.backgroundPanel.erase();
        for (SquidPanel sp : this.extraPanels) {
            sp.erase();
        }
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                this.values[i][j] = false;
            }
        }
        return this;
    }

    public SquidLayers bump(int x, int y, int layer, Direction dir, float duration) {
        SquidPanel p = this.foregroundPanel;
        switch (layer) {
            case 0: {
                p = this.backgroundPanel;
                break;
            }
            case 1: {
                p = this.lightnessPanel;
                break;
            }
            case 2: {
                break;
            }
            default: {
                p = this.extraPanels.get(layer - 3);
            }
        }
        if (duration < 0.0f) {
            duration = this.animationDuration;
        }
        p.bump(x, y, dir, duration);
        return this;
    }

    public SquidLayers bump(AnimatedEntity ae, int layer, Direction dir, float duration) {
        SquidPanel p = this.foregroundPanel;
        switch (layer) {
            case 0: {
                p = this.backgroundPanel;
                break;
            }
            case 1: {
                p = this.lightnessPanel;
                break;
            }
            case 2: {
                break;
            }
            default: {
                p = this.extraPanels.get(layer - 3);
            }
        }
        if (duration < 0.0f) {
            duration = this.animationDuration;
        }
        p.bump(ae, dir, duration);
        return this;
    }

    public SquidLayers bump(int x, int y, Direction dir) {
        return this.bump(x, y, 2, dir, -1.0f);
    }

    public SquidLayers bump(AnimatedEntity ae, Direction dir) {
        return this.bump(ae, 2, dir, -1.0f);
    }

    public SquidLayers slide(AnimatedEntity ae, int endX, int endY, int layer, float duration) {
        SquidPanel p = this.foregroundPanel;
        switch (layer) {
            case 0: {
                p = this.backgroundPanel;
                break;
            }
            case 1: {
                p = this.lightnessPanel;
                break;
            }
            case 2: {
                break;
            }
            default: {
                p = this.extraPanels.get(layer - 3);
            }
        }
        if (duration < 0.0f) {
            duration = this.animationDuration;
        }
        p.slide(ae, endX, endY, duration);
        return this;
    }

    public SquidLayers slide(int x, int y, int endX, int endY, int layer, float duration) {
        SquidPanel p = this.foregroundPanel;
        switch (layer) {
            case 0: {
                p = this.backgroundPanel;
                break;
            }
            case 1: {
                p = this.lightnessPanel;
                break;
            }
            case 2: {
                break;
            }
            default: {
                p = this.extraPanels.get(layer - 3);
            }
        }
        if (duration < 0.0f) {
            duration = this.animationDuration;
        }
        p.slide(x, y, endX, endY, duration);
        return this;
    }

    public SquidLayers slide(int x, int y, int endX, int endY) {
        return this.slide(x, y, endX, endY, 2, -1.0f);
    }

    public SquidLayers slide(AnimatedEntity ae, int endX, int endY) {
        return this.slide(ae, endX, endY, 2, -1.0f);
    }

    public SquidLayers wiggle(int x, int y, int layer, float duration) {
        SquidPanel p = this.foregroundPanel;
        switch (layer) {
            case 0: {
                p = this.backgroundPanel;
                break;
            }
            case 1: {
                p = this.lightnessPanel;
                break;
            }
            case 2: {
                break;
            }
            default: {
                p = this.extraPanels.get(layer - 3);
            }
        }
        if (duration < 0.0f) {
            duration = this.animationDuration;
        }
        p.wiggle(x, y, duration);
        return this;
    }

    public SquidLayers wiggle(AnimatedEntity ae, int layer, float duration) {
        SquidPanel p = this.foregroundPanel;
        switch (layer) {
            case 0: {
                p = this.backgroundPanel;
                break;
            }
            case 1: {
                p = this.lightnessPanel;
                break;
            }
            case 2: {
                break;
            }
            default: {
                p = this.extraPanels.get(layer - 3);
            }
        }
        if (duration < 0.0f) {
            duration = this.animationDuration;
        }
        p.wiggle(ae, duration);
        return this;
    }

    public SquidLayers wiggle(int x, int y) {
        return this.wiggle(x, y, 2, -1.0f);
    }

    public SquidLayers wiggle(AnimatedEntity ae) {
        return this.wiggle(ae, 2, -1.0f);
    }

    public SquidLayers tint(int x, int y, Color color, int layer, float duration) {
        SquidPanel p = this.foregroundPanel;
        switch (layer) {
            case 0: {
                p = this.backgroundPanel;
                break;
            }
            case 1: {
                p = this.lightnessPanel;
                break;
            }
            case 2: {
                break;
            }
            default: {
                p = this.extraPanels.get(layer - 3);
            }
        }
        if (duration < 0.0f) {
            duration = this.animationDuration;
        }
        p.tint(x, y, color, duration);
        return this;
    }

    public SquidLayers tint(AnimatedEntity ae, Color color, int layer, float duration) {
        SquidPanel p = this.foregroundPanel;
        switch (layer) {
            case 0: {
                p = this.backgroundPanel;
                break;
            }
            case 1: {
                p = this.lightnessPanel;
                break;
            }
            case 2: {
                break;
            }
            default: {
                p = this.extraPanels.get(layer - 3);
            }
        }
        if (duration < 0.0f) {
            duration = this.animationDuration;
        }
        p.tint(ae, color, duration);
        return this;
    }

    public SquidLayers tint(int x, int y, Color color) {
        return this.tint(x, y, color, 2, -1.0f);
    }

    public SquidLayers tint(AnimatedEntity ae, Color color) {
        return this.tint(ae, color, 2, -1.0f);
    }

    public boolean hasActiveAnimations() {
        if (this.foregroundPanel.hasActiveAnimations()) {
            return true;
        }
        if (this.backgroundPanel.hasActiveAnimations()) {
            return true;
        }
        if (this.lightnessPanel.hasActiveAnimations()) {
            return true;
        }
        for (SquidPanel panel : this.extraPanels) {
            if (!panel.hasActiveAnimations()) continue;
            return true;
        }
        return false;
    }

    public AnimatedEntity animateActor(int x, int y, char c, Color color, int layer) {
        SquidPanel p = this.foregroundPanel;
        switch (layer) {
            case 0: {
                p = this.backgroundPanel;
                break;
            }
            case 1: {
                p = this.lightnessPanel;
                break;
            }
            case 2: {
                break;
            }
            default: {
                p = this.extraPanels.get(layer - 3);
            }
        }
        return p.animateActor(x, y, c, color);
    }

    public AnimatedEntity animateActor(int x, int y, char c, Color color) {
        return this.foregroundPanel.animateActor(x, y, c, color);
    }

    public AnimatedEntity animateActor(int x, int y, char c, Color color, boolean doubleWidth) {
        return this.foregroundPanel.animateActor(x, y, doubleWidth, c, color);
    }

    public AnimatedEntity animateActor(int x, int y, char c, int index, ArrayList<Color> palette, int layer) {
        return this.animateActor(x, y, c, palette.get(index), layer);
    }

    public AnimatedEntity animateActor(int x, int y, char c, int index, ArrayList<Color> palette) {
        return this.animateActor(x, y, c, palette.get(index));
    }

    public AnimatedEntity animateActor(int x, int y, char c, int index, int layer) {
        return this.animateActor(x, y, c, this.palette.get(index), layer);
    }

    public AnimatedEntity animateActor(int x, int y, char c, int index) {
        return this.animateActor(x, y, c, this.palette.get(index));
    }

    public AnimatedEntity animateActor(int x, int y, char c, int index, boolean doubleWidth) {
        return this.animateActor(x, y, c, this.palette.get(index), doubleWidth);
    }

    public AnimatedEntity animateActor(int x, int y, String s, Color color, int layer) {
        SquidPanel p = this.foregroundPanel;
        switch (layer) {
            case 0: {
                p = this.backgroundPanel;
                break;
            }
            case 1: {
                p = this.lightnessPanel;
                break;
            }
            case 2: {
                break;
            }
            default: {
                p = this.extraPanels.get(layer - 3);
            }
        }
        return p.animateActor(x, y, s, color);
    }

    public AnimatedEntity animateActor(int x, int y, String s, Color color, int layer, boolean doubleWidth) {
        SquidPanel p = this.foregroundPanel;
        switch (layer) {
            case 0: {
                p = this.backgroundPanel;
                break;
            }
            case 1: {
                p = this.lightnessPanel;
                break;
            }
            case 2: {
                break;
            }
            default: {
                p = this.extraPanels.get(layer - 3);
            }
        }
        return p.animateActor(x, y, doubleWidth, s, color);
    }

    public AnimatedEntity animateActor(int x, int y, TextureRegion tr, Color color, int layer) {
        SquidPanel p = this.foregroundPanel;
        switch (layer) {
            case 0: {
                p = this.backgroundPanel;
                break;
            }
            case 1: {
                p = this.lightnessPanel;
                break;
            }
            case 2: {
                break;
            }
            default: {
                p = this.extraPanels.get(layer - 3);
            }
        }
        return p.animateActor(x, y, tr, color);
    }

    public AnimatedEntity animateActor(int x, int y, TextureRegion tr, Color color, int layer, boolean doubleWidth, boolean stretch) {
        SquidPanel p = this.foregroundPanel;
        switch (layer) {
            case 0: {
                p = this.backgroundPanel;
                break;
            }
            case 1: {
                p = this.lightnessPanel;
                break;
            }
            case 2: {
                break;
            }
            default: {
                p = this.extraPanels.get(layer - 3);
            }
        }
        return p.animateActor(x, y, doubleWidth, stretch, tr, color);
    }

    public AnimatedEntity animateActor(int x, int y, String s, Color color) {
        return this.foregroundPanel.animateActor(x, y, s, color);
    }

    public AnimatedEntity animateActor(int x, int y, String s, Color color, boolean doubleWidth) {
        return this.foregroundPanel.animateActor(x, y, doubleWidth, s, color);
    }

    public AnimatedEntity animateActor(int x, int y, String s, int index, ArrayList<Color> palette, int layer) {
        return this.animateActor(x, y, s, palette.get(index), layer);
    }

    public AnimatedEntity animateActor(int x, int y, String s, int index, ArrayList<Color> palette) {
        return this.animateActor(x, y, s, palette.get(index));
    }

    public AnimatedEntity animateActor(int x, int y, String s, int index, int layer) {
        return this.animateActor(x, y, s, this.palette.get(index), layer);
    }

    public AnimatedEntity animateActor(int x, int y, String s, int index) {
        return this.animateActor(x, y, s, this.palette.get(index));
    }

    public AnimatedEntity animateActor(int x, int y, String s, int index, boolean doubleWidth) {
        return this.animateActor(x, y, s, this.palette.get(index), doubleWidth);
    }

    public AnimatedEntity animateActor(int x, int y, TextureRegion tr, Color color) {
        return this.foregroundPanel.animateActor(x, y, tr, color);
    }

    public AnimatedEntity animateActor(int x, int y, TextureRegion tr, Color color, boolean doubleWidth) {
        return this.foregroundPanel.animateActor(x, y, doubleWidth, tr, color);
    }

    public AnimatedEntity animateActor(int x, int y, TextureRegion tr, Color color, boolean doubleWidth, boolean stretch) {
        return this.foregroundPanel.animateActor(x, y, doubleWidth, stretch, tr, color);
    }

    public AnimatedEntity animateActor(int x, int y, TextureRegion tr, int index, ArrayList<Color> palette, int layer) {
        return this.animateActor(x, y, tr, palette.get(index), layer);
    }

    public AnimatedEntity animateActor(int x, int y, TextureRegion tr, int index, ArrayList<Color> palette, int layer, boolean doubleWidth) {
        return this.animateActor(x, y, tr, palette.get(index), layer, doubleWidth, true);
    }

    public AnimatedEntity animateActor(int x, int y, TextureRegion tr, int index, ArrayList<Color> palette, int layer, boolean doubleWidth, boolean stretch) {
        return this.animateActor(x, y, tr, palette.get(index), layer, doubleWidth, stretch);
    }

    public AnimatedEntity animateActor(int x, int y, TextureRegion tr, int index, ArrayList<Color> palette) {
        return this.animateActor(x, y, tr, palette.get(index));
    }

    public AnimatedEntity animateActor(int x, int y, TextureRegion tr, int index, int layer) {
        return this.animateActor(x, y, tr, this.palette.get(index), layer);
    }

    public AnimatedEntity animateActor(int x, int y, TextureRegion tr, int index) {
        return this.animateActor(x, y, tr, this.palette.get(index));
    }

    public AnimatedEntity animateActor(int x, int y, TextureRegion tr, int index, boolean doubleWidth) {
        return this.animateActor(x, y, tr, this.palette.get(index), doubleWidth);
    }

    public AnimatedEntity animateActor(int x, int y, TextureRegion tr, int index, boolean doubleWidth, boolean stretch) {
        return this.animateActor(x, y, tr, this.palette.get(index), doubleWidth, stretch);
    }

    public AnimatedEntity animateActor(int x, int y, TextureRegion tr) {
        return this.animateActor(x, y, tr, Color.WHITE);
    }

    public AnimatedEntity animateActor(int x, int y, TextureRegion tr, boolean doubleWidth) {
        return this.animateActor(x, y, tr, Color.WHITE, doubleWidth);
    }

    public AnimatedEntity animateActor(int x, int y, TextureRegion tr, boolean doubleWidth, boolean stretch) {
        return this.animateActor(x, y, tr, Color.WHITE, doubleWidth, stretch);
    }

    public LinkedHashSet<AnimatedEntity> getAnimatedEntities(int layer) {
        SquidPanel p = this.foregroundPanel;
        switch (layer) {
            case 0: {
                p = this.backgroundPanel;
                break;
            }
            case 1: {
                p = this.lightnessPanel;
                break;
            }
            case 2: {
                break;
            }
            default: {
                p = this.extraPanels.get(layer - 3);
            }
        }
        return p.getAnimatedEntities();
    }

    public LinkedHashSet<AnimatedEntity> getAnimatedEntities() {
        return this.foregroundPanel.getAnimatedEntities();
    }

    public AnimatedEntity getAnimatedEntityByCell(int x, int y, int layer) {
        SquidPanel p = this.foregroundPanel;
        switch (layer) {
            case 0: {
                p = this.backgroundPanel;
                break;
            }
            case 1: {
                p = this.lightnessPanel;
                break;
            }
            case 2: {
                break;
            }
            default: {
                p = this.extraPanels.get(layer - 3);
            }
        }
        return p.getAnimatedEntityByCell(x, y);
    }

    public AnimatedEntity getAnimatedEntityByCell(int x, int y) {
        return this.foregroundPanel.getAnimatedEntityByCell(x, y);
    }

    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
    }

    public void drawActor(Batch batch, float parentAlpha, AnimatedEntity ae, int layer) {
        SquidPanel p = this.foregroundPanel;
        switch (layer) {
            case 0: {
                p = this.backgroundPanel;
                break;
            }
            case 1: {
                p = this.lightnessPanel;
                break;
            }
            case 2: {
                break;
            }
            default: {
                p = this.extraPanels.get(layer - 3);
            }
        }
        p.drawActor(batch, parentAlpha, ae);
    }

    public void drawActor(Batch batch, float parentAlpha, AnimatedEntity ae) {
        this.foregroundPanel.drawActor(batch, parentAlpha, ae);
    }

    private int clamp(int x, int min, int max) {
        return Math.min(Math.max(min, x), max);
    }
}

