/*
 * Decompiled with CFR 0.152.
 */
package squidpony.squidgrid.gui.gdx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.math.MathUtils;

public class SquidMouse
extends InputAdapter {
    protected float cellWidth;
    protected float cellHeight;
    protected float gridWidth;
    protected float gridHeight;
    protected int offsetX;
    protected int offsetY;
    protected InputProcessor processor;

    public SquidMouse(float cellWidth, float cellHeight, InputProcessor processor) {
        this.cellWidth = cellWidth;
        this.cellHeight = cellHeight;
        this.processor = processor;
        this.offsetX = 0;
        this.offsetY = 0;
        this.gridWidth = (float)Gdx.graphics.getWidth() / cellWidth;
        this.gridHeight = (float)Gdx.graphics.getHeight() / cellHeight;
    }

    public SquidMouse(float cellWidth, float cellHeight, float gridWidth, float gridHeight, int offsetX, int offsetY, InputProcessor processor) {
        this.cellWidth = cellWidth;
        this.cellHeight = cellHeight;
        this.processor = processor;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.gridWidth = gridWidth;
        this.gridHeight = gridHeight;
    }

    public float getCellWidth() {
        return this.cellWidth;
    }

    public float getCellHeight() {
        return this.cellHeight;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public float getGridWidth() {
        return this.gridWidth;
    }

    public float getGridHeight() {
        return this.gridHeight;
    }

    public void setCellWidth(float cellWidth) {
        this.cellWidth = cellWidth;
    }

    public void setCellHeight(float cellHeight) {
        this.cellHeight = cellHeight;
    }

    public void setOffsetX(int offsetX) {
        this.offsetX = offsetX;
    }

    public void setOffsetY(int offsetY) {
        this.offsetY = offsetY;
    }

    public void setGridWidth(float gridWidth) {
        this.gridWidth = gridWidth;
    }

    public void setGridHeight(float gridHeight) {
        this.gridHeight = gridHeight;
    }

    public void reinitialize(float cellWidth, float cellHeight) {
        this.cellWidth = cellWidth;
        this.cellHeight = cellHeight;
        this.offsetX = 0;
        this.offsetY = 0;
        this.gridWidth = (float)Gdx.graphics.getWidth() / cellWidth;
        this.gridHeight = (float)Gdx.graphics.getHeight() / cellHeight;
    }

    public void reinitialize(float cellWidth, float cellHeight, float gridWidth, float gridHeight, int offsetX, int offsetY) {
        this.cellWidth = cellWidth;
        this.cellHeight = cellHeight;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.gridWidth = gridWidth;
        this.gridHeight = gridHeight;
    }

    public InputProcessor getProcessor() {
        return this.processor;
    }

    public void setProcessor(InputProcessor processor) {
        this.processor = processor;
    }

    protected int translateX(int screenX) {
        return MathUtils.floor((float)MathUtils.clamp((float)((float)(screenX - this.offsetX) / this.cellWidth), (float)0.0f, (float)(this.gridWidth - 1.0f)));
    }

    protected int translateY(int screenY) {
        return MathUtils.floor((float)MathUtils.clamp((float)((float)(screenY - this.offsetY) / this.cellHeight), (float)0.0f, (float)(this.gridHeight - 1.0f)));
    }

    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        return this.processor.touchDown(this.translateX(screenX), this.translateY(screenY), pointer, button);
    }

    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        return this.processor.touchUp(this.translateX(screenX), this.translateY(screenY), pointer, button);
    }

    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return this.processor.touchDragged(this.translateX(screenX), this.translateY(screenY), pointer);
    }

    public boolean mouseMoved(int screenX, int screenY) {
        return this.processor.mouseMoved(this.translateX(screenX), this.translateY(screenY));
    }

    public boolean scrolled(int amount) {
        return this.processor.scrolled(amount);
    }
}

