/*
 * Decompiled with CFR 0.152.
 */
package squidpony.squidgrid.gui.gdx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import squidpony.panel.IColoredString;
import squidpony.panel.ISquidPanel;
import squidpony.squidgrid.Direction;
import squidpony.squidgrid.gui.gdx.AnimatedEntity;
import squidpony.squidgrid.gui.gdx.DefaultResources;
import squidpony.squidgrid.gui.gdx.TextCellFactory;
import squidpony.squidmath.Coord;
import squidpony.squidmath.StatefulRNG;

public class SquidPanel
extends Group
implements ISquidPanel<Color> {
    public float DEFAULT_ANIMATION_DURATION = 0.12f;
    private int animationCount = 0;
    private Color defaultForeground = Color.WHITE;
    private final int gridWidth;
    private final int gridHeight;
    private final int cellWidth;
    private final int cellHeight;
    private String[][] contents;
    private int[][] colors;
    private final TextCellFactory textFactory;
    private LinkedHashSet<AnimatedEntity> animatedEntities;

    public SquidPanel(int gridWidth, int gridHeight) {
        this(gridWidth, gridHeight, new TextCellFactory().defaultSquareFont());
    }

    public SquidPanel(int gridWidth, int gridHeight, int cellWidth, int cellHeight) {
        this(gridWidth, gridHeight, new TextCellFactory().defaultSquareFont().width(cellWidth).height(cellHeight));
    }

    public SquidPanel(int gridWidth, int gridHeight, TextCellFactory factory) {
        this.gridWidth = gridWidth;
        this.gridHeight = gridHeight;
        this.textFactory = factory;
        if (factory == null) {
            factory = new TextCellFactory();
        }
        if (!factory.initialized()) {
            factory.initByFont();
        }
        this.cellWidth = factory.width();
        this.cellHeight = factory.height();
        this.contents = new String[gridWidth][gridHeight];
        this.colors = new int[gridWidth][gridHeight];
        int w = gridWidth * this.cellWidth;
        int h = gridHeight * this.cellHeight;
        this.setSize(w, h);
        this.animatedEntities = new LinkedHashSet();
    }

    public void put(char[][] chars) {
        this.put(0, 0, chars);
    }

    public void put(char[][] chars, Color[][] foregrounds) {
        this.put(0, 0, chars, foregrounds);
    }

    public void put(char[][] chars, int[][] indices, ArrayList<Color> palette) {
        this.put(0, 0, chars, indices, palette);
    }

    public void put(int xOffset, int yOffset, char[][] chars) {
        this.put(xOffset, yOffset, chars, this.defaultForeground);
    }

    public void put(int xOffset, int yOffset, char[][] chars, Color[][] foregrounds) {
        for (int x = xOffset; x < xOffset + chars.length; ++x) {
            for (int y = yOffset; y < yOffset + chars[0].length; ++y) {
                if (x < 0 || y < 0 || x >= this.gridWidth || y >= this.gridHeight) continue;
                this.put(x, y, chars[x - xOffset][y - yOffset], foregrounds[x - xOffset][y - yOffset]);
            }
        }
    }

    public void put(int xOffset, int yOffset, char[][] chars, int[][] indices, ArrayList<Color> palette) {
        for (int x = xOffset; x < xOffset + chars.length; ++x) {
            for (int y = yOffset; y < yOffset + chars[0].length; ++y) {
                if (x < 0 || y < 0 || x >= this.gridWidth || y >= this.gridHeight) continue;
                this.put(x, y, chars[x - xOffset][y - yOffset], palette.get(indices[x - xOffset][y - yOffset]));
            }
        }
    }

    public void put(int xOffset, int yOffset, Color[][] foregrounds) {
        for (int x = xOffset; x < xOffset + foregrounds.length; ++x) {
            for (int y = yOffset; y < yOffset + foregrounds[0].length; ++y) {
                if (x < 0 || y < 0 || x >= this.gridWidth || y >= this.gridHeight) continue;
                this.put(x, y, '\u0000', foregrounds[x - xOffset][y - yOffset]);
            }
        }
    }

    public void put(int xOffset, int yOffset, int[][] indices, ArrayList<Color> palette) {
        for (int x = xOffset; x < xOffset + indices.length; ++x) {
            for (int y = yOffset; y < yOffset + indices[0].length; ++y) {
                if (x < 0 || y < 0 || x >= this.gridWidth || y >= this.gridHeight) continue;
                this.put(x, y, '\u0000', palette.get(indices[x - xOffset][y - yOffset]));
            }
        }
    }

    public void put(int xOffset, int yOffset, char[][] chars, Color foreground) {
        for (int x = xOffset; x < xOffset + chars.length; ++x) {
            for (int y = yOffset; y < yOffset + chars[0].length; ++y) {
                if (x < 0 || y < 0 || x >= this.gridWidth || y >= this.gridHeight) continue;
                this.put(x, y, chars[x - xOffset][y - yOffset], foreground);
            }
        }
    }

    public void put(int xOffset, int yOffset, String string) {
        this.put(xOffset, yOffset, string, this.defaultForeground);
    }

    public void put(int xOffset, int yOffset, IColoredString<? extends Color> cs) {
        int x = xOffset;
        for (IColoredString.Bucket fragment : cs) {
            String s = fragment.getText();
            Color color = (Color)fragment.getColor();
            this.put(x, yOffset, s, color == null ? this.getDefaultForegroundColor() : color);
            x += s.length();
        }
    }

    public void put(int xOffset, int yOffset, String string, Color foreground) {
        char[][] temp = new char[string.length()][1];
        for (int i = 0; i < string.length(); ++i) {
            temp[i][0] = string.charAt(i);
        }
        this.put(xOffset, yOffset, temp, foreground);
    }

    public void placeVerticalString(int xOffset, int yOffset, String string, boolean vertical) {
        this.put(xOffset, yOffset, string, this.defaultForeground, vertical);
    }

    public void put(int xOffset, int yOffset, String string, Color foreground, boolean vertical) {
        if (vertical) {
            this.put(xOffset, yOffset, (char[][])new char[][]{string.toCharArray()}, foreground);
        } else {
            this.put(xOffset, yOffset, string, foreground);
        }
    }

    public void erase() {
        for (int i = 0; i < this.contents.length; ++i) {
            for (int j = 0; j < this.contents[i].length; ++j) {
                this.contents[i][j] = "";
                this.colors[i][j] = -16777216;
            }
        }
    }

    public void clear(int x, int y) {
        this.put(x, y, Color.CLEAR);
    }

    public void put(int x, int y, Color color) {
        this.put(x, y, '\u0000', color);
    }

    public void put(int x, int y, char c) {
        this.put(x, y, c, this.defaultForeground);
    }

    public void put(int x, int y, int code) {
        this.put(x, y, code, this.defaultForeground);
    }

    public void put(int x, int y, int c, Color color) {
        this.put(x, y, String.valueOf(Character.toChars(c)), color);
    }

    public void put(int x, int y, int index, ArrayList<Color> palette) {
        this.put(x, y, palette.get(index));
    }

    public void put(int x, int y, char c, int index, ArrayList<Color> palette) {
        this.put(x, y, c, palette.get(index));
    }

    public void put(int x, int y, char c, Color color) {
        if (x < 0 || x >= this.gridWidth || y < 0 || y >= this.gridHeight) {
            return;
        }
        this.contents[x][y] = String.valueOf(c);
        this.colors[x][y] = Color.rgba8888((Color)color);
    }

    public int cellWidth() {
        return this.cellWidth;
    }

    public int cellHeight() {
        return this.cellHeight;
    }

    public int gridHeight() {
        return this.gridHeight;
    }

    public int gridWidth() {
        return this.gridWidth;
    }

    public void draw(Batch batch, float parentAlpha) {
        Color tmp = new Color();
        for (int x = 0; x < this.gridWidth; ++x) {
            for (int y = 0; y < this.gridHeight; ++y) {
                Color.rgba8888ToColor((Color)tmp, (int)this.colors[x][y]);
                this.textFactory.draw(batch, this.contents[x][y], tmp, (float)(x * this.cellWidth), (float)((this.gridHeight - y) * this.cellHeight));
            }
        }
        super.draw(batch, parentAlpha);
        for (AnimatedEntity ae : this.animatedEntities) {
            ae.actor.act(Gdx.graphics.getDeltaTime());
        }
    }

    public void drawActor(Batch batch, float parentAlpha, AnimatedEntity ae) {
        ae.actor.draw(batch, parentAlpha);
    }

    public void setDefaultForeground(Color defaultForeground) {
        this.defaultForeground = defaultForeground;
    }

    public Color getDefaultForegroundColor() {
        return this.defaultForeground;
    }

    public AnimatedEntity getAnimatedEntityByCell(int x, int y) {
        for (AnimatedEntity ae : this.animatedEntities) {
            if (ae.gridX != x || ae.gridY != y) continue;
            return ae;
        }
        return null;
    }

    public AnimatedEntity animateActor(int x, int y, char c, Color color) {
        Actor a = this.textFactory.makeActor("" + c, color);
        a.setName("" + c);
        a.setPosition((float)(x * this.cellWidth), (float)((this.gridHeight - y - 1) * this.cellHeight - 1));
        AnimatedEntity ae = new AnimatedEntity(a, x, y);
        this.animatedEntities.add(ae);
        return ae;
    }

    public AnimatedEntity animateActor(int x, int y, boolean doubleWidth, char c, Color color) {
        Actor a = this.textFactory.makeActor("" + c, color);
        a.setName("" + c);
        if (doubleWidth) {
            a.setPosition((float)(x * 2 * this.cellWidth), (float)((this.gridHeight - y - 1) * this.cellHeight - 1));
        } else {
            a.setPosition((float)(x * this.cellWidth), (float)((this.gridHeight - y - 1) * this.cellHeight - 1));
        }
        AnimatedEntity ae = new AnimatedEntity(a, x, y);
        this.animatedEntities.add(ae);
        return ae;
    }

    public AnimatedEntity animateActor(int x, int y, String s, Color color) {
        Actor a = this.textFactory.makeActor(s, color);
        a.setName(s);
        a.setPosition((float)(x * this.cellWidth), (float)((this.gridHeight - y - 1) * this.cellHeight - 1));
        AnimatedEntity ae = new AnimatedEntity(a, x, y);
        this.animatedEntities.add(ae);
        return ae;
    }

    public AnimatedEntity animateActor(int x, int y, boolean doubleWidth, String s, Color color) {
        Actor a = this.textFactory.makeActor(s, color);
        a.setName(s);
        if (doubleWidth) {
            a.setPosition((float)(x * 2 * this.cellWidth), (float)((this.gridHeight - y - 1) * this.cellHeight - 1));
        } else {
            a.setPosition((float)(x * this.cellWidth), (float)((this.gridHeight - y - 1) * this.cellHeight - 1));
        }
        AnimatedEntity ae = new AnimatedEntity(a, x, y, doubleWidth);
        this.animatedEntities.add(ae);
        return ae;
    }

    public AnimatedEntity animateActor(int x, int y, char c, int index, ArrayList<Color> palette) {
        return this.animateActor(x, y, c, palette.get(index));
    }

    public AnimatedEntity animateActor(int x, int y, String s, int index, ArrayList<Color> palette) {
        return this.animateActor(x, y, s, palette.get(index));
    }

    public AnimatedEntity animateActor(int x, int y, TextureRegion texture) {
        Actor a = this.textFactory.makeActor(texture, Color.WHITE);
        a.setName("");
        a.setPosition((float)(x * this.cellWidth), (float)((this.gridHeight - y - 1) * this.cellHeight - 1));
        AnimatedEntity ae = new AnimatedEntity(a, x, y);
        this.animatedEntities.add(ae);
        return ae;
    }

    public AnimatedEntity animateActor(int x, int y, TextureRegion texture, Color color) {
        Actor a = this.textFactory.makeActor(texture, color);
        a.setName("");
        a.setPosition((float)(x * this.cellWidth), (float)((this.gridHeight - y - 1) * this.cellHeight - 1));
        AnimatedEntity ae = new AnimatedEntity(a, x, y);
        this.animatedEntities.add(ae);
        return ae;
    }

    public AnimatedEntity animateActor(int x, int y, boolean doubleWidth, TextureRegion texture) {
        Actor a = this.textFactory.makeActor(texture, Color.WHITE, (doubleWidth ? 2 : 1) * this.cellWidth, this.cellHeight);
        a.setName("");
        if (doubleWidth) {
            a.setPosition((float)(x * 2 * this.cellWidth), (float)((this.gridHeight - y - 1) * this.cellHeight - 1));
        } else {
            a.setPosition((float)(x * this.cellWidth), (float)((this.gridHeight - y - 1) * this.cellHeight - 1));
        }
        AnimatedEntity ae = new AnimatedEntity(a, x, y, doubleWidth);
        this.animatedEntities.add(ae);
        return ae;
    }

    public AnimatedEntity animateActor(int x, int y, boolean doubleWidth, TextureRegion texture, Color color) {
        Actor a = this.textFactory.makeActor(texture, color, (doubleWidth ? 2 : 1) * this.cellWidth, this.cellHeight);
        a.setName("");
        if (doubleWidth) {
            a.setPosition((float)(x * 2 * this.cellWidth), (float)((this.gridHeight - y - 1) * this.cellHeight - 1));
        } else {
            a.setPosition((float)(x * this.cellWidth), (float)((this.gridHeight - y - 1) * this.cellHeight - 1));
        }
        AnimatedEntity ae = new AnimatedEntity(a, x, y, doubleWidth);
        this.animatedEntities.add(ae);
        return ae;
    }

    public AnimatedEntity animateActor(int x, int y, boolean doubleWidth, boolean stretch, TextureRegion texture) {
        Actor a = stretch ? this.textFactory.makeActor(texture, Color.WHITE, (doubleWidth ? 2 : 1) * this.cellWidth, this.cellHeight) : this.textFactory.makeActor(texture, Color.WHITE, texture.getRegionWidth(), texture.getRegionHeight());
        a.setName("");
        if (doubleWidth) {
            a.setPosition((float)(x * 2 * this.cellWidth), (float)((this.gridHeight - y - 1) * this.cellHeight - 1));
        } else {
            a.setPosition((float)(x * this.cellWidth), (float)((this.gridHeight - y - 1) * this.cellHeight - 1));
        }
        AnimatedEntity ae = new AnimatedEntity(a, x, y, doubleWidth);
        this.animatedEntities.add(ae);
        return ae;
    }

    public AnimatedEntity animateActor(int x, int y, boolean doubleWidth, boolean stretch, TextureRegion texture, Color color) {
        Actor a = stretch ? this.textFactory.makeActor(texture, color, (doubleWidth ? 2 : 1) * this.cellWidth, this.cellHeight) : this.textFactory.makeActor(texture, color, texture.getRegionWidth(), texture.getRegionHeight());
        a.setName("");
        if (doubleWidth) {
            a.setPosition((float)(x * 2 * this.cellWidth), (float)((this.gridHeight - y - 1) * this.cellHeight - 1));
        } else {
            a.setPosition((float)(x * this.cellWidth), (float)((this.gridHeight - y - 1) * this.cellHeight - 1));
        }
        AnimatedEntity ae = new AnimatedEntity(a, x, y, doubleWidth);
        this.animatedEntities.add(ae);
        return ae;
    }

    public Actor cellToActor(int x, int y) {
        if (this.contents[x][y] == null || this.contents[x][y].equals("")) {
            return null;
        }
        Actor a = this.textFactory.makeActor(this.contents[x][y], new Color(this.colors[x][y]));
        a.setName(this.contents[x][y]);
        a.setPosition((float)(x * this.cellWidth), (float)((this.gridHeight - y - 1) * this.cellHeight - 1));
        this.addActor(a);
        this.contents[x][y] = "";
        return a;
    }

    public Actor cellToActor(int x, int y, boolean doubleWidth) {
        if (this.contents[x][y] == null || this.contents[x][y].equals("")) {
            return null;
        }
        Actor a = this.textFactory.makeActor(this.contents[x][y], new Color(this.colors[x][y]));
        a.setName(this.contents[x][y]);
        if (doubleWidth) {
            a.setPosition((float)(x * 2 * this.cellWidth), (float)((this.gridHeight - y - 1) * this.cellHeight - 1));
        } else {
            a.setPosition((float)(x * this.cellWidth), (float)((this.gridHeight - y - 1) * this.cellHeight - 1));
        }
        this.addActor(a);
        this.contents[x][y] = "";
        return a;
    }

    public void recallActor(Actor a) {
        int x = Math.round(a.getX() / (float)this.cellWidth);
        int y = this.gridHeight - Math.round(a.getY() / (float)this.cellHeight) - 1;
        this.contents[x][y] = a.getName();
        --this.animationCount;
        this.removeActor(a);
    }

    public void recallActor(AnimatedEntity ae) {
        ae.gridX = ae.doubleWidth ? Math.round(ae.actor.getX() / (float)(2 * this.cellWidth)) : Math.round(ae.actor.getX() / (float)this.cellWidth);
        ae.gridY = this.gridHeight - Math.round(ae.actor.getY() / (float)this.cellHeight) - 1;
        ae.animating = false;
        --this.animationCount;
    }

    public void bump(final AnimatedEntity ae, Direction direction, float duration) {
        Actor a = ae.actor;
        int x = ae.gridX * this.cellWidth;
        int y = (this.gridHeight - ae.gridY - 1) * this.cellHeight - 1;
        if (a == null || ae.animating) {
            return;
        }
        if (duration < 0.02f) {
            duration = 0.02f;
        }
        ++this.animationCount;
        ae.animating = true;
        a.addAction((Action)Actions.sequence((Action)Actions.moveToAligned((float)((float)x + (float)direction.deltaX / 3.0f * (ae.doubleWidth ? 2.0f : 1.0f)), (float)((float)y + (float)direction.deltaY / 3.0f), (int)1, (float)(duration * 0.35f)), (Action)Actions.moveToAligned((float)x, (float)y, (int)12, (float)(duration * 0.65f)), (Action)Actions.delay((float)duration, (Action)Actions.run((Runnable)new Runnable(){

            @Override
            public void run() {
                SquidPanel.this.recallActor(ae);
            }
        }))));
    }

    public void bump(int x, int y, Direction direction, float duration) {
        final Actor a = this.cellToActor(x, y);
        if (a == null) {
            return;
        }
        if (duration < 0.02f) {
            duration = 0.02f;
        }
        ++this.animationCount;
        y = this.gridHeight - y - 1;
        y *= this.cellHeight;
        a.addAction((Action)Actions.sequence((Action)Actions.moveToAligned((float)((float)(x *= this.cellWidth) + (float)direction.deltaX / 3.0f), (float)((float)(--y) + (float)direction.deltaY / 3.0f), (int)1, (float)(duration * 0.35f)), (Action)Actions.moveToAligned((float)x, (float)y, (int)12, (float)(duration * 0.65f)), (Action)Actions.delay((float)duration, (Action)Actions.run((Runnable)new Runnable(){

            @Override
            public void run() {
                SquidPanel.this.recallActor(a);
            }
        }))));
    }

    public void bump(int x, int y, Direction direction) {
        this.bump(x, y, direction, this.DEFAULT_ANIMATION_DURATION);
    }

    public void bump(Coord location, Direction direction) {
        this.bump(location.x, location.y, direction, this.DEFAULT_ANIMATION_DURATION);
    }

    public void slide(final AnimatedEntity ae, int newX, int newY, float duration) {
        Actor a = ae.actor;
        int nextX = newX * this.cellWidth * (ae.doubleWidth ? 2 : 1);
        int nextY = (this.gridHeight - newY - 1) * this.cellHeight - 1;
        if (a == null || ae.animating) {
            return;
        }
        if (duration < 0.02f) {
            duration = 0.02f;
        }
        ++this.animationCount;
        ae.animating = true;
        a.addAction((Action)Actions.sequence((Action)Actions.moveToAligned((float)nextX, (float)nextY, (int)12, (float)duration), (Action)Actions.delay((float)duration, (Action)Actions.run((Runnable)new Runnable(){

            @Override
            public void run() {
                SquidPanel.this.recallActor(ae);
            }
        }))));
    }

    public void slide(int x, int y, int newX, int newY, float duration) {
        final Actor a = this.cellToActor(x, y);
        if (a == null) {
            return;
        }
        if (duration < 0.02f) {
            duration = 0.02f;
        }
        ++this.animationCount;
        newY = this.gridHeight - newY - 1;
        newY *= this.cellHeight;
        a.addAction((Action)Actions.sequence((Action)Actions.moveToAligned((float)(newX *= this.cellWidth), (float)(--newY), (int)12, (float)duration), (Action)Actions.delay((float)duration, (Action)Actions.run((Runnable)new Runnable(){

            @Override
            public void run() {
                SquidPanel.this.recallActor(a);
            }
        }))));
    }

    public void slide(Coord start, Coord end) {
        this.slide(start.x, start.y, end.x, end.y, this.DEFAULT_ANIMATION_DURATION);
    }

    public void slide(Coord start, Direction direction) {
        this.slide(start.x, start.y, start.x + direction.deltaX, start.y + direction.deltaY, this.DEFAULT_ANIMATION_DURATION);
    }

    public void slide(Coord start, Coord end, float duration) {
        this.slide(start.x, start.y, end.x, end.y, duration);
    }

    public void wiggle(final AnimatedEntity ae, float duration) {
        Actor a = ae.actor;
        int x = ae.gridX * this.cellWidth * (ae.doubleWidth ? 2 : 1);
        int y = (this.gridHeight - ae.gridY - 1) * this.cellHeight - 1;
        if (a == null || ae.animating) {
            return;
        }
        if (duration < 0.02f) {
            duration = 0.02f;
        }
        ae.animating = true;
        ++this.animationCount;
        StatefulRNG gRandom = DefaultResources.getGuiRandom();
        a.addAction((Action)Actions.sequence((Action[])new Action[]{Actions.moveToAligned((float)((float)x + (gRandom.nextFloat() - 0.5f) * (float)this.cellWidth * 0.4f), (float)((float)y + (gRandom.nextFloat() - 0.5f) * (float)this.cellHeight * 0.4f), (int)12, (float)(duration * 0.2f)), Actions.moveToAligned((float)((float)x + (gRandom.nextFloat() - 0.5f) * (float)this.cellWidth * 0.4f), (float)((float)y + (gRandom.nextFloat() - 0.5f) * (float)this.cellHeight * 0.4f), (int)12, (float)(duration * 0.2f)), Actions.moveToAligned((float)((float)x + (gRandom.nextFloat() - 0.5f) * (float)this.cellWidth * 0.4f), (float)((float)y + (gRandom.nextFloat() - 0.5f) * (float)this.cellHeight * 0.4f), (int)12, (float)(duration * 0.2f)), Actions.moveToAligned((float)((float)x + (gRandom.nextFloat() - 0.5f) * (float)this.cellWidth * 0.4f), (float)((float)y + (gRandom.nextFloat() - 0.5f) * (float)this.cellHeight * 0.4f), (int)12, (float)(duration * 0.2f)), Actions.moveToAligned((float)x, (float)y, (int)12, (float)(duration * 0.2f)), Actions.delay((float)duration, (Action)Actions.run((Runnable)new Runnable(){

            @Override
            public void run() {
                SquidPanel.this.recallActor(ae);
            }
        }))}));
    }

    public void wiggle(int x, int y, float duration) {
        final Actor a = this.cellToActor(x, y);
        if (a == null) {
            return;
        }
        if (duration < 0.02f) {
            duration = 0.02f;
        }
        ++this.animationCount;
        y = this.gridHeight - y - 1;
        y *= this.cellHeight;
        StatefulRNG gRandom = DefaultResources.getGuiRandom();
        a.addAction((Action)Actions.sequence((Action[])new Action[]{Actions.moveToAligned((float)((float)(x *= this.cellWidth) + (gRandom.nextFloat() - 0.5f) * (float)this.cellWidth * 0.4f), (float)((float)(--y) + (gRandom.nextFloat() - 0.5f) * (float)this.cellHeight * 0.4f), (int)12, (float)(duration * 0.2f)), Actions.moveToAligned((float)((float)x + (gRandom.nextFloat() - 0.5f) * (float)this.cellWidth * 0.4f), (float)((float)y + (gRandom.nextFloat() - 0.5f) * (float)this.cellHeight * 0.4f), (int)12, (float)(duration * 0.2f)), Actions.moveToAligned((float)((float)x + (gRandom.nextFloat() - 0.5f) * (float)this.cellWidth * 0.4f), (float)((float)y + (gRandom.nextFloat() - 0.5f) * (float)this.cellHeight * 0.4f), (int)12, (float)(duration * 0.2f)), Actions.moveToAligned((float)((float)x + (gRandom.nextFloat() - 0.5f) * (float)this.cellWidth * 0.4f), (float)((float)y + (gRandom.nextFloat() - 0.5f) * (float)this.cellHeight * 0.4f), (int)12, (float)(duration * 0.2f)), Actions.moveToAligned((float)x, (float)y, (int)12, (float)(duration * 0.2f)), Actions.delay((float)duration, (Action)Actions.run((Runnable)new Runnable(){

            @Override
            public void run() {
                SquidPanel.this.recallActor(a);
            }
        }))}));
    }

    public void tint(final AnimatedEntity ae, Color color, float duration) {
        Actor a = ae.actor;
        if (a == null || ae.animating) {
            return;
        }
        if (duration < 0.02f) {
            duration = 0.02f;
        }
        ae.animating = true;
        ++this.animationCount;
        Color ac = a.getColor().cpy();
        a.addAction((Action)Actions.sequence((Action)Actions.color((Color)color, (float)(duration * 0.3f)), (Action)Actions.color((Color)ac, (float)(duration * 0.7f)), (Action)Actions.delay((float)duration, (Action)Actions.run((Runnable)new Runnable(){

            @Override
            public void run() {
                SquidPanel.this.recallActor(ae);
            }
        }))));
    }

    public void tint(int x, int y, Color color, float duration) {
        final Actor a = this.cellToActor(x, y);
        if (a == null) {
            return;
        }
        if (duration < 0.02f) {
            duration = 0.02f;
        }
        ++this.animationCount;
        Color ac = a.getColor().cpy();
        a.addAction((Action)Actions.sequence((Action)Actions.color((Color)color, (float)(duration * 0.3f)), (Action)Actions.color((Color)ac, (float)(duration * 0.7f)), (Action)Actions.delay((float)duration, (Action)Actions.run((Runnable)new Runnable(){

            @Override
            public void run() {
                SquidPanel.this.recallActor(a);
            }
        }))));
    }

    public boolean hasActiveAnimations() {
        return this.animationCount != 0;
    }

    public LinkedHashSet<AnimatedEntity> getAnimatedEntities() {
        return this.animatedEntities;
    }

    public void refresh() {
    }

    public ISquidPanel<Color> getBacker() {
        return this;
    }
}

