/*
 * Decompiled with CFR 0.152.
 */
package squidpony.squidgrid.gui.gdx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import squidpony.squidgrid.gui.gdx.DefaultResources;

public class TextCellFactory {
    public static final String DEFAULT_FITTING = "@!#$%^&*()_+1234567890-=~ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz;:,'\"{}?/\\ ";
    public static final String LINE_FITTING = "\u253c\u251c\u2524\u2534\u252c\u250c\u2510\u2514\u2518\u2502\u2500";
    public static final String SQUID_FITTING = "@!#$%^&*()_+1234567890-=~ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz;:,'\"{}?/\\ \u253c\u251c\u2524\u2534\u252c\u250c\u2510\u2514\u2518\u2502\u2500";
    protected BitmapFont bmpFont = null;
    protected Texture block = null;
    protected String fitting = "@!#$%^&*()_+1234567890-=~ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz;:,'\"{}?/\\ \u253c\u251c\u2524\u2534\u252c\u250c\u2510\u2514\u2518\u2502\u2500";
    protected int leftPadding = 0;
    protected int rightPadding = 0;
    protected int topPadding = 0;
    protected int bottomPadding = 0;
    protected int width = 1;
    protected int height = 1;
    private boolean initialized = false;

    public TextCellFactory initByFont() {
        this.bmpFont.setFixedWidthGlyphs((CharSequence)this.fitting);
        this.width = (int)this.bmpFont.getSpaceWidth();
        this.height = (int)this.bmpFont.getLineHeight();
        Pixmap temp = new Pixmap(1, 1, Pixmap.Format.RGBA8888);
        temp.setColor(Color.WHITE);
        temp.fill();
        this.block = new Texture(1, 1, Pixmap.Format.RGBA8888);
        this.block.draw(temp, 0, 0);
        temp.dispose();
        this.initialized = true;
        return this;
    }

    public TextCellFactory initBySize() {
        this.bmpFont.setFixedWidthGlyphs((CharSequence)this.fitting);
        Pixmap temp = new Pixmap(1, 1, Pixmap.Format.RGBA8888);
        temp.setColor(Color.WHITE);
        temp.fill();
        this.block = new Texture(1, 1, Pixmap.Format.RGBA8888);
        this.block.draw(temp, 0, 0);
        temp.dispose();
        this.initialized = true;
        return this;
    }

    public TextCellFactory initVerbatim() {
        return this.initBySize();
    }

    public BitmapFont font() {
        return this.bmpFont;
    }

    public TextCellFactory font(String fontpath) {
        this.bmpFont = new BitmapFont(Gdx.files.internal(fontpath));
        return this;
    }

    public TextCellFactory defaultNarrowFont() {
        this.bmpFont = DefaultResources.getLargeNarrowFont();
        return this;
    }

    public TextCellFactory defaultSquareFont() {
        this.bmpFont = DefaultResources.getDefaultFont();
        return this;
    }

    public int width() {
        return this.width;
    }

    public TextCellFactory width(int width) {
        this.width = Math.max(1, width);
        return this;
    }

    public int height() {
        return this.height;
    }

    public TextCellFactory height(int height) {
        this.height = Math.max(1, height);
        return this;
    }

    public String fit() {
        return this.fitting;
    }

    public TextCellFactory fit(String fit) {
        this.fitting = fit;
        this.bmpFont.setFixedWidthGlyphs((CharSequence)this.fitting);
        this.width = (int)this.bmpFont.getSpaceWidth();
        return this;
    }

    public TextCellFactory addFit(String fit) {
        this.fitting = this.fitting + fit;
        this.bmpFont.setFixedWidthGlyphs((CharSequence)this.fitting);
        this.width = (int)this.bmpFont.getSpaceWidth();
        return this;
    }

    public boolean antialias() {
        return true;
    }

    public TextCellFactory antialias(boolean antialias) {
        return this;
    }

    public TextCellFactory padding(int padding) {
        this.leftPadding = padding;
        this.rightPadding = padding;
        this.topPadding = padding;
        this.bottomPadding = padding;
        return this;
    }

    public int leftPadding() {
        return this.leftPadding;
    }

    public TextCellFactory leftPadding(int padding) {
        this.leftPadding = padding;
        return this;
    }

    public int rightPadding() {
        return this.rightPadding;
    }

    public TextCellFactory rightPadding(int padding) {
        this.rightPadding = padding;
        return this;
    }

    public int topPadding() {
        return this.topPadding;
    }

    public TextCellFactory topPadding(int padding) {
        this.topPadding = padding;
        return this;
    }

    public int bottomPadding() {
        return this.bottomPadding;
    }

    public TextCellFactory bottomPadding(int padding) {
        this.bottomPadding = padding;
        return this;
    }

    public boolean initialized() {
        return this.initialized;
    }

    public boolean willFit(int codepoint) {
        if (!this.initialized) {
            throw new IllegalStateException("This factory has not yet been initialized!");
        }
        if (!Character.isValidCodePoint(codepoint) || Character.isISOControl(codepoint)) {
            return true;
        }
        return this.fitting.contains(String.valueOf(Character.toChars(codepoint)));
    }

    public void draw(Batch batch, String s, float x, float y) {
        if (!this.initialized) {
            throw new IllegalStateException("This factory has not yet been initialized!");
        }
        if (s == null) {
            batch.draw(this.block, x, y - (float)this.height, (float)this.width, (float)this.height);
        } else if (s.length() > 0 && s.charAt(0) == '\u0000') {
            batch.draw(this.block, x, y - (float)this.height, (float)(this.width * s.length()), (float)this.height);
        } else {
            this.bmpFont.draw(batch, (CharSequence)s, x, y - this.bmpFont.getDescent(), (float)(this.width * s.length()), 1, false);
        }
    }

    public void draw(Batch batch, String s, float r, float g, float b, float a, float x, float y) {
        if (!this.initialized) {
            throw new IllegalStateException("This factory has not yet been initialized!");
        }
        if (s == null) {
            Color orig = batch.getColor();
            batch.setColor(r, g, b, a);
            batch.draw(this.block, x, y - (float)this.height, (float)this.width, (float)this.height);
            batch.setColor(orig);
        } else if (s.length() > 0 && s.charAt(0) == '\u0000') {
            Color orig = batch.getColor();
            batch.setColor(r, g, b, a);
            batch.draw(this.block, x, y - (float)this.height, (float)(this.width * s.length()), (float)this.height);
            batch.setColor(orig);
        } else {
            this.bmpFont.setColor(r, g, b, a);
            this.bmpFont.draw(batch, (CharSequence)s, x, y - this.bmpFont.getDescent(), (float)(this.width * s.length()), 1, false);
        }
    }

    public void draw(Batch batch, String s, Color color, float x, float y) {
        if (!this.initialized) {
            throw new IllegalStateException("This factory has not yet been initialized!");
        }
        this.bmpFont.setColor(color);
        if (s == null) {
            Color orig = batch.getColor();
            batch.setColor(color);
            batch.draw(this.block, x, y - (float)this.height, (float)this.width, (float)this.height);
            batch.setColor(orig);
        } else if (s.length() > 0 && s.charAt(0) == '\u0000') {
            Color orig = batch.getColor();
            batch.setColor(color);
            batch.draw(this.block, x, y - (float)this.height, (float)(this.width * s.length()), (float)this.height);
            batch.setColor(orig);
        } else {
            this.bmpFont.setColor(color);
            this.bmpFont.draw(batch, (CharSequence)s, x, y - this.bmpFont.getDescent(), (float)(this.width * s.length()), 1, false);
        }
    }

    public void draw(Batch batch, TextureRegion tr, float x, float y) {
        if (!this.initialized) {
            throw new IllegalStateException("This factory has not yet been initialized!");
        }
        if (tr == null) {
            batch.draw(this.block, x, y - (float)this.height, (float)this.width, (float)this.height);
        } else {
            batch.draw(tr, x, y - (float)this.height, (float)this.width, (float)this.height);
        }
    }

    public void draw(Batch batch, TextureRegion tr, float r, float g, float b, float a, float x, float y) {
        if (!this.initialized) {
            throw new IllegalStateException("This factory has not yet been initialized!");
        }
        if (tr == null) {
            Color orig = batch.getColor();
            batch.setColor(r, g, b, a);
            batch.draw(this.block, x, y - (float)this.height, (float)this.width, (float)this.height);
            batch.setColor(orig);
        } else {
            Color orig = batch.getColor();
            batch.setColor(r, g, b, a);
            batch.draw(tr, x, y - (float)this.height, (float)this.width, (float)this.height);
            batch.setColor(orig);
        }
    }

    public void draw(Batch batch, TextureRegion tr, Color color, float x, float y) {
        if (!this.initialized) {
            throw new IllegalStateException("This factory has not yet been initialized!");
        }
        this.bmpFont.setColor(color);
        if (tr == null) {
            Color orig = batch.getColor();
            batch.setColor(color);
            batch.draw(this.block, x, y - (float)this.height, (float)this.width, (float)this.height);
            batch.setColor(orig);
        } else {
            Color orig = batch.getColor();
            batch.setColor(color);
            batch.draw(tr, x, y - (float)this.height, (float)this.width, (float)this.height);
            batch.setColor(orig);
        }
    }

    public void draw(Batch batch, TextureRegion tr, float x, float y, float width, float height) {
        if (!this.initialized) {
            throw new IllegalStateException("This factory has not yet been initialized!");
        }
        if (tr == null) {
            batch.draw(this.block, x, y - height, width, height);
        } else {
            batch.draw(tr, x, y - height, width, height);
        }
    }

    public void draw(Batch batch, TextureRegion tr, float r, float g, float b, float a, float x, float y, float width, float height) {
        if (!this.initialized) {
            throw new IllegalStateException("This factory has not yet been initialized!");
        }
        if (tr == null) {
            Color orig = batch.getColor();
            batch.setColor(r, g, b, a);
            batch.draw(this.block, x, y - height, width, height);
            batch.setColor(orig);
        } else {
            Color orig = batch.getColor();
            batch.setColor(r, g, b, a);
            batch.draw(tr, x, y - height, width, height);
            batch.setColor(orig);
        }
    }

    public void draw(Batch batch, TextureRegion tr, Color color, float x, float y, float width, float height) {
        if (!this.initialized) {
            throw new IllegalStateException("This factory has not yet been initialized!");
        }
        if (tr == null) {
            Color orig = batch.getColor();
            batch.setColor(color);
            batch.draw(this.block, x, y - height, width, height);
            batch.setColor(orig);
        } else {
            Color orig = batch.getColor();
            batch.setColor(color);
            batch.draw(tr, x, y - height, width, height);
            batch.setColor(orig);
        }
    }

    public Actor makeActor(String s, Color color) {
        if (!this.initialized) {
            throw new IllegalStateException("This factory has not yet been initialized!");
        }
        if (s == null) {
            Image im = new Image(this.block);
            im.setColor(color);
            im.setSize((float)this.width, (float)this.height);
            return im;
        }
        if (s.length() > 0 && s.charAt(0) == '\u0000') {
            Image im = new Image(this.block);
            im.setColor(color);
            im.setSize((float)(this.width * s.length()), (float)this.height);
            return im;
        }
        Label lb = new Label((CharSequence)s, new Label.LabelStyle(this.bmpFont, null));
        lb.setColor(color);
        return lb;
    }

    public Actor makeActor(TextureRegion tr, Color color) {
        if (!this.initialized) {
            throw new IllegalStateException("This factory has not yet been initialized!");
        }
        if (tr == null) {
            Image im = new Image(this.block);
            im.setColor(color);
            im.setSize((float)this.width, (float)this.height);
            return im;
        }
        Image im = new Image(tr);
        im.setColor(color);
        im.setSize((float)this.width, (float)this.height);
        return im;
    }

    public Actor makeActor(TextureRegion tr, Color color, float width, float height) {
        if (!this.initialized) {
            throw new IllegalStateException("This factory has not yet been initialized!");
        }
        if (tr == null) {
            Image im = new Image(this.block);
            im.setColor(color);
            im.setSize(width, height);
            return im;
        }
        Image im = new Image(tr);
        im.setColor(color);
        im.setSize(width, height);
        return im;
    }

    public Texture getSolid() {
        if (!this.initialized) {
            throw new IllegalStateException("This factory has not yet been initialized!");
        }
        return this.block;
    }
}

