/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.analysis.dotnet;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sourceclear.analysis.dotnet.Processes;
import com.sourceclear.analysis.utils.Utils;
import com.sourceclear.api.client.Client;
import com.sourceclear.api.client.SourceClearClient;
import com.sourceclear.api.data.generation.BuildSystemClientType;
import com.sourceclear.librarydiffs.HashedMethod;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.util.io.IO;
import com.srcclr.sdk.LibraryGraphSerializer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;

public class Executable {
    private static final String EXECUTABLE_NAME = "srcdot";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final TypeReference<Set<HashedMethod>> SET_HASHED_METHOD = new TypeReference<Set<HashedMethod>>(){};
    private static final TypeReference<Set<MethodInfo>> SET_METHOD_INFO = new TypeReference<Set<MethodInfo>>(){};
    private final Callable<String> getVersion;

    public Executable() {
        this(new SourceClearClient.Builder().withExpBackOffInitial(0).withBaseURI(URI.create("https://api.sourceclear.com")).build());
    }

    public Executable(Client client) {
        this.getVersion = () -> client.getGenerationVersion(BuildSystemClientType.DOTNET, LibraryGraphSerializer.getCurrentGeneration());
    }

    public Executable(String version) {
        this.getVersion = () -> version;
    }

    public Set<HashedMethod> computeSignature(Path dll) throws Exception {
        return this.execute("delta", dll, this::readSignature);
    }

    public Set<HashedMethod> computeSignature(InputStream i) throws Exception {
        return this.execute("delta", i, this::readSignature);
    }

    public Set<MethodInfo> getPublicMethods(Path dll) throws Exception {
        return this.execute("public-methods", dll, this::readMethods);
    }

    public Set<MethodInfo> getPublicMethods(InputStream i) throws Exception {
        return this.execute("public-methods", i, this::readMethods);
    }

    public String hash(Path dll) throws Exception {
        return this.execute("hash", dll, this::readHash);
    }

    public String hash(InputStream i) throws Exception {
        return this.execute("hash", i, this::readHash);
    }

    public long countInstructions(Path dll) throws Exception {
        return this.execute("loc", dll, this::readLoc);
    }

    public long countInstructions(InputStream i) throws Exception {
        return this.execute("loc", i, this::readLoc);
    }

    private Set<MethodInfo> readMethods(InputStream i) throws IOException {
        return (Set)MAPPER.readValue(i, SET_METHOD_INFO);
    }

    private Set<HashedMethod> readSignature(InputStream i) throws IOException {
        return (Set)MAPPER.readValue(i, SET_HASHED_METHOD);
    }

    private String readHash(InputStream i) throws IOException {
        return IOUtils.toString((InputStream)i, (Charset)StandardCharsets.UTF_8).trim();
    }

    private long readLoc(InputStream i) throws IOException {
        return Long.parseLong(IOUtils.toString((InputStream)i, (Charset)StandardCharsets.UTF_8).trim());
    }

    private <T> T execute(String subcommand, InputStream dll, Utils.CheckedFunction<InputStream, T, IOException> transformResult) throws Exception {
        Path json = Files.createTempFile(EXECUTABLE_NAME, "dll", new FileAttribute[0]);
        try (FileOutputStream o = new FileOutputStream(json.toFile());){
            IOUtils.copy((InputStream)dll, (OutputStream)o);
        }
        return this.execute(subcommand, json, transformResult);
    }

    private <T> T execute(String subcommand, Path dll, Utils.CheckedFunction<InputStream, T, IOException> transformResult) throws Exception {
        int rc;
        Path exe = this.fetchIfAbsent();
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        ArrayList<String> commandPieces = new ArrayList<String>();
        commandPieces.add(exe.toAbsolutePath().toString());
        commandPieces.add(subcommand);
        commandPieces.add(dll.toAbsolutePath().toString());
        processBuilder.command(commandPieces);
        Process process = processBuilder.start();
        T res = transformResult.apply(process.getInputStream());
        Processes.readAsync(process.getErrorStream());
        try {
            rc = process.waitFor();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        if (rc != 0) {
            throw new Exception("Nonzero exit code " + rc + " when computing " + subcommand);
        }
        return res;
    }

    private Path fetchIfAbsent() throws Exception {
        String version = this.getVersion.call();
        Path destination = this.getFullPath(version);
        if (!Files.exists(destination, new LinkOption[0])) {
            IO.downloadFileIntoDir(this.downloadUrl(version), this.versionedExecutable(version), this.destinationDirectory().toFile(), EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE), false);
        }
        return destination;
    }

    private Path getFullPath(String version) {
        return this.destinationDirectory().resolve(this.versionedExecutable(version));
    }

    private String versionedExecutable(String version) {
        return String.format("%s-%s%s", EXECUTABLE_NAME, version, SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
    }

    private Path destinationDirectory() {
        return Paths.get(System.getProperty("user.home"), new String[0]).resolve(".srcclr").resolve(EXECUTABLE_NAME);
    }

    private URL downloadUrl(String version) {
        try {
            return new URL(String.format("https://download.srcclr.com/%1$s/%2$s/%3$s/%1$s", EXECUTABLE_NAME, version, this.exeSuffix()));
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    private String exeSuffix() {
        return String.format("%s-%s", this.exePlatform(), this.exeArch());
    }

    private String exeArch() {
        return "x64";
    }

    private String exePlatform() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return "windows";
        }
        if (SystemUtils.IS_OS_MAC) {
            return "macosx";
        }
        return "linux";
    }
}

