/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.net.MediaType;
import com.sourceclear.api.client.Client;
import com.sourceclear.api.client.HTTPException;
import com.sourceclear.api.client.Response;
import com.sourceclear.api.client.ScanUsageException;
import com.sourceclear.api.data.LicenseData;
import com.sourceclear.api.data.diff.DiffQuery;
import com.sourceclear.api.data.diff.DiffResponse;
import com.sourceclear.api.data.generation.BuildSystemClientType;
import com.sourceclear.api.data.match.LibDeltaQuery;
import com.sourceclear.api.data.match.LibDeltaResponse;
import com.sourceclear.api.data.match.MatchQuery;
import com.sourceclear.api.data.match.MatchResponse;
import com.sourceclear.api.data.match.SafeVersionsQuery;
import com.sourceclear.api.data.match.SafeVersionsResponse;
import com.sourceclear.api.data.match.ScanFinishUploadResponse;
import com.sourceclear.api.data.methods.InstanceVulnMethodUpload;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceClearClient
implements Client {
    private static final Logger LOGGER = LoggerFactory.getLogger(SourceClearClient.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    static final String CLIENT_TYPE_HEADER = "X-Srcclr-Client-Type";
    static final String CLIENT_VERSION_HEADER = "X-Srcclr-Client-Version";
    static final String SRCCLR_MIN_VERSION = "X-Srcclr-Min-Version";
    private static final String APPLICATION_JSON = "application/json";
    private static final String GENERATIONS_URL_PATTERN = "/generations/%d/%s";
    private static final String POLICY_ENDPOINT_VERSION = "v1";
    private static final String GZIP = "gzip";
    private static final TypeReference<List<String>> STRING_LIST_TYPE = new TypeReference<List<String>>(){};
    private static final TypeReference<Map<String, Object>> STRING_OBJECT_MAP_TYPE = new TypeReference<Map<String, Object>>(){};
    private static final int HTTP_TOO_MANY_REQUESTS = 429;
    private static final String DEFAULT_PAYMENT_REQUIRED_MSG = "Scans cannot be performed because payment has not been received. Please ask your administrator to update the payment method on file.";
    public static final URI DEFAULT_BASE_URI = URI.create("https://api.sourceclear.io/");
    private static final ImmutableSet<Pattern> SRCCLR_PLATFORM_AUTHORITY_REGEXES = ImmutableSet.of((Object)Pattern.compile("api[^\\.]*\\.sourceclear\\.io"), (Object)Pattern.compile("api.*\\.ops2\\.srcclr\\.io"));
    private final URI baseUri;
    private final String apiToken;
    private final boolean retryNetworkErrors;
    private final int retryCount;
    private final String clientTypeHeader;
    private final String clientVersionHeader;
    private final Proxy proxy;
    private final boolean withPolicy;
    private final int expBackOffInitial;

    private SourceClearClient(Builder build) {
        this.baseUri = build.baseURI == null ? DEFAULT_BASE_URI : URI.create(build.baseURI.toString().replaceFirst("/$", "") + "/");
        this.apiToken = this.trimStringWithNullCheck(build.apiToken);
        if (null == build.retryCount) {
            this.retryNetworkErrors = false;
            this.retryCount = 0;
        } else {
            this.retryNetworkErrors = true;
            this.retryCount = build.retryCount;
        }
        this.clientTypeHeader = build.clientType != null ? build.clientType.name() : null;
        this.clientVersionHeader = SourceClearClient.isNotBlank(build.clientVersion) ? build.clientVersion : null;
        this.proxy = build.proxy;
        this.withPolicy = build.withPolicy;
        this.expBackOffInitial = build.expBackOffInitial;
    }

    @Override
    public Response<JsonNode> jsonAPI(Client.Method method, URI apiRelativeEndpoint) throws IOException, ScanUsageException {
        return this.jsonAPI(method, apiRelativeEndpoint, null);
    }

    @Override
    public Response<JsonNode> jsonAPI(Client.Method method, URI apiRelativeEndpoint, Object payload) throws IOException, ScanUsageException {
        HttpResponse<String> resp = this.jsonAPIStringResponse(method, apiRelativeEndpoint, payload);
        return new HttpResponse<JsonNode>(((HttpResponse)resp).statusCode, ((HttpResponse)resp).statusText, ((HttpResponse)resp).headers, MAPPER.readTree((String)((HttpResponse)resp).payload));
    }

    private HttpResponse<String> jsonAPIStringResponse(Client.Method method, URI apiRelativeEndpoint, Object payload) throws IOException, ScanUsageException {
        String url = this.baseUri.resolve(apiRelativeEndpoint).toString();
        HttpResponse<String> resp = this.sendJsonifiedItemToURL(method, url, payload);
        if (!this.retryNetworkErrors) {
            this.assertHttpOK(resp, String.format("Invoke %s %s", new Object[]{method, apiRelativeEndpoint}));
        }
        return resp;
    }

    @Override
    public MatchResponse match(MatchQuery query) throws IOException, ScanUsageException {
        this.assertHaveApiToken();
        String endpoint = this.withPolicy ? String.format("%s/scan", POLICY_ENDPOINT_VERSION) : "match";
        String url = this.baseUri.resolve(endpoint).toString();
        HttpResponse<String> jsonResponse = this.sendJsonifiedItemToURL(Client.Method.POST, url, query);
        this.assertHttpOK(jsonResponse, "when posting a catalog component match");
        return (MatchResponse)MAPPER.readValue((String)((HttpResponse)jsonResponse).payload, MatchResponse.class);
    }

    @Override
    public DiffResponse getScanDiff(DiffQuery query) throws IOException, ScanUsageException {
        this.assertHaveApiToken();
        String endpoint = String.format("%s/scan/diff", POLICY_ENDPOINT_VERSION);
        String url = this.baseUri.resolve(endpoint).toString();
        HttpResponse<String> jsonResponse = this.sendJsonifiedItemToURL(Client.Method.POST, url, query);
        this.assertHttpOK(jsonResponse, "when comparing the diff between 2 scans");
        return (DiffResponse)MAPPER.readValue((String)((HttpResponse)jsonResponse).payload, DiffResponse.class);
    }

    @Override
    public LicenseData license() throws IOException, ScanUsageException {
        this.assertHaveApiToken();
        String endpoint = this.withPolicy ? String.format("%s/scan/license", POLICY_ENDPOINT_VERSION) : "match/license";
        String url = this.baseUri.resolve(endpoint).toString();
        HttpResponse<String> jsonResponse = this.sendJsonifiedItemToURL(Client.Method.GET, url, null);
        this.assertHttpOK(jsonResponse, "when querying agent license data");
        return (LicenseData)MAPPER.readValue((String)((HttpResponse)jsonResponse).payload, LicenseData.class);
    }

    @Override
    public List<String> getFeaturesEnabledForOrgViaAgentAuth() throws IOException, ScanUsageException {
        this.assertHaveApiToken();
        String endpoint = String.format("%s/scan/features", POLICY_ENDPOINT_VERSION);
        String url = this.baseUri.resolve(endpoint).toString();
        HttpResponse<String> jsonResponse = this.sendJsonifiedItemToURL(Client.Method.GET, url, null);
        this.assertHttpOK(jsonResponse, "when querying features enabled for agent's organization");
        return (List)MAPPER.readValue((String)((HttpResponse)jsonResponse).payload, STRING_LIST_TYPE);
    }

    @Override
    public boolean hasFeatureEnabled(String feature) throws IOException, ScanUsageException {
        List<String> enabledFeatures = this.getFeaturesEnabledForOrgViaAgentAuth();
        for (String enabledFeature : enabledFeatures) {
            if (!enabledFeature.equalsIgnoreCase(feature)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public ScanFinishUploadResponse callScanFinishAndUploadVulnMethods(String scanId, InstanceVulnMethodUpload vulnerableMethodUpload) throws IOException, ScanUsageException {
        this.assertHaveApiToken();
        String endpoint = String.format("%s/scan/%s/finish", POLICY_ENDPOINT_VERSION, scanId);
        String url = this.baseUri.resolve(endpoint).toString();
        HttpResponse<String> jsonResponse = this.sendJsonifiedItemToURL(Client.Method.POST, url, vulnerableMethodUpload);
        this.assertHttpOK(jsonResponse, "attempting to upload vulnerable methods");
        return (ScanFinishUploadResponse)MAPPER.readValue((String)((HttpResponse)jsonResponse).payload, ScanFinishUploadResponse.class);
    }

    @Override
    public boolean uploadVulnerableMethods(String scanId, InstanceVulnMethodUpload vulnerableMethodUpload) throws IOException, ScanUsageException {
        this.assertHaveApiToken();
        String endpoint = String.format("match/%s/methods", scanId);
        String url = this.baseUri.resolve(endpoint).toString();
        HttpResponse<String> jsonResponse = this.sendJsonifiedItemToURL(Client.Method.POST, url, vulnerableMethodUpload);
        this.assertHttpOK(jsonResponse, "attempting to upload vulnerable methods");
        return true;
    }

    @Override
    public String getGenerationVersion(BuildSystemClientType clientType, long generation) throws IOException, ScanUsageException {
        String generationsPathStr = String.format(GENERATIONS_URL_PATTERN, new Object[]{generation, clientType});
        return (String)((HttpResponse)this.jsonAPIStringResponse(Client.Method.GET, URI.create(generationsPathStr), null)).payload;
    }

    @Override
    public boolean isCommunicatingWithSrcclrPlatform() {
        String baseUrl = this.getBaseURI().getAuthority();
        for (Pattern pattern : SRCCLR_PLATFORM_AUTHORITY_REGEXES) {
            if (!pattern.matcher(baseUrl).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public SafeVersionsResponse getSafeVersions(@Nonnull SafeVersionsQuery safeVersionsQuery) throws IOException, ScanUsageException {
        this.assertHaveApiToken();
        String endpoint = String.format("%s/scan/safe-versions", POLICY_ENDPOINT_VERSION);
        String url = this.baseUri.resolve(endpoint).toString();
        HttpResponse<String> jsonResponse = this.sendJsonifiedItemToURL(Client.Method.POST, url, safeVersionsQuery);
        this.assertHttpOK(jsonResponse, "when getting safe versions");
        return (SafeVersionsResponse)MAPPER.readValue((String)((HttpResponse)jsonResponse).payload, SafeVersionsResponse.class);
    }

    @Override
    @Nonnull
    public LibDeltaResponse getDelta(@Nonnull LibDeltaQuery libDeltaQuery) throws IOException, ScanUsageException {
        this.assertHaveApiToken();
        String endpoint = String.format("%s/scan/libdelta", POLICY_ENDPOINT_VERSION);
        String url = this.baseUri.resolve(endpoint).toString();
        HttpResponse<String> jsonResponse = this.sendJsonifiedItemToURL(Client.Method.POST, url, libDeltaQuery);
        this.assertHttpOK(jsonResponse, "when getting libdelta");
        return (LibDeltaResponse)MAPPER.readValue((String)((HttpResponse)jsonResponse).payload, LibDeltaResponse.class);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    private HttpResponse<String> sendJsonifiedItemToURL(Client.Method method, String url, Object payload) throws IOException, ScanUsageException {
        URL theUrl = new URL(url);
        int localRetry = !this.retryNetworkErrors ? 1 : this.retryCount;
        IOException lastEx = null;
        for (int attempt = 0; attempt < localRetry; ++attempt) {
            if (attempt > 0) {
                int wait = (int)Math.pow(this.expBackOffInitial, attempt);
                LOGGER.debug("Waiting for {} seconds before retrying.", (Object)wait);
                try {
                    TimeUnit.SECONDS.sleep(wait);
                }
                catch (InterruptedException ex) {
                    throw new IOException(String.format("Unable to send match query: %s", ex.getMessage()), ex);
                }
            }
            HttpURLConnection conn = this.proxy != null ? (HttpURLConnection)theUrl.openConnection(this.proxy) : (HttpURLConnection)theUrl.openConnection();
            try {
                this.addAuth(conn);
                conn.setRequestMethod(method.name());
                conn.setDoInput(true);
                if (SourceClearClient.isNotBlank(this.clientTypeHeader)) {
                    conn.setRequestProperty(CLIENT_TYPE_HEADER, this.clientTypeHeader);
                }
                if (SourceClearClient.isNotBlank(this.clientVersionHeader)) {
                    conn.setRequestProperty(CLIENT_VERSION_HEADER, this.clientVersionHeader);
                }
                conn.setRequestProperty("Accept-Encoding", GZIP);
                if (payload != null) {
                    conn.setRequestProperty("Content-Type", APPLICATION_JSON);
                    conn.setDoOutput(true);
                    try (OutputStream out = conn.getOutputStream();){
                        MAPPER.writeValue(out, payload);
                    }
                } else {
                    conn.connect();
                }
                if (!this.retryNetworkErrors || !this.shouldRetryForStatusCode(conn)) {
                    String body;
                    int status = conn.getResponseCode();
                    Map<String, List<String>> headers = conn.getHeaderFields();
                    Charset charset = SourceClearClient.sniffContentTypeCharset(conn);
                    boolean gzipped = GZIP.equalsIgnoreCase(conn.getContentEncoding());
                    try (InputStream stream = conn.getInputStream();){
                        if (stream != null) {
                            InputStreamReader reader = new InputStreamReader(gzipped ? new GZIPInputStream(stream) : stream, charset);
                            body = CharStreams.toString((Readable)reader);
                        } else {
                            body = null;
                        }
                    }
                    catch (IOException e) {
                        String errorText = "";
                        try (InputStream errorStream = conn.getErrorStream();){
                            if (null != errorStream) {
                                errorText = CharStreams.toString((Readable)new InputStreamReader(gzipped ? new GZIPInputStream(errorStream) : errorStream, charset));
                                LOGGER.debug("Bogus reply to URL={} status={} body=<<{}>>%n", new Object[]{theUrl, status, errorText, e});
                            } else {
                                LOGGER.debug("No error text due to NULL error stream");
                            }
                        }
                        if (!this.isHttpOK(status)) {
                            ScanUsageException.Type type;
                            String userFriendlyMsg;
                            HTTPException httpException = new HTTPException(status);
                            httpException.initCause(new Exception(errorText));
                            switch (status) {
                                case 412: {
                                    List<String> values = headers.get(SRCCLR_MIN_VERSION);
                                    String minVersion = values != null && !values.isEmpty() ? values.get(0) : null;
                                    LOGGER.debug("Minimum version supported: {}", (Object)(StringUtils.isNotBlank(minVersion) ? minVersion : "not found in headers"));
                                    userFriendlyMsg = "We have discontinued support for the agent version you are using. Please upgrade to the latest.";
                                    type = ScanUsageException.Type.MIN_VERSION_REQUIRED;
                                    break;
                                }
                                case 402: {
                                    String contentType = StringUtils.trimToEmpty((String)conn.getContentType());
                                    userFriendlyMsg = contentType.startsWith(APPLICATION_JSON) ? this.getFromJsonString(errorText, "message").orElse(DEFAULT_PAYMENT_REQUIRED_MSG) : DEFAULT_PAYMENT_REQUIRED_MSG;
                                    type = ScanUsageException.Type.PAYMENT_REQUIRED;
                                    break;
                                }
                                case 429: {
                                    userFriendlyMsg = "You have exceeded your maximum allowed number of scans this month. Upgrade to scan more: https://www.sourceclear.com/pricing.";
                                    type = ScanUsageException.Type.TOO_MANY_REQUESTS;
                                    break;
                                }
                                default: {
                                    throw httpException;
                                }
                            }
                            ScanUsageException scanUsageException = new ScanUsageException(userFriendlyMsg, type);
                            scanUsageException.initCause(httpException);
                            throw scanUsageException;
                        }
                        throw e;
                    }
                    return new HttpResponse<String>(status, conn.getResponseMessage(), headers, body);
                }
                LOGGER.warn("SourceClear API returned unexpected HTTP code {} ({}) ... retry {} of {}", new Object[]{conn.getResponseCode(), conn.getResponseMessage(), attempt + 1, localRetry});
                SourceClearClient.drainAndDisconnectErroredConnection(conn);
                continue;
            }
            catch (HTTPException | UnknownHostException uhe) {
                throw uhe;
            }
            catch (IOException ioe) {
                String diagnosticMessage;
                lastEx = ioe;
                Throwable root = Throwables.getRootCause((Throwable)ioe);
                try {
                    throw root;
                }
                catch (ConnectException ex) {
                    LOGGER.debug(String.format("retry %d of %d", attempt + 1, localRetry), (Throwable)ex);
                    diagnosticMessage = "SourceClear API refused the connection";
                }
                catch (SocketTimeoutException ex) {
                    LOGGER.debug(String.format("retry %d of %d", attempt + 1, localRetry), (Throwable)ex);
                    diagnosticMessage = "Timeout while trying to communicate with SourceClear API";
                }
                catch (Throwable t) {
                    throw ioe;
                }
                LOGGER.warn("{} ... retry {} of {}", new Object[]{diagnosticMessage, attempt + 1, localRetry});
                SourceClearClient.drainAndDisconnectErroredConnection(conn);
            }
        }
        String msg = this.retryNetworkErrors ? String.format("Unable to contact SourceClear after %d tries", this.retryCount) : "Unable to contact SourceClear API";
        throw new IOException(msg, lastEx);
    }

    private static Charset sniffContentTypeCharset(HttpURLConnection conn) {
        Charset charset;
        Map<String, List<String>> headers = conn.getHeaderFields();
        List<String> cTypeHeaders = headers.get("content-type");
        if (null != cTypeHeaders && !cTypeHeaders.isEmpty()) {
            String cType = cTypeHeaders.get(0);
            MediaType contentType = MediaType.parse((String)cType);
            charset = (Charset)contentType.charset().or((Object)Charset.defaultCharset());
        } else {
            charset = Charset.defaultCharset();
        }
        return charset;
    }

    private HttpURLConnection addAuth(HttpURLConnection request) {
        if (SourceClearClient.isNotBlank(this.apiToken)) {
            request.setRequestProperty("Authorization", String.format("Bearer %s", this.apiToken));
        }
        return request;
    }

    private static void drainAndDisconnectErroredConnection(HttpURLConnection conn) throws IOException {
        try (InputStream stream = conn.getInputStream();){
            if (stream != null) {
                ByteStreams.copy((InputStream)stream, (OutputStream)ByteStreams.nullOutputStream());
            }
        }
        catch (IOException e) {
            try (InputStream errStream = conn.getErrorStream();){
                if (errStream != null) {
                    ByteStreams.copy((InputStream)errStream, (OutputStream)ByteStreams.nullOutputStream());
                }
            }
        }
        conn.disconnect();
    }

    private void assertHaveApiToken() {
        if (SourceClearClient.isBlank(this.apiToken)) {
            throw new IllegalStateException("One must provide the auth token in the constructor, or use the 2-arg version of this method");
        }
    }

    private boolean shouldRetryForStatusCode(HttpURLConnection conn) throws IOException {
        return this.isServerSideError(conn.getResponseCode());
    }

    private boolean isServerSideError(int status) {
        return 500 <= status;
    }

    private boolean isHttpOK(int status) {
        return 200 <= status && status < 300;
    }

    private void assertHttpOK(HttpResponse<?> resp, String actionDescription) throws IOException {
        if (this.retryNetworkErrors) {
            LOGGER.debug("Skipping post-fact status code check because of retry-mode (but, code={} status={})", (Object)((HttpResponse)resp).statusCode, (Object)((HttpResponse)resp).statusText);
            return;
        }
        if (!this.isHttpOK(((HttpResponse)resp).statusCode)) {
            throw new IOException(String.format("Platform API returned %d: %s, while %s", ((HttpResponse)resp).statusCode, ((HttpResponse)resp).statusText, actionDescription));
        }
    }

    private String trimStringWithNullCheck(String stringToTrim) {
        return !Strings.isNullOrEmpty((String)stringToTrim) ? stringToTrim.trim() : null;
    }

    private Optional<String> getFromJsonString(String jsonString, String key) {
        try {
            Map map = (Map)MAPPER.readValue(jsonString, STRING_OBJECT_MAP_TYPE);
            return Optional.ofNullable((String)map.get(key));
        }
        catch (IOException ex) {
            LOGGER.debug("Unable to convert input '{}' to map.", (Object)jsonString);
            return Optional.empty();
        }
    }

    @Override
    public URI getBaseURI() {
        return this.baseUri;
    }

    private static boolean isBlank(String value) {
        return value == null || value.trim().isEmpty();
    }

    private static boolean isNotBlank(String value) {
        return !SourceClearClient.isBlank(value);
    }

    public static class Builder {
        private URI baseURI;
        private String apiToken;
        private Integer retryCount;
        private Type clientType;
        private String clientVersion;
        private Proxy proxy;
        private boolean withPolicy;
        private int expBackOffInitial;

        public Builder withBaseURI(@Nullable URI baseURI) {
            this.baseURI = baseURI;
            return this;
        }

        public Builder withApiToken(String apiToken) {
            this.apiToken = apiToken;
            return this;
        }

        public Builder withRetryCount(Integer retryCount) {
            this.retryCount = retryCount;
            return this;
        }

        public Builder withClientType(Type clientType) {
            this.clientType = clientType;
            return this;
        }

        public Builder withClientVersion(String clientVersion) {
            this.clientVersion = clientVersion;
            return this;
        }

        public Builder withProxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder withPolicy(boolean withPolicy) {
            this.withPolicy = withPolicy;
            return this;
        }

        public Builder withExpBackOffInitial(int expBackOffInitial) {
            this.expBackOffInitial = expBackOffInitial;
            return this;
        }

        public Client build() {
            return new SourceClearClient(this);
        }
    }

    private class HttpResponse<T>
    implements Response<T> {
        private final int statusCode;
        private final String statusText;
        private final Map<String, List<String>> headers;
        private final T payload;

        public HttpResponse(int statusCode, String statusText, Map<String, List<String>> headers, T payload) {
            this.statusCode = statusCode;
            this.statusText = statusText;
            this.headers = headers;
            this.payload = payload;
        }

        @Override
        public int getStatusCode() {
            return this.statusCode;
        }

        @Override
        public String getStatusText() {
            return this.statusText;
        }

        @Override
        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        @Override
        public T getPayload() {
            return this.payload;
        }
    }

    public static enum Type {
        CLI,
        MAVEN,
        GRADLE,
        JENKINS;

    }
}

