/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sourceclear.api.data.Link;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HATEOASApiModel
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final String REL_ROOT_HTML = "root_html";
    public static final String REL_REPO_HTML = "html";
    @JsonProperty
    private Map<String, String> links = new LinkedHashMap<String, String>();

    public void addLink(String rel, String href) {
        this.links.put(rel, href);
    }

    public void addLink(Link link) {
        Objects.requireNonNull(link, "Link must not be null!");
        this.links.put(link.getRel(), link.getHref());
    }

    public void addLinks(Iterable<Link> links) {
        Objects.requireNonNull(links, "Given links must not be null!");
        for (Link candidate : links) {
            this.addLink(candidate);
        }
    }

    public boolean hasLink(String rel) {
        return this.links.containsKey(rel);
    }

    public String getLink(String rel) {
        return this.links.get(rel);
    }

    public void removeLinks() {
        this.links.clear();
    }

    public Map<String, String> getLinks() {
        return Collections.unmodifiableMap(this.links);
    }
}

