/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.diff;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.sourceclear.api.data.artifact.CVEStatus;
import com.sourceclear.api.data.diff.ArtifactSeverity;
import com.sourceclear.api.data.diff.IssueLibraryDependencyMode;
import com.sourceclear.api.data.diff.IssueStatus;
import com.sourceclear.api.data.diff.IssueType;
import com.sourceclear.api.data.diff.VulnIssueResourceModel;
import com.sourceclear.api.data.evidence.CoordinateType;
import java.util.Date;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

abstract class VulnIssueResourceModel_Builder {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    private IssueStatus status;
    private IssueType type;
    private IssueLibraryDependencyMode dependencyMode;
    @Nullable
    private Float issueSeverity = null;
    @Nullable
    private String libraryName = null;
    @Nullable
    private String libraryVersion = null;
    @Nullable
    private Date libraryReleaseDate = null;
    @Nullable
    private CoordinateType coordinateType = null;
    @Nullable
    private String coord1 = null;
    @Nullable
    private String coord2 = null;
    @Nullable
    private String latestVersion = null;
    @Nullable
    private Date latestReleaseDate = null;
    @Nullable
    private String commitHash = null;
    private long artifactId;
    private String title;
    @Nullable
    private Float cvss = null;
    @Nullable
    private String cve = null;
    private CVEStatus cveStatus;
    @Nullable
    private Date disclosureDateUtc = null;
    @Nullable
    private Boolean vulnMethods = null;
    private ArtifactSeverity artifactSeverity;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    VulnIssueResourceModel_Builder() {
    }

    public static VulnIssueResourceModel.Builder from(VulnIssueResourceModel value) {
        return new VulnIssueResourceModel.Builder().mergeFrom(value);
    }

    @JsonProperty(value="status")
    public VulnIssueResourceModel.Builder setStatus(IssueStatus status) {
        this.status = (IssueStatus)((Object)Preconditions.checkNotNull((Object)((Object)status)));
        this._unsetProperties.remove((Object)Property.STATUS);
        return (VulnIssueResourceModel.Builder)this;
    }

    public VulnIssueResourceModel.Builder mapStatus(UnaryOperator<IssueStatus> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setStatus((IssueStatus)((Object)mapper.apply(this.getStatus())));
    }

    public IssueStatus getStatus() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.STATUS) ? 1 : 0) != 0, (Object)"status not set");
        return this.status;
    }

    @JsonProperty(value="type")
    public VulnIssueResourceModel.Builder setType(IssueType type) {
        this.type = (IssueType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        this._unsetProperties.remove((Object)Property.TYPE);
        return (VulnIssueResourceModel.Builder)this;
    }

    public VulnIssueResourceModel.Builder mapType(UnaryOperator<IssueType> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setType((IssueType)((Object)mapper.apply(this.getType())));
    }

    public IssueType getType() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.TYPE) ? 1 : 0) != 0, (Object)"type not set");
        return this.type;
    }

    @JsonProperty(value="dependencyMode")
    public VulnIssueResourceModel.Builder setDependencyMode(IssueLibraryDependencyMode dependencyMode) {
        this.dependencyMode = (IssueLibraryDependencyMode)((Object)Preconditions.checkNotNull((Object)((Object)dependencyMode)));
        this._unsetProperties.remove((Object)Property.DEPENDENCY_MODE);
        return (VulnIssueResourceModel.Builder)this;
    }

    public VulnIssueResourceModel.Builder mapDependencyMode(UnaryOperator<IssueLibraryDependencyMode> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setDependencyMode((IssueLibraryDependencyMode)((Object)mapper.apply(this.getDependencyMode())));
    }

    public IssueLibraryDependencyMode getDependencyMode() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.DEPENDENCY_MODE) ? 1 : 0) != 0, (Object)"dependencyMode not set");
        return this.dependencyMode;
    }

    @JsonProperty(value="issueSeverity")
    public VulnIssueResourceModel.Builder setIssueSeverity(@Nullable Float issueSeverity) {
        this.issueSeverity = issueSeverity;
        return (VulnIssueResourceModel.Builder)this;
    }

    public VulnIssueResourceModel.Builder mapIssueSeverity(UnaryOperator<Float> mapper) {
        Preconditions.checkNotNull(mapper);
        Float issueSeverity = this.getIssueSeverity();
        if (issueSeverity != null) {
            this.setIssueSeverity((Float)mapper.apply(issueSeverity));
        }
        return (VulnIssueResourceModel.Builder)this;
    }

    @Nullable
    public Float getIssueSeverity() {
        return this.issueSeverity;
    }

    @JsonProperty(value="libraryName")
    public VulnIssueResourceModel.Builder setLibraryName(@Nullable String libraryName) {
        this.libraryName = libraryName;
        return (VulnIssueResourceModel.Builder)this;
    }

    public VulnIssueResourceModel.Builder mapLibraryName(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        String libraryName = this.getLibraryName();
        if (libraryName != null) {
            this.setLibraryName((String)mapper.apply(libraryName));
        }
        return (VulnIssueResourceModel.Builder)this;
    }

    @Nullable
    public String getLibraryName() {
        return this.libraryName;
    }

    @JsonProperty(value="libraryVersion")
    public VulnIssueResourceModel.Builder setLibraryVersion(@Nullable String libraryVersion) {
        this.libraryVersion = libraryVersion;
        return (VulnIssueResourceModel.Builder)this;
    }

    public VulnIssueResourceModel.Builder mapLibraryVersion(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        String libraryVersion = this.getLibraryVersion();
        if (libraryVersion != null) {
            this.setLibraryVersion((String)mapper.apply(libraryVersion));
        }
        return (VulnIssueResourceModel.Builder)this;
    }

    @Nullable
    public String getLibraryVersion() {
        return this.libraryVersion;
    }

    @JsonProperty(value="libraryReleaseDate")
    public VulnIssueResourceModel.Builder setLibraryReleaseDate(@Nullable Date libraryReleaseDate) {
        this.libraryReleaseDate = libraryReleaseDate;
        return (VulnIssueResourceModel.Builder)this;
    }

    public VulnIssueResourceModel.Builder mapLibraryReleaseDate(UnaryOperator<Date> mapper) {
        Preconditions.checkNotNull(mapper);
        Date libraryReleaseDate = this.getLibraryReleaseDate();
        if (libraryReleaseDate != null) {
            this.setLibraryReleaseDate((Date)mapper.apply(libraryReleaseDate));
        }
        return (VulnIssueResourceModel.Builder)this;
    }

    @Nullable
    public Date getLibraryReleaseDate() {
        return this.libraryReleaseDate;
    }

    @JsonProperty(value="coordinateType")
    public VulnIssueResourceModel.Builder setCoordinateType(@Nullable CoordinateType coordinateType) {
        this.coordinateType = coordinateType;
        return (VulnIssueResourceModel.Builder)this;
    }

    public VulnIssueResourceModel.Builder mapCoordinateType(UnaryOperator<CoordinateType> mapper) {
        Preconditions.checkNotNull(mapper);
        CoordinateType coordinateType = this.getCoordinateType();
        if (coordinateType != null) {
            this.setCoordinateType((CoordinateType)((Object)mapper.apply(coordinateType)));
        }
        return (VulnIssueResourceModel.Builder)this;
    }

    @Nullable
    public CoordinateType getCoordinateType() {
        return this.coordinateType;
    }

    @JsonProperty(value="coord1")
    public VulnIssueResourceModel.Builder setCoord1(@Nullable String coord1) {
        this.coord1 = coord1;
        return (VulnIssueResourceModel.Builder)this;
    }

    public VulnIssueResourceModel.Builder mapCoord1(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        String coord1 = this.getCoord1();
        if (coord1 != null) {
            this.setCoord1((String)mapper.apply(coord1));
        }
        return (VulnIssueResourceModel.Builder)this;
    }

    @Nullable
    public String getCoord1() {
        return this.coord1;
    }

    @JsonProperty(value="coord2")
    public VulnIssueResourceModel.Builder setCoord2(@Nullable String coord2) {
        this.coord2 = coord2;
        return (VulnIssueResourceModel.Builder)this;
    }

    public VulnIssueResourceModel.Builder mapCoord2(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        String coord2 = this.getCoord2();
        if (coord2 != null) {
            this.setCoord2((String)mapper.apply(coord2));
        }
        return (VulnIssueResourceModel.Builder)this;
    }

    @Nullable
    public String getCoord2() {
        return this.coord2;
    }

    @JsonProperty(value="latestVersion")
    public VulnIssueResourceModel.Builder setLatestVersion(@Nullable String latestVersion) {
        this.latestVersion = latestVersion;
        return (VulnIssueResourceModel.Builder)this;
    }

    public VulnIssueResourceModel.Builder mapLatestVersion(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        String latestVersion = this.getLatestVersion();
        if (latestVersion != null) {
            this.setLatestVersion((String)mapper.apply(latestVersion));
        }
        return (VulnIssueResourceModel.Builder)this;
    }

    @Nullable
    public String getLatestVersion() {
        return this.latestVersion;
    }

    @JsonProperty(value="latestReleaseDate")
    public VulnIssueResourceModel.Builder setLatestReleaseDate(@Nullable Date latestReleaseDate) {
        this.latestReleaseDate = latestReleaseDate;
        return (VulnIssueResourceModel.Builder)this;
    }

    public VulnIssueResourceModel.Builder mapLatestReleaseDate(UnaryOperator<Date> mapper) {
        Preconditions.checkNotNull(mapper);
        Date latestReleaseDate = this.getLatestReleaseDate();
        if (latestReleaseDate != null) {
            this.setLatestReleaseDate((Date)mapper.apply(latestReleaseDate));
        }
        return (VulnIssueResourceModel.Builder)this;
    }

    @Nullable
    public Date getLatestReleaseDate() {
        return this.latestReleaseDate;
    }

    @JsonProperty(value="commitHash")
    public VulnIssueResourceModel.Builder setCommitHash(@Nullable String commitHash) {
        this.commitHash = commitHash;
        return (VulnIssueResourceModel.Builder)this;
    }

    public VulnIssueResourceModel.Builder mapCommitHash(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        String commitHash = this.getCommitHash();
        if (commitHash != null) {
            this.setCommitHash((String)mapper.apply(commitHash));
        }
        return (VulnIssueResourceModel.Builder)this;
    }

    @Nullable
    public String getCommitHash() {
        return this.commitHash;
    }

    @JsonProperty(value="artifactId")
    public VulnIssueResourceModel.Builder setArtifactId(long artifactId) {
        this.artifactId = artifactId;
        this._unsetProperties.remove((Object)Property.ARTIFACT_ID);
        return (VulnIssueResourceModel.Builder)this;
    }

    public VulnIssueResourceModel.Builder mapArtifactId(UnaryOperator<Long> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setArtifactId((Long)mapper.apply(this.getArtifactId()));
    }

    public long getArtifactId() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.ARTIFACT_ID) ? 1 : 0) != 0, (Object)"artifactId not set");
        return this.artifactId;
    }

    @JsonProperty(value="title")
    public VulnIssueResourceModel.Builder setTitle(String title) {
        this.title = (String)Preconditions.checkNotNull((Object)title);
        this._unsetProperties.remove((Object)Property.TITLE);
        return (VulnIssueResourceModel.Builder)this;
    }

    public VulnIssueResourceModel.Builder mapTitle(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setTitle((String)mapper.apply(this.getTitle()));
    }

    public String getTitle() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.TITLE) ? 1 : 0) != 0, (Object)"title not set");
        return this.title;
    }

    @JsonProperty(value="cvss")
    public VulnIssueResourceModel.Builder setCvss(@Nullable Float cvss) {
        this.cvss = cvss;
        return (VulnIssueResourceModel.Builder)this;
    }

    public VulnIssueResourceModel.Builder mapCvss(UnaryOperator<Float> mapper) {
        Preconditions.checkNotNull(mapper);
        Float cvss = this.getCvss();
        if (cvss != null) {
            this.setCvss((Float)mapper.apply(cvss));
        }
        return (VulnIssueResourceModel.Builder)this;
    }

    @Nullable
    public Float getCvss() {
        return this.cvss;
    }

    @JsonProperty(value="cve")
    public VulnIssueResourceModel.Builder setCve(@Nullable String cve) {
        this.cve = cve;
        return (VulnIssueResourceModel.Builder)this;
    }

    public VulnIssueResourceModel.Builder mapCve(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        String cve = this.getCve();
        if (cve != null) {
            this.setCve((String)mapper.apply(cve));
        }
        return (VulnIssueResourceModel.Builder)this;
    }

    @Nullable
    public String getCve() {
        return this.cve;
    }

    @JsonProperty(value="cveStatus")
    public VulnIssueResourceModel.Builder setCveStatus(CVEStatus cveStatus) {
        this.cveStatus = (CVEStatus)Preconditions.checkNotNull((Object)cveStatus);
        this._unsetProperties.remove((Object)Property.CVE_STATUS);
        return (VulnIssueResourceModel.Builder)this;
    }

    public VulnIssueResourceModel.Builder mapCveStatus(UnaryOperator<CVEStatus> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setCveStatus((CVEStatus)mapper.apply(this.getCveStatus()));
    }

    public CVEStatus getCveStatus() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.CVE_STATUS) ? 1 : 0) != 0, (Object)"cveStatus not set");
        return this.cveStatus;
    }

    @JsonProperty(value="disclosureDateUtc")
    public VulnIssueResourceModel.Builder setDisclosureDateUtc(@Nullable Date disclosureDateUtc) {
        this.disclosureDateUtc = disclosureDateUtc;
        return (VulnIssueResourceModel.Builder)this;
    }

    public VulnIssueResourceModel.Builder mapDisclosureDateUtc(UnaryOperator<Date> mapper) {
        Preconditions.checkNotNull(mapper);
        Date disclosureDateUtc = this.getDisclosureDateUtc();
        if (disclosureDateUtc != null) {
            this.setDisclosureDateUtc((Date)mapper.apply(disclosureDateUtc));
        }
        return (VulnIssueResourceModel.Builder)this;
    }

    @Nullable
    public Date getDisclosureDateUtc() {
        return this.disclosureDateUtc;
    }

    @JsonProperty(value="vulnMethods")
    public VulnIssueResourceModel.Builder setVulnMethods(@Nullable Boolean vulnMethods) {
        this.vulnMethods = vulnMethods;
        return (VulnIssueResourceModel.Builder)this;
    }

    public VulnIssueResourceModel.Builder mapVulnMethods(UnaryOperator<Boolean> mapper) {
        Preconditions.checkNotNull(mapper);
        Boolean vulnMethods = this.getVulnMethods();
        if (vulnMethods != null) {
            this.setVulnMethods((Boolean)mapper.apply(vulnMethods));
        }
        return (VulnIssueResourceModel.Builder)this;
    }

    @Nullable
    public Boolean getVulnMethods() {
        return this.vulnMethods;
    }

    @JsonProperty(value="artifactSeverity")
    public VulnIssueResourceModel.Builder setArtifactSeverity(ArtifactSeverity artifactSeverity) {
        this.artifactSeverity = (ArtifactSeverity)((Object)Preconditions.checkNotNull((Object)((Object)artifactSeverity)));
        this._unsetProperties.remove((Object)Property.ARTIFACT_SEVERITY);
        return (VulnIssueResourceModel.Builder)this;
    }

    public VulnIssueResourceModel.Builder mapArtifactSeverity(UnaryOperator<ArtifactSeverity> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setArtifactSeverity((ArtifactSeverity)((Object)mapper.apply(this.getArtifactSeverity())));
    }

    public ArtifactSeverity getArtifactSeverity() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.ARTIFACT_SEVERITY) ? 1 : 0) != 0, (Object)"artifactSeverity not set");
        return this.artifactSeverity;
    }

    public VulnIssueResourceModel.Builder mergeFrom(VulnIssueResourceModel value) {
        VulnIssueResourceModel.Builder _defaults = new VulnIssueResourceModel.Builder();
        if (_defaults._unsetProperties.contains((Object)Property.STATUS) || !Objects.equals((Object)value.getStatus(), (Object)((VulnIssueResourceModel_Builder)_defaults).getStatus())) {
            this.setStatus(value.getStatus());
        }
        if (_defaults._unsetProperties.contains((Object)Property.TYPE) || !Objects.equals((Object)value.getType(), (Object)((VulnIssueResourceModel_Builder)_defaults).getType())) {
            this.setType(value.getType());
        }
        if (_defaults._unsetProperties.contains((Object)Property.DEPENDENCY_MODE) || !Objects.equals((Object)value.getDependencyMode(), (Object)((VulnIssueResourceModel_Builder)_defaults).getDependencyMode())) {
            this.setDependencyMode(value.getDependencyMode());
        }
        if (!Objects.equals(value.getIssueSeverity(), ((VulnIssueResourceModel_Builder)_defaults).getIssueSeverity())) {
            this.setIssueSeverity(value.getIssueSeverity());
        }
        if (!Objects.equals(value.getLibraryName(), ((VulnIssueResourceModel_Builder)_defaults).getLibraryName())) {
            this.setLibraryName(value.getLibraryName());
        }
        if (!Objects.equals(value.getLibraryVersion(), ((VulnIssueResourceModel_Builder)_defaults).getLibraryVersion())) {
            this.setLibraryVersion(value.getLibraryVersion());
        }
        if (!Objects.equals(value.getLibraryReleaseDate(), ((VulnIssueResourceModel_Builder)_defaults).getLibraryReleaseDate())) {
            this.setLibraryReleaseDate(value.getLibraryReleaseDate());
        }
        if (!Objects.equals((Object)value.getCoordinateType(), (Object)((VulnIssueResourceModel_Builder)_defaults).getCoordinateType())) {
            this.setCoordinateType(value.getCoordinateType());
        }
        if (!Objects.equals(value.getCoord1(), ((VulnIssueResourceModel_Builder)_defaults).getCoord1())) {
            this.setCoord1(value.getCoord1());
        }
        if (!Objects.equals(value.getCoord2(), ((VulnIssueResourceModel_Builder)_defaults).getCoord2())) {
            this.setCoord2(value.getCoord2());
        }
        if (!Objects.equals(value.getLatestVersion(), ((VulnIssueResourceModel_Builder)_defaults).getLatestVersion())) {
            this.setLatestVersion(value.getLatestVersion());
        }
        if (!Objects.equals(value.getLatestReleaseDate(), ((VulnIssueResourceModel_Builder)_defaults).getLatestReleaseDate())) {
            this.setLatestReleaseDate(value.getLatestReleaseDate());
        }
        if (!Objects.equals(value.getCommitHash(), ((VulnIssueResourceModel_Builder)_defaults).getCommitHash())) {
            this.setCommitHash(value.getCommitHash());
        }
        if (_defaults._unsetProperties.contains((Object)Property.ARTIFACT_ID) || !Objects.equals(value.getArtifactId(), ((VulnIssueResourceModel_Builder)_defaults).getArtifactId())) {
            this.setArtifactId(value.getArtifactId());
        }
        if (_defaults._unsetProperties.contains((Object)Property.TITLE) || !Objects.equals(value.getTitle(), ((VulnIssueResourceModel_Builder)_defaults).getTitle())) {
            this.setTitle(value.getTitle());
        }
        if (!Objects.equals(value.getCvss(), ((VulnIssueResourceModel_Builder)_defaults).getCvss())) {
            this.setCvss(value.getCvss());
        }
        if (!Objects.equals(value.getCve(), ((VulnIssueResourceModel_Builder)_defaults).getCve())) {
            this.setCve(value.getCve());
        }
        if (_defaults._unsetProperties.contains((Object)Property.CVE_STATUS) || !Objects.equals(value.getCveStatus(), ((VulnIssueResourceModel_Builder)_defaults).getCveStatus())) {
            this.setCveStatus(value.getCveStatus());
        }
        if (!Objects.equals(value.getDisclosureDateUtc(), ((VulnIssueResourceModel_Builder)_defaults).getDisclosureDateUtc())) {
            this.setDisclosureDateUtc(value.getDisclosureDateUtc());
        }
        if (!Objects.equals(value.getVulnMethods(), ((VulnIssueResourceModel_Builder)_defaults).getVulnMethods())) {
            this.setVulnMethods(value.getVulnMethods());
        }
        if (_defaults._unsetProperties.contains((Object)Property.ARTIFACT_SEVERITY) || !Objects.equals((Object)value.getArtifactSeverity(), (Object)((VulnIssueResourceModel_Builder)_defaults).getArtifactSeverity())) {
            this.setArtifactSeverity(value.getArtifactSeverity());
        }
        return (VulnIssueResourceModel.Builder)this;
    }

    public VulnIssueResourceModel.Builder mergeFrom(VulnIssueResourceModel.Builder template) {
        VulnIssueResourceModel.Builder base = template;
        VulnIssueResourceModel.Builder _defaults = new VulnIssueResourceModel.Builder();
        if (!(base._unsetProperties.contains((Object)Property.STATUS) || !_defaults._unsetProperties.contains((Object)Property.STATUS) && Objects.equals((Object)template.getStatus(), (Object)((VulnIssueResourceModel_Builder)_defaults).getStatus()))) {
            this.setStatus(template.getStatus());
        }
        if (!(base._unsetProperties.contains((Object)Property.TYPE) || !_defaults._unsetProperties.contains((Object)Property.TYPE) && Objects.equals((Object)template.getType(), (Object)((VulnIssueResourceModel_Builder)_defaults).getType()))) {
            this.setType(template.getType());
        }
        if (!(base._unsetProperties.contains((Object)Property.DEPENDENCY_MODE) || !_defaults._unsetProperties.contains((Object)Property.DEPENDENCY_MODE) && Objects.equals((Object)template.getDependencyMode(), (Object)((VulnIssueResourceModel_Builder)_defaults).getDependencyMode()))) {
            this.setDependencyMode(template.getDependencyMode());
        }
        if (!Objects.equals(template.getIssueSeverity(), ((VulnIssueResourceModel_Builder)_defaults).getIssueSeverity())) {
            this.setIssueSeverity(template.getIssueSeverity());
        }
        if (!Objects.equals(template.getLibraryName(), ((VulnIssueResourceModel_Builder)_defaults).getLibraryName())) {
            this.setLibraryName(template.getLibraryName());
        }
        if (!Objects.equals(template.getLibraryVersion(), ((VulnIssueResourceModel_Builder)_defaults).getLibraryVersion())) {
            this.setLibraryVersion(template.getLibraryVersion());
        }
        if (!Objects.equals(template.getLibraryReleaseDate(), ((VulnIssueResourceModel_Builder)_defaults).getLibraryReleaseDate())) {
            this.setLibraryReleaseDate(template.getLibraryReleaseDate());
        }
        if (!Objects.equals((Object)template.getCoordinateType(), (Object)((VulnIssueResourceModel_Builder)_defaults).getCoordinateType())) {
            this.setCoordinateType(template.getCoordinateType());
        }
        if (!Objects.equals(template.getCoord1(), ((VulnIssueResourceModel_Builder)_defaults).getCoord1())) {
            this.setCoord1(template.getCoord1());
        }
        if (!Objects.equals(template.getCoord2(), ((VulnIssueResourceModel_Builder)_defaults).getCoord2())) {
            this.setCoord2(template.getCoord2());
        }
        if (!Objects.equals(template.getLatestVersion(), ((VulnIssueResourceModel_Builder)_defaults).getLatestVersion())) {
            this.setLatestVersion(template.getLatestVersion());
        }
        if (!Objects.equals(template.getLatestReleaseDate(), ((VulnIssueResourceModel_Builder)_defaults).getLatestReleaseDate())) {
            this.setLatestReleaseDate(template.getLatestReleaseDate());
        }
        if (!Objects.equals(template.getCommitHash(), ((VulnIssueResourceModel_Builder)_defaults).getCommitHash())) {
            this.setCommitHash(template.getCommitHash());
        }
        if (!(base._unsetProperties.contains((Object)Property.ARTIFACT_ID) || !_defaults._unsetProperties.contains((Object)Property.ARTIFACT_ID) && Objects.equals(template.getArtifactId(), ((VulnIssueResourceModel_Builder)_defaults).getArtifactId()))) {
            this.setArtifactId(template.getArtifactId());
        }
        if (!(base._unsetProperties.contains((Object)Property.TITLE) || !_defaults._unsetProperties.contains((Object)Property.TITLE) && Objects.equals(template.getTitle(), ((VulnIssueResourceModel_Builder)_defaults).getTitle()))) {
            this.setTitle(template.getTitle());
        }
        if (!Objects.equals(template.getCvss(), ((VulnIssueResourceModel_Builder)_defaults).getCvss())) {
            this.setCvss(template.getCvss());
        }
        if (!Objects.equals(template.getCve(), ((VulnIssueResourceModel_Builder)_defaults).getCve())) {
            this.setCve(template.getCve());
        }
        if (!(base._unsetProperties.contains((Object)Property.CVE_STATUS) || !_defaults._unsetProperties.contains((Object)Property.CVE_STATUS) && Objects.equals(template.getCveStatus(), ((VulnIssueResourceModel_Builder)_defaults).getCveStatus()))) {
            this.setCveStatus(template.getCveStatus());
        }
        if (!Objects.equals(template.getDisclosureDateUtc(), ((VulnIssueResourceModel_Builder)_defaults).getDisclosureDateUtc())) {
            this.setDisclosureDateUtc(template.getDisclosureDateUtc());
        }
        if (!Objects.equals(template.getVulnMethods(), ((VulnIssueResourceModel_Builder)_defaults).getVulnMethods())) {
            this.setVulnMethods(template.getVulnMethods());
        }
        if (!(base._unsetProperties.contains((Object)Property.ARTIFACT_SEVERITY) || !_defaults._unsetProperties.contains((Object)Property.ARTIFACT_SEVERITY) && Objects.equals((Object)template.getArtifactSeverity(), (Object)((VulnIssueResourceModel_Builder)_defaults).getArtifactSeverity()))) {
            this.setArtifactSeverity(template.getArtifactSeverity());
        }
        return (VulnIssueResourceModel.Builder)this;
    }

    public VulnIssueResourceModel.Builder clear() {
        VulnIssueResourceModel.Builder _defaults = new VulnIssueResourceModel.Builder();
        this.status = _defaults.status;
        this.type = _defaults.type;
        this.dependencyMode = _defaults.dependencyMode;
        this.issueSeverity = _defaults.issueSeverity;
        this.libraryName = _defaults.libraryName;
        this.libraryVersion = _defaults.libraryVersion;
        this.libraryReleaseDate = _defaults.libraryReleaseDate;
        this.coordinateType = _defaults.coordinateType;
        this.coord1 = _defaults.coord1;
        this.coord2 = _defaults.coord2;
        this.latestVersion = _defaults.latestVersion;
        this.latestReleaseDate = _defaults.latestReleaseDate;
        this.commitHash = _defaults.commitHash;
        this.artifactId = _defaults.artifactId;
        this.title = _defaults.title;
        this.cvss = _defaults.cvss;
        this.cve = _defaults.cve;
        this.cveStatus = _defaults.cveStatus;
        this.disclosureDateUtc = _defaults.disclosureDateUtc;
        this.vulnMethods = _defaults.vulnMethods;
        this.artifactSeverity = _defaults.artifactSeverity;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(_defaults._unsetProperties);
        return (VulnIssueResourceModel.Builder)this;
    }

    public VulnIssueResourceModel build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", (Object[])new Object[]{this._unsetProperties});
        return new Value(this);
    }

    @VisibleForTesting
    public VulnIssueResourceModel buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    implements VulnIssueResourceModel {
        private final IssueStatus status;
        private final IssueType type;
        private final IssueLibraryDependencyMode dependencyMode;
        @Nullable
        private final Float issueSeverity;
        @Nullable
        private final String libraryName;
        @Nullable
        private final String libraryVersion;
        @Nullable
        private final Date libraryReleaseDate;
        @Nullable
        private final CoordinateType coordinateType;
        @Nullable
        private final String coord1;
        @Nullable
        private final String coord2;
        @Nullable
        private final String latestVersion;
        @Nullable
        private final Date latestReleaseDate;
        @Nullable
        private final String commitHash;
        private final long artifactId;
        private final String title;
        @Nullable
        private final Float cvss;
        @Nullable
        private final String cve;
        private final CVEStatus cveStatus;
        @Nullable
        private final Date disclosureDateUtc;
        @Nullable
        private final Boolean vulnMethods;
        private final ArtifactSeverity artifactSeverity;
        private final EnumSet<Property> _unsetProperties;

        Partial(VulnIssueResourceModel_Builder builder) {
            this.status = builder.status;
            this.type = builder.type;
            this.dependencyMode = builder.dependencyMode;
            this.issueSeverity = builder.issueSeverity;
            this.libraryName = builder.libraryName;
            this.libraryVersion = builder.libraryVersion;
            this.libraryReleaseDate = builder.libraryReleaseDate;
            this.coordinateType = builder.coordinateType;
            this.coord1 = builder.coord1;
            this.coord2 = builder.coord2;
            this.latestVersion = builder.latestVersion;
            this.latestReleaseDate = builder.latestReleaseDate;
            this.commitHash = builder.commitHash;
            this.artifactId = builder.artifactId;
            this.title = builder.title;
            this.cvss = builder.cvss;
            this.cve = builder.cve;
            this.cveStatus = builder.cveStatus;
            this.disclosureDateUtc = builder.disclosureDateUtc;
            this.vulnMethods = builder.vulnMethods;
            this.artifactSeverity = builder.artifactSeverity;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        @JsonProperty(value="status")
        public IssueStatus getStatus() {
            if (this._unsetProperties.contains((Object)Property.STATUS)) {
                throw new UnsupportedOperationException("status not set");
            }
            return this.status;
        }

        @Override
        @JsonProperty(value="type")
        public IssueType getType() {
            if (this._unsetProperties.contains((Object)Property.TYPE)) {
                throw new UnsupportedOperationException("type not set");
            }
            return this.type;
        }

        @Override
        @JsonProperty(value="dependencyMode")
        public IssueLibraryDependencyMode getDependencyMode() {
            if (this._unsetProperties.contains((Object)Property.DEPENDENCY_MODE)) {
                throw new UnsupportedOperationException("dependencyMode not set");
            }
            return this.dependencyMode;
        }

        @Override
        @JsonProperty(value="issueSeverity")
        @Nullable
        public Float getIssueSeverity() {
            return this.issueSeverity;
        }

        @Override
        @JsonProperty(value="libraryName")
        @Nullable
        public String getLibraryName() {
            return this.libraryName;
        }

        @Override
        @JsonProperty(value="libraryVersion")
        @Nullable
        public String getLibraryVersion() {
            return this.libraryVersion;
        }

        @Override
        @JsonProperty(value="libraryReleaseDate")
        @Nullable
        public Date getLibraryReleaseDate() {
            return this.libraryReleaseDate;
        }

        @Override
        @JsonProperty(value="coordinateType")
        @Nullable
        public CoordinateType getCoordinateType() {
            return this.coordinateType;
        }

        @Override
        @JsonProperty(value="coord1")
        @Nullable
        public String getCoord1() {
            return this.coord1;
        }

        @Override
        @JsonProperty(value="coord2")
        @Nullable
        public String getCoord2() {
            return this.coord2;
        }

        @Override
        @JsonProperty(value="latestVersion")
        @Nullable
        public String getLatestVersion() {
            return this.latestVersion;
        }

        @Override
        @JsonProperty(value="latestReleaseDate")
        @Nullable
        public Date getLatestReleaseDate() {
            return this.latestReleaseDate;
        }

        @Override
        @JsonProperty(value="commitHash")
        @Nullable
        public String getCommitHash() {
            return this.commitHash;
        }

        @Override
        @JsonProperty(value="artifactId")
        public long getArtifactId() {
            if (this._unsetProperties.contains((Object)Property.ARTIFACT_ID)) {
                throw new UnsupportedOperationException("artifactId not set");
            }
            return this.artifactId;
        }

        @Override
        @JsonProperty(value="title")
        public String getTitle() {
            if (this._unsetProperties.contains((Object)Property.TITLE)) {
                throw new UnsupportedOperationException("title not set");
            }
            return this.title;
        }

        @Override
        @JsonProperty(value="cvss")
        @Nullable
        public Float getCvss() {
            return this.cvss;
        }

        @Override
        @JsonProperty(value="cve")
        @Nullable
        public String getCve() {
            return this.cve;
        }

        @Override
        @JsonProperty(value="cveStatus")
        public CVEStatus getCveStatus() {
            if (this._unsetProperties.contains((Object)Property.CVE_STATUS)) {
                throw new UnsupportedOperationException("cveStatus not set");
            }
            return this.cveStatus;
        }

        @Override
        @JsonProperty(value="disclosureDateUtc")
        @Nullable
        public Date getDisclosureDateUtc() {
            return this.disclosureDateUtc;
        }

        @Override
        @JsonProperty(value="vulnMethods")
        @Nullable
        public Boolean getVulnMethods() {
            return this.vulnMethods;
        }

        @Override
        @JsonProperty(value="artifactSeverity")
        public ArtifactSeverity getArtifactSeverity() {
            if (this._unsetProperties.contains((Object)Property.ARTIFACT_SEVERITY)) {
                throw new UnsupportedOperationException("artifactSeverity not set");
            }
            return this.artifactSeverity;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals((Object)this.status, (Object)other.status) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals((Object)this.dependencyMode, (Object)other.dependencyMode) && Objects.equals(this.issueSeverity, other.issueSeverity) && Objects.equals(this.libraryName, other.libraryName) && Objects.equals(this.libraryVersion, other.libraryVersion) && Objects.equals(this.libraryReleaseDate, other.libraryReleaseDate) && Objects.equals((Object)this.coordinateType, (Object)other.coordinateType) && Objects.equals(this.coord1, other.coord1) && Objects.equals(this.coord2, other.coord2) && Objects.equals(this.latestVersion, other.latestVersion) && Objects.equals(this.latestReleaseDate, other.latestReleaseDate) && Objects.equals(this.commitHash, other.commitHash) && Objects.equals(this.artifactId, other.artifactId) && Objects.equals(this.title, other.title) && Objects.equals(this.cvss, other.cvss) && Objects.equals(this.cve, other.cve) && Objects.equals(this.cveStatus, other.cveStatus) && Objects.equals(this.disclosureDateUtc, other.disclosureDateUtc) && Objects.equals(this.vulnMethods, other.vulnMethods) && Objects.equals((Object)this.artifactSeverity, (Object)other.artifactSeverity) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.status, this.type, this.dependencyMode, this.issueSeverity, this.libraryName, this.libraryVersion, this.libraryReleaseDate, this.coordinateType, this.coord1, this.coord2, this.latestVersion, this.latestReleaseDate, this.commitHash, this.artifactId, this.title, this.cvss, this.cve, this.cveStatus, this.disclosureDateUtc, this.vulnMethods, this.artifactSeverity, this._unsetProperties});
        }

        public String toString() {
            return "partial VulnIssueResourceModel{" + COMMA_JOINER.join((Object)(!this._unsetProperties.contains((Object)Property.STATUS) ? "status=" + (Object)((Object)this.status) : null), (Object)(!this._unsetProperties.contains((Object)Property.TYPE) ? "type=" + (Object)((Object)this.type) : null), new Object[]{!this._unsetProperties.contains((Object)Property.DEPENDENCY_MODE) ? "dependencyMode=" + (Object)((Object)this.dependencyMode) : null, this.issueSeverity != null ? "issueSeverity=" + this.issueSeverity : null, this.libraryName != null ? "libraryName=" + this.libraryName : null, this.libraryVersion != null ? "libraryVersion=" + this.libraryVersion : null, this.libraryReleaseDate != null ? "libraryReleaseDate=" + this.libraryReleaseDate : null, this.coordinateType != null ? "coordinateType=" + (Object)((Object)this.coordinateType) : null, this.coord1 != null ? "coord1=" + this.coord1 : null, this.coord2 != null ? "coord2=" + this.coord2 : null, this.latestVersion != null ? "latestVersion=" + this.latestVersion : null, this.latestReleaseDate != null ? "latestReleaseDate=" + this.latestReleaseDate : null, this.commitHash != null ? "commitHash=" + this.commitHash : null, !this._unsetProperties.contains((Object)Property.ARTIFACT_ID) ? "artifactId=" + this.artifactId : null, !this._unsetProperties.contains((Object)Property.TITLE) ? "title=" + this.title : null, this.cvss != null ? "cvss=" + this.cvss : null, this.cve != null ? "cve=" + this.cve : null, !this._unsetProperties.contains((Object)Property.CVE_STATUS) ? "cveStatus=" + this.cveStatus : null, this.disclosureDateUtc != null ? "disclosureDateUtc=" + this.disclosureDateUtc : null, this.vulnMethods != null ? "vulnMethods=" + this.vulnMethods : null, !this._unsetProperties.contains((Object)Property.ARTIFACT_SEVERITY) ? "artifactSeverity=" + (Object)((Object)this.artifactSeverity) : null}) + "}";
        }
    }

    private static final class Value
    implements VulnIssueResourceModel {
        private final IssueStatus status;
        private final IssueType type;
        private final IssueLibraryDependencyMode dependencyMode;
        @Nullable
        private final Float issueSeverity;
        @Nullable
        private final String libraryName;
        @Nullable
        private final String libraryVersion;
        @Nullable
        private final Date libraryReleaseDate;
        @Nullable
        private final CoordinateType coordinateType;
        @Nullable
        private final String coord1;
        @Nullable
        private final String coord2;
        @Nullable
        private final String latestVersion;
        @Nullable
        private final Date latestReleaseDate;
        @Nullable
        private final String commitHash;
        private final long artifactId;
        private final String title;
        @Nullable
        private final Float cvss;
        @Nullable
        private final String cve;
        private final CVEStatus cveStatus;
        @Nullable
        private final Date disclosureDateUtc;
        @Nullable
        private final Boolean vulnMethods;
        private final ArtifactSeverity artifactSeverity;

        private Value(VulnIssueResourceModel_Builder builder) {
            this.status = builder.status;
            this.type = builder.type;
            this.dependencyMode = builder.dependencyMode;
            this.issueSeverity = builder.issueSeverity;
            this.libraryName = builder.libraryName;
            this.libraryVersion = builder.libraryVersion;
            this.libraryReleaseDate = builder.libraryReleaseDate;
            this.coordinateType = builder.coordinateType;
            this.coord1 = builder.coord1;
            this.coord2 = builder.coord2;
            this.latestVersion = builder.latestVersion;
            this.latestReleaseDate = builder.latestReleaseDate;
            this.commitHash = builder.commitHash;
            this.artifactId = builder.artifactId;
            this.title = builder.title;
            this.cvss = builder.cvss;
            this.cve = builder.cve;
            this.cveStatus = builder.cveStatus;
            this.disclosureDateUtc = builder.disclosureDateUtc;
            this.vulnMethods = builder.vulnMethods;
            this.artifactSeverity = builder.artifactSeverity;
        }

        @Override
        @JsonProperty(value="status")
        public IssueStatus getStatus() {
            return this.status;
        }

        @Override
        @JsonProperty(value="type")
        public IssueType getType() {
            return this.type;
        }

        @Override
        @JsonProperty(value="dependencyMode")
        public IssueLibraryDependencyMode getDependencyMode() {
            return this.dependencyMode;
        }

        @Override
        @JsonProperty(value="issueSeverity")
        @Nullable
        public Float getIssueSeverity() {
            return this.issueSeverity;
        }

        @Override
        @JsonProperty(value="libraryName")
        @Nullable
        public String getLibraryName() {
            return this.libraryName;
        }

        @Override
        @JsonProperty(value="libraryVersion")
        @Nullable
        public String getLibraryVersion() {
            return this.libraryVersion;
        }

        @Override
        @JsonProperty(value="libraryReleaseDate")
        @Nullable
        public Date getLibraryReleaseDate() {
            return this.libraryReleaseDate;
        }

        @Override
        @JsonProperty(value="coordinateType")
        @Nullable
        public CoordinateType getCoordinateType() {
            return this.coordinateType;
        }

        @Override
        @JsonProperty(value="coord1")
        @Nullable
        public String getCoord1() {
            return this.coord1;
        }

        @Override
        @JsonProperty(value="coord2")
        @Nullable
        public String getCoord2() {
            return this.coord2;
        }

        @Override
        @JsonProperty(value="latestVersion")
        @Nullable
        public String getLatestVersion() {
            return this.latestVersion;
        }

        @Override
        @JsonProperty(value="latestReleaseDate")
        @Nullable
        public Date getLatestReleaseDate() {
            return this.latestReleaseDate;
        }

        @Override
        @JsonProperty(value="commitHash")
        @Nullable
        public String getCommitHash() {
            return this.commitHash;
        }

        @Override
        @JsonProperty(value="artifactId")
        public long getArtifactId() {
            return this.artifactId;
        }

        @Override
        @JsonProperty(value="title")
        public String getTitle() {
            return this.title;
        }

        @Override
        @JsonProperty(value="cvss")
        @Nullable
        public Float getCvss() {
            return this.cvss;
        }

        @Override
        @JsonProperty(value="cve")
        @Nullable
        public String getCve() {
            return this.cve;
        }

        @Override
        @JsonProperty(value="cveStatus")
        public CVEStatus getCveStatus() {
            return this.cveStatus;
        }

        @Override
        @JsonProperty(value="disclosureDateUtc")
        @Nullable
        public Date getDisclosureDateUtc() {
            return this.disclosureDateUtc;
        }

        @Override
        @JsonProperty(value="vulnMethods")
        @Nullable
        public Boolean getVulnMethods() {
            return this.vulnMethods;
        }

        @Override
        @JsonProperty(value="artifactSeverity")
        public ArtifactSeverity getArtifactSeverity() {
            return this.artifactSeverity;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals((Object)this.status, (Object)other.status) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals((Object)this.dependencyMode, (Object)other.dependencyMode) && Objects.equals(this.issueSeverity, other.issueSeverity) && Objects.equals(this.libraryName, other.libraryName) && Objects.equals(this.libraryVersion, other.libraryVersion) && Objects.equals(this.libraryReleaseDate, other.libraryReleaseDate) && Objects.equals((Object)this.coordinateType, (Object)other.coordinateType) && Objects.equals(this.coord1, other.coord1) && Objects.equals(this.coord2, other.coord2) && Objects.equals(this.latestVersion, other.latestVersion) && Objects.equals(this.latestReleaseDate, other.latestReleaseDate) && Objects.equals(this.commitHash, other.commitHash) && Objects.equals(this.artifactId, other.artifactId) && Objects.equals(this.title, other.title) && Objects.equals(this.cvss, other.cvss) && Objects.equals(this.cve, other.cve) && Objects.equals(this.cveStatus, other.cveStatus) && Objects.equals(this.disclosureDateUtc, other.disclosureDateUtc) && Objects.equals(this.vulnMethods, other.vulnMethods) && Objects.equals((Object)this.artifactSeverity, (Object)other.artifactSeverity);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.status, this.type, this.dependencyMode, this.issueSeverity, this.libraryName, this.libraryVersion, this.libraryReleaseDate, this.coordinateType, this.coord1, this.coord2, this.latestVersion, this.latestReleaseDate, this.commitHash, this.artifactId, this.title, this.cvss, this.cve, this.cveStatus, this.disclosureDateUtc, this.vulnMethods, this.artifactSeverity});
        }

        public String toString() {
            return "VulnIssueResourceModel{" + COMMA_JOINER.join((Object)("status=" + (Object)((Object)this.status)), (Object)("type=" + (Object)((Object)this.type)), new Object[]{"dependencyMode=" + (Object)((Object)this.dependencyMode), this.issueSeverity != null ? "issueSeverity=" + this.issueSeverity : null, this.libraryName != null ? "libraryName=" + this.libraryName : null, this.libraryVersion != null ? "libraryVersion=" + this.libraryVersion : null, this.libraryReleaseDate != null ? "libraryReleaseDate=" + this.libraryReleaseDate : null, this.coordinateType != null ? "coordinateType=" + (Object)((Object)this.coordinateType) : null, this.coord1 != null ? "coord1=" + this.coord1 : null, this.coord2 != null ? "coord2=" + this.coord2 : null, this.latestVersion != null ? "latestVersion=" + this.latestVersion : null, this.latestReleaseDate != null ? "latestReleaseDate=" + this.latestReleaseDate : null, this.commitHash != null ? "commitHash=" + this.commitHash : null, "artifactId=" + this.artifactId, "title=" + this.title, this.cvss != null ? "cvss=" + this.cvss : null, this.cve != null ? "cve=" + this.cve : null, "cveStatus=" + this.cveStatus, this.disclosureDateUtc != null ? "disclosureDateUtc=" + this.disclosureDateUtc : null, this.vulnMethods != null ? "vulnMethods=" + this.vulnMethods : null, "artifactSeverity=" + (Object)((Object)this.artifactSeverity)}) + "}";
        }
    }

    private static enum Property {
        STATUS("status"),
        TYPE("type"),
        DEPENDENCY_MODE("dependencyMode"),
        ARTIFACT_ID("artifactId"),
        TITLE("title"),
        CVE_STATUS("cveStatus"),
        ARTIFACT_SEVERITY("artifactSeverity");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

