/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.diff;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.sourceclear.api.data.artifact.CVEStatus;
import com.sourceclear.api.data.diff.ArtifactSeverity;
import com.sourceclear.api.data.diff.VulnResourceModel;
import java.util.Date;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

abstract class VulnResourceModel_Builder {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    private String id;
    private String title;
    private float cvss;
    @Nullable
    private String cve = null;
    private CVEStatus cveStatus;
    @Nullable
    private String libraryName = null;
    @Nullable
    private String coord1 = null;
    @Nullable
    private String coord2 = null;
    @Nullable
    private String libraryVersion = null;
    @Nullable
    private Date disclosureDateUtc = null;
    @Nullable
    private Boolean vulnMethods = null;
    @Nullable
    private String commitHash = null;
    private ArtifactSeverity artifactSeverity;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    VulnResourceModel_Builder() {
    }

    public static VulnResourceModel.Builder from(VulnResourceModel value) {
        return new VulnResourceModel.Builder().mergeFrom(value);
    }

    @JsonProperty(value="id")
    public VulnResourceModel.Builder setId(String id) {
        this.id = (String)Preconditions.checkNotNull((Object)id);
        this._unsetProperties.remove((Object)Property.ID);
        return (VulnResourceModel.Builder)this;
    }

    public VulnResourceModel.Builder mapId(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setId((String)mapper.apply(this.getId()));
    }

    public String getId() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.ID) ? 1 : 0) != 0, (Object)"id not set");
        return this.id;
    }

    @JsonProperty(value="title")
    public VulnResourceModel.Builder setTitle(String title) {
        this.title = (String)Preconditions.checkNotNull((Object)title);
        this._unsetProperties.remove((Object)Property.TITLE);
        return (VulnResourceModel.Builder)this;
    }

    public VulnResourceModel.Builder mapTitle(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setTitle((String)mapper.apply(this.getTitle()));
    }

    public String getTitle() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.TITLE) ? 1 : 0) != 0, (Object)"title not set");
        return this.title;
    }

    @JsonProperty(value="cvss")
    public VulnResourceModel.Builder setCvss(float cvss) {
        this.cvss = cvss;
        this._unsetProperties.remove((Object)Property.CVSS);
        return (VulnResourceModel.Builder)this;
    }

    public VulnResourceModel.Builder mapCvss(UnaryOperator<Float> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setCvss(((Float)mapper.apply(Float.valueOf(this.getCvss()))).floatValue());
    }

    public float getCvss() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.CVSS) ? 1 : 0) != 0, (Object)"cvss not set");
        return this.cvss;
    }

    @JsonProperty(value="cve")
    public VulnResourceModel.Builder setCve(@Nullable String cve) {
        this.cve = cve;
        return (VulnResourceModel.Builder)this;
    }

    public VulnResourceModel.Builder mapCve(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        String cve = this.getCve();
        if (cve != null) {
            this.setCve((String)mapper.apply(cve));
        }
        return (VulnResourceModel.Builder)this;
    }

    @Nullable
    public String getCve() {
        return this.cve;
    }

    @JsonProperty(value="cveStatus")
    public VulnResourceModel.Builder setCveStatus(CVEStatus cveStatus) {
        this.cveStatus = (CVEStatus)Preconditions.checkNotNull((Object)cveStatus);
        this._unsetProperties.remove((Object)Property.CVE_STATUS);
        return (VulnResourceModel.Builder)this;
    }

    public VulnResourceModel.Builder mapCveStatus(UnaryOperator<CVEStatus> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setCveStatus((CVEStatus)mapper.apply(this.getCveStatus()));
    }

    public CVEStatus getCveStatus() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.CVE_STATUS) ? 1 : 0) != 0, (Object)"cveStatus not set");
        return this.cveStatus;
    }

    @JsonProperty(value="libraryName")
    public VulnResourceModel.Builder setLibraryName(@Nullable String libraryName) {
        this.libraryName = libraryName;
        return (VulnResourceModel.Builder)this;
    }

    public VulnResourceModel.Builder mapLibraryName(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        String libraryName = this.getLibraryName();
        if (libraryName != null) {
            this.setLibraryName((String)mapper.apply(libraryName));
        }
        return (VulnResourceModel.Builder)this;
    }

    @Nullable
    public String getLibraryName() {
        return this.libraryName;
    }

    @JsonProperty(value="coord1")
    public VulnResourceModel.Builder setCoord1(@Nullable String coord1) {
        this.coord1 = coord1;
        return (VulnResourceModel.Builder)this;
    }

    public VulnResourceModel.Builder mapCoord1(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        String coord1 = this.getCoord1();
        if (coord1 != null) {
            this.setCoord1((String)mapper.apply(coord1));
        }
        return (VulnResourceModel.Builder)this;
    }

    @Nullable
    public String getCoord1() {
        return this.coord1;
    }

    @JsonProperty(value="coord2")
    public VulnResourceModel.Builder setCoord2(@Nullable String coord2) {
        this.coord2 = coord2;
        return (VulnResourceModel.Builder)this;
    }

    public VulnResourceModel.Builder mapCoord2(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        String coord2 = this.getCoord2();
        if (coord2 != null) {
            this.setCoord2((String)mapper.apply(coord2));
        }
        return (VulnResourceModel.Builder)this;
    }

    @Nullable
    public String getCoord2() {
        return this.coord2;
    }

    @JsonProperty(value="libraryVersion")
    public VulnResourceModel.Builder setLibraryVersion(@Nullable String libraryVersion) {
        this.libraryVersion = libraryVersion;
        return (VulnResourceModel.Builder)this;
    }

    public VulnResourceModel.Builder mapLibraryVersion(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        String libraryVersion = this.getLibraryVersion();
        if (libraryVersion != null) {
            this.setLibraryVersion((String)mapper.apply(libraryVersion));
        }
        return (VulnResourceModel.Builder)this;
    }

    @Nullable
    public String getLibraryVersion() {
        return this.libraryVersion;
    }

    @JsonProperty(value="disclosureDateUtc")
    public VulnResourceModel.Builder setDisclosureDateUtc(@Nullable Date disclosureDateUtc) {
        this.disclosureDateUtc = disclosureDateUtc;
        return (VulnResourceModel.Builder)this;
    }

    public VulnResourceModel.Builder mapDisclosureDateUtc(UnaryOperator<Date> mapper) {
        Preconditions.checkNotNull(mapper);
        Date disclosureDateUtc = this.getDisclosureDateUtc();
        if (disclosureDateUtc != null) {
            this.setDisclosureDateUtc((Date)mapper.apply(disclosureDateUtc));
        }
        return (VulnResourceModel.Builder)this;
    }

    @Nullable
    public Date getDisclosureDateUtc() {
        return this.disclosureDateUtc;
    }

    @JsonProperty(value="vulnMethods")
    public VulnResourceModel.Builder setVulnMethods(@Nullable Boolean vulnMethods) {
        this.vulnMethods = vulnMethods;
        return (VulnResourceModel.Builder)this;
    }

    public VulnResourceModel.Builder mapVulnMethods(UnaryOperator<Boolean> mapper) {
        Preconditions.checkNotNull(mapper);
        Boolean vulnMethods = this.getVulnMethods();
        if (vulnMethods != null) {
            this.setVulnMethods((Boolean)mapper.apply(vulnMethods));
        }
        return (VulnResourceModel.Builder)this;
    }

    @Nullable
    public Boolean getVulnMethods() {
        return this.vulnMethods;
    }

    @JsonProperty(value="commitHash")
    public VulnResourceModel.Builder setCommitHash(@Nullable String commitHash) {
        this.commitHash = commitHash;
        return (VulnResourceModel.Builder)this;
    }

    public VulnResourceModel.Builder mapCommitHash(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        String commitHash = this.getCommitHash();
        if (commitHash != null) {
            this.setCommitHash((String)mapper.apply(commitHash));
        }
        return (VulnResourceModel.Builder)this;
    }

    @Nullable
    public String getCommitHash() {
        return this.commitHash;
    }

    @JsonProperty(value="artifactSeverity")
    public VulnResourceModel.Builder setArtifactSeverity(ArtifactSeverity artifactSeverity) {
        this.artifactSeverity = (ArtifactSeverity)((Object)Preconditions.checkNotNull((Object)((Object)artifactSeverity)));
        this._unsetProperties.remove((Object)Property.ARTIFACT_SEVERITY);
        return (VulnResourceModel.Builder)this;
    }

    public VulnResourceModel.Builder mapArtifactSeverity(UnaryOperator<ArtifactSeverity> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setArtifactSeverity((ArtifactSeverity)((Object)mapper.apply(this.getArtifactSeverity())));
    }

    public ArtifactSeverity getArtifactSeverity() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.ARTIFACT_SEVERITY) ? 1 : 0) != 0, (Object)"artifactSeverity not set");
        return this.artifactSeverity;
    }

    public VulnResourceModel.Builder mergeFrom(VulnResourceModel value) {
        VulnResourceModel.Builder _defaults = new VulnResourceModel.Builder();
        if (_defaults._unsetProperties.contains((Object)Property.ID) || !Objects.equals(value.getId(), ((VulnResourceModel_Builder)_defaults).getId())) {
            this.setId(value.getId());
        }
        if (_defaults._unsetProperties.contains((Object)Property.TITLE) || !Objects.equals(value.getTitle(), ((VulnResourceModel_Builder)_defaults).getTitle())) {
            this.setTitle(value.getTitle());
        }
        if (_defaults._unsetProperties.contains((Object)Property.CVSS) || !Objects.equals(Float.valueOf(value.getCvss()), Float.valueOf(((VulnResourceModel_Builder)_defaults).getCvss()))) {
            this.setCvss(value.getCvss());
        }
        if (!Objects.equals(value.getCve(), ((VulnResourceModel_Builder)_defaults).getCve())) {
            this.setCve(value.getCve());
        }
        if (_defaults._unsetProperties.contains((Object)Property.CVE_STATUS) || !Objects.equals(value.getCveStatus(), ((VulnResourceModel_Builder)_defaults).getCveStatus())) {
            this.setCveStatus(value.getCveStatus());
        }
        if (!Objects.equals(value.getLibraryName(), ((VulnResourceModel_Builder)_defaults).getLibraryName())) {
            this.setLibraryName(value.getLibraryName());
        }
        if (!Objects.equals(value.getCoord1(), ((VulnResourceModel_Builder)_defaults).getCoord1())) {
            this.setCoord1(value.getCoord1());
        }
        if (!Objects.equals(value.getCoord2(), ((VulnResourceModel_Builder)_defaults).getCoord2())) {
            this.setCoord2(value.getCoord2());
        }
        if (!Objects.equals(value.getLibraryVersion(), ((VulnResourceModel_Builder)_defaults).getLibraryVersion())) {
            this.setLibraryVersion(value.getLibraryVersion());
        }
        if (!Objects.equals(value.getDisclosureDateUtc(), ((VulnResourceModel_Builder)_defaults).getDisclosureDateUtc())) {
            this.setDisclosureDateUtc(value.getDisclosureDateUtc());
        }
        if (!Objects.equals(value.getVulnMethods(), ((VulnResourceModel_Builder)_defaults).getVulnMethods())) {
            this.setVulnMethods(value.getVulnMethods());
        }
        if (!Objects.equals(value.getCommitHash(), ((VulnResourceModel_Builder)_defaults).getCommitHash())) {
            this.setCommitHash(value.getCommitHash());
        }
        if (_defaults._unsetProperties.contains((Object)Property.ARTIFACT_SEVERITY) || !Objects.equals((Object)value.getArtifactSeverity(), (Object)((VulnResourceModel_Builder)_defaults).getArtifactSeverity())) {
            this.setArtifactSeverity(value.getArtifactSeverity());
        }
        return (VulnResourceModel.Builder)this;
    }

    public VulnResourceModel.Builder mergeFrom(VulnResourceModel.Builder template) {
        VulnResourceModel.Builder base = template;
        VulnResourceModel.Builder _defaults = new VulnResourceModel.Builder();
        if (!(base._unsetProperties.contains((Object)Property.ID) || !_defaults._unsetProperties.contains((Object)Property.ID) && Objects.equals(template.getId(), ((VulnResourceModel_Builder)_defaults).getId()))) {
            this.setId(template.getId());
        }
        if (!(base._unsetProperties.contains((Object)Property.TITLE) || !_defaults._unsetProperties.contains((Object)Property.TITLE) && Objects.equals(template.getTitle(), ((VulnResourceModel_Builder)_defaults).getTitle()))) {
            this.setTitle(template.getTitle());
        }
        if (!(base._unsetProperties.contains((Object)Property.CVSS) || !_defaults._unsetProperties.contains((Object)Property.CVSS) && Objects.equals(Float.valueOf(template.getCvss()), Float.valueOf(((VulnResourceModel_Builder)_defaults).getCvss())))) {
            this.setCvss(template.getCvss());
        }
        if (!Objects.equals(template.getCve(), ((VulnResourceModel_Builder)_defaults).getCve())) {
            this.setCve(template.getCve());
        }
        if (!(base._unsetProperties.contains((Object)Property.CVE_STATUS) || !_defaults._unsetProperties.contains((Object)Property.CVE_STATUS) && Objects.equals(template.getCveStatus(), ((VulnResourceModel_Builder)_defaults).getCveStatus()))) {
            this.setCveStatus(template.getCveStatus());
        }
        if (!Objects.equals(template.getLibraryName(), ((VulnResourceModel_Builder)_defaults).getLibraryName())) {
            this.setLibraryName(template.getLibraryName());
        }
        if (!Objects.equals(template.getCoord1(), ((VulnResourceModel_Builder)_defaults).getCoord1())) {
            this.setCoord1(template.getCoord1());
        }
        if (!Objects.equals(template.getCoord2(), ((VulnResourceModel_Builder)_defaults).getCoord2())) {
            this.setCoord2(template.getCoord2());
        }
        if (!Objects.equals(template.getLibraryVersion(), ((VulnResourceModel_Builder)_defaults).getLibraryVersion())) {
            this.setLibraryVersion(template.getLibraryVersion());
        }
        if (!Objects.equals(template.getDisclosureDateUtc(), ((VulnResourceModel_Builder)_defaults).getDisclosureDateUtc())) {
            this.setDisclosureDateUtc(template.getDisclosureDateUtc());
        }
        if (!Objects.equals(template.getVulnMethods(), ((VulnResourceModel_Builder)_defaults).getVulnMethods())) {
            this.setVulnMethods(template.getVulnMethods());
        }
        if (!Objects.equals(template.getCommitHash(), ((VulnResourceModel_Builder)_defaults).getCommitHash())) {
            this.setCommitHash(template.getCommitHash());
        }
        if (!(base._unsetProperties.contains((Object)Property.ARTIFACT_SEVERITY) || !_defaults._unsetProperties.contains((Object)Property.ARTIFACT_SEVERITY) && Objects.equals((Object)template.getArtifactSeverity(), (Object)((VulnResourceModel_Builder)_defaults).getArtifactSeverity()))) {
            this.setArtifactSeverity(template.getArtifactSeverity());
        }
        return (VulnResourceModel.Builder)this;
    }

    public VulnResourceModel.Builder clear() {
        VulnResourceModel.Builder _defaults = new VulnResourceModel.Builder();
        this.id = _defaults.id;
        this.title = _defaults.title;
        this.cvss = _defaults.cvss;
        this.cve = _defaults.cve;
        this.cveStatus = _defaults.cveStatus;
        this.libraryName = _defaults.libraryName;
        this.coord1 = _defaults.coord1;
        this.coord2 = _defaults.coord2;
        this.libraryVersion = _defaults.libraryVersion;
        this.disclosureDateUtc = _defaults.disclosureDateUtc;
        this.vulnMethods = _defaults.vulnMethods;
        this.commitHash = _defaults.commitHash;
        this.artifactSeverity = _defaults.artifactSeverity;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(_defaults._unsetProperties);
        return (VulnResourceModel.Builder)this;
    }

    public VulnResourceModel build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", (Object[])new Object[]{this._unsetProperties});
        return new Value(this);
    }

    @VisibleForTesting
    public VulnResourceModel buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    implements VulnResourceModel {
        private final String id;
        private final String title;
        private final float cvss;
        @Nullable
        private final String cve;
        private final CVEStatus cveStatus;
        @Nullable
        private final String libraryName;
        @Nullable
        private final String coord1;
        @Nullable
        private final String coord2;
        @Nullable
        private final String libraryVersion;
        @Nullable
        private final Date disclosureDateUtc;
        @Nullable
        private final Boolean vulnMethods;
        @Nullable
        private final String commitHash;
        private final ArtifactSeverity artifactSeverity;
        private final EnumSet<Property> _unsetProperties;

        Partial(VulnResourceModel_Builder builder) {
            this.id = builder.id;
            this.title = builder.title;
            this.cvss = builder.cvss;
            this.cve = builder.cve;
            this.cveStatus = builder.cveStatus;
            this.libraryName = builder.libraryName;
            this.coord1 = builder.coord1;
            this.coord2 = builder.coord2;
            this.libraryVersion = builder.libraryVersion;
            this.disclosureDateUtc = builder.disclosureDateUtc;
            this.vulnMethods = builder.vulnMethods;
            this.commitHash = builder.commitHash;
            this.artifactSeverity = builder.artifactSeverity;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        @JsonProperty(value="id")
        public String getId() {
            if (this._unsetProperties.contains((Object)Property.ID)) {
                throw new UnsupportedOperationException("id not set");
            }
            return this.id;
        }

        @Override
        @JsonProperty(value="title")
        public String getTitle() {
            if (this._unsetProperties.contains((Object)Property.TITLE)) {
                throw new UnsupportedOperationException("title not set");
            }
            return this.title;
        }

        @Override
        @JsonProperty(value="cvss")
        public float getCvss() {
            if (this._unsetProperties.contains((Object)Property.CVSS)) {
                throw new UnsupportedOperationException("cvss not set");
            }
            return this.cvss;
        }

        @Override
        @JsonProperty(value="cve")
        @Nullable
        public String getCve() {
            return this.cve;
        }

        @Override
        @JsonProperty(value="cveStatus")
        public CVEStatus getCveStatus() {
            if (this._unsetProperties.contains((Object)Property.CVE_STATUS)) {
                throw new UnsupportedOperationException("cveStatus not set");
            }
            return this.cveStatus;
        }

        @Override
        @JsonProperty(value="libraryName")
        @Nullable
        public String getLibraryName() {
            return this.libraryName;
        }

        @Override
        @JsonProperty(value="coord1")
        @Nullable
        public String getCoord1() {
            return this.coord1;
        }

        @Override
        @JsonProperty(value="coord2")
        @Nullable
        public String getCoord2() {
            return this.coord2;
        }

        @Override
        @JsonProperty(value="libraryVersion")
        @Nullable
        public String getLibraryVersion() {
            return this.libraryVersion;
        }

        @Override
        @JsonProperty(value="disclosureDateUtc")
        @Nullable
        public Date getDisclosureDateUtc() {
            return this.disclosureDateUtc;
        }

        @Override
        @JsonProperty(value="vulnMethods")
        @Nullable
        public Boolean getVulnMethods() {
            return this.vulnMethods;
        }

        @Override
        @JsonProperty(value="commitHash")
        @Nullable
        public String getCommitHash() {
            return this.commitHash;
        }

        @Override
        @JsonProperty(value="artifactSeverity")
        public ArtifactSeverity getArtifactSeverity() {
            if (this._unsetProperties.contains((Object)Property.ARTIFACT_SEVERITY)) {
                throw new UnsupportedOperationException("artifactSeverity not set");
            }
            return this.artifactSeverity;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.title, other.title) && Objects.equals(Float.valueOf(this.cvss), Float.valueOf(other.cvss)) && Objects.equals(this.cve, other.cve) && Objects.equals(this.cveStatus, other.cveStatus) && Objects.equals(this.libraryName, other.libraryName) && Objects.equals(this.coord1, other.coord1) && Objects.equals(this.coord2, other.coord2) && Objects.equals(this.libraryVersion, other.libraryVersion) && Objects.equals(this.disclosureDateUtc, other.disclosureDateUtc) && Objects.equals(this.vulnMethods, other.vulnMethods) && Objects.equals(this.commitHash, other.commitHash) && Objects.equals((Object)this.artifactSeverity, (Object)other.artifactSeverity) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.id, this.title, Float.valueOf(this.cvss), this.cve, this.cveStatus, this.libraryName, this.coord1, this.coord2, this.libraryVersion, this.disclosureDateUtc, this.vulnMethods, this.commitHash, this.artifactSeverity, this._unsetProperties});
        }

        public String toString() {
            return "partial VulnResourceModel{" + COMMA_JOINER.join((Object)(!this._unsetProperties.contains((Object)Property.ID) ? "id=" + this.id : null), (Object)(!this._unsetProperties.contains((Object)Property.TITLE) ? "title=" + this.title : null), new Object[]{!this._unsetProperties.contains((Object)Property.CVSS) ? "cvss=" + this.cvss : null, this.cve != null ? "cve=" + this.cve : null, !this._unsetProperties.contains((Object)Property.CVE_STATUS) ? "cveStatus=" + this.cveStatus : null, this.libraryName != null ? "libraryName=" + this.libraryName : null, this.coord1 != null ? "coord1=" + this.coord1 : null, this.coord2 != null ? "coord2=" + this.coord2 : null, this.libraryVersion != null ? "libraryVersion=" + this.libraryVersion : null, this.disclosureDateUtc != null ? "disclosureDateUtc=" + this.disclosureDateUtc : null, this.vulnMethods != null ? "vulnMethods=" + this.vulnMethods : null, this.commitHash != null ? "commitHash=" + this.commitHash : null, !this._unsetProperties.contains((Object)Property.ARTIFACT_SEVERITY) ? "artifactSeverity=" + (Object)((Object)this.artifactSeverity) : null}) + "}";
        }
    }

    private static final class Value
    implements VulnResourceModel {
        private final String id;
        private final String title;
        private final float cvss;
        @Nullable
        private final String cve;
        private final CVEStatus cveStatus;
        @Nullable
        private final String libraryName;
        @Nullable
        private final String coord1;
        @Nullable
        private final String coord2;
        @Nullable
        private final String libraryVersion;
        @Nullable
        private final Date disclosureDateUtc;
        @Nullable
        private final Boolean vulnMethods;
        @Nullable
        private final String commitHash;
        private final ArtifactSeverity artifactSeverity;

        private Value(VulnResourceModel_Builder builder) {
            this.id = builder.id;
            this.title = builder.title;
            this.cvss = builder.cvss;
            this.cve = builder.cve;
            this.cveStatus = builder.cveStatus;
            this.libraryName = builder.libraryName;
            this.coord1 = builder.coord1;
            this.coord2 = builder.coord2;
            this.libraryVersion = builder.libraryVersion;
            this.disclosureDateUtc = builder.disclosureDateUtc;
            this.vulnMethods = builder.vulnMethods;
            this.commitHash = builder.commitHash;
            this.artifactSeverity = builder.artifactSeverity;
        }

        @Override
        @JsonProperty(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @JsonProperty(value="title")
        public String getTitle() {
            return this.title;
        }

        @Override
        @JsonProperty(value="cvss")
        public float getCvss() {
            return this.cvss;
        }

        @Override
        @JsonProperty(value="cve")
        @Nullable
        public String getCve() {
            return this.cve;
        }

        @Override
        @JsonProperty(value="cveStatus")
        public CVEStatus getCveStatus() {
            return this.cveStatus;
        }

        @Override
        @JsonProperty(value="libraryName")
        @Nullable
        public String getLibraryName() {
            return this.libraryName;
        }

        @Override
        @JsonProperty(value="coord1")
        @Nullable
        public String getCoord1() {
            return this.coord1;
        }

        @Override
        @JsonProperty(value="coord2")
        @Nullable
        public String getCoord2() {
            return this.coord2;
        }

        @Override
        @JsonProperty(value="libraryVersion")
        @Nullable
        public String getLibraryVersion() {
            return this.libraryVersion;
        }

        @Override
        @JsonProperty(value="disclosureDateUtc")
        @Nullable
        public Date getDisclosureDateUtc() {
            return this.disclosureDateUtc;
        }

        @Override
        @JsonProperty(value="vulnMethods")
        @Nullable
        public Boolean getVulnMethods() {
            return this.vulnMethods;
        }

        @Override
        @JsonProperty(value="commitHash")
        @Nullable
        public String getCommitHash() {
            return this.commitHash;
        }

        @Override
        @JsonProperty(value="artifactSeverity")
        public ArtifactSeverity getArtifactSeverity() {
            return this.artifactSeverity;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.title, other.title) && Objects.equals(Float.valueOf(this.cvss), Float.valueOf(other.cvss)) && Objects.equals(this.cve, other.cve) && Objects.equals(this.cveStatus, other.cveStatus) && Objects.equals(this.libraryName, other.libraryName) && Objects.equals(this.coord1, other.coord1) && Objects.equals(this.coord2, other.coord2) && Objects.equals(this.libraryVersion, other.libraryVersion) && Objects.equals(this.disclosureDateUtc, other.disclosureDateUtc) && Objects.equals(this.vulnMethods, other.vulnMethods) && Objects.equals(this.commitHash, other.commitHash) && Objects.equals((Object)this.artifactSeverity, (Object)other.artifactSeverity);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.id, this.title, Float.valueOf(this.cvss), this.cve, this.cveStatus, this.libraryName, this.coord1, this.coord2, this.libraryVersion, this.disclosureDateUtc, this.vulnMethods, this.commitHash, this.artifactSeverity});
        }

        public String toString() {
            return "VulnResourceModel{" + COMMA_JOINER.join((Object)("id=" + this.id), (Object)("title=" + this.title), new Object[]{"cvss=" + this.cvss, this.cve != null ? "cve=" + this.cve : null, "cveStatus=" + this.cveStatus, this.libraryName != null ? "libraryName=" + this.libraryName : null, this.coord1 != null ? "coord1=" + this.coord1 : null, this.coord2 != null ? "coord2=" + this.coord2 : null, this.libraryVersion != null ? "libraryVersion=" + this.libraryVersion : null, this.disclosureDateUtc != null ? "disclosureDateUtc=" + this.disclosureDateUtc : null, this.vulnMethods != null ? "vulnMethods=" + this.vulnMethods : null, this.commitHash != null ? "commitHash=" + this.commitHash : null, "artifactSeverity=" + (Object)((Object)this.artifactSeverity)}) + "}";
        }
    }

    private static enum Property {
        ID("id"),
        TITLE("title"),
        CVSS("cvss"),
        CVE_STATUS("cveStatus"),
        ARTIFACT_SEVERITY("artifactSeverity");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

