/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.sourceclear.api.data.PlanType;
import com.sourceclear.api.data.events.OrgModel;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.UnaryOperator;

abstract class OrgModel_Builder {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    private long id;
    private String name;
    private PlanType planType;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    OrgModel_Builder() {
    }

    public static OrgModel.Builder from(OrgModel value) {
        return new OrgModel.Builder().mergeFrom(value);
    }

    @JsonProperty(value="id")
    public OrgModel.Builder setId(long id) {
        this.id = id;
        this._unsetProperties.remove((Object)Property.ID);
        return (OrgModel.Builder)this;
    }

    public OrgModel.Builder mapId(UnaryOperator<Long> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setId((Long)mapper.apply(this.getId()));
    }

    public long getId() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.ID) ? 1 : 0) != 0, (Object)"id not set");
        return this.id;
    }

    @JsonProperty(value="name")
    public OrgModel.Builder setName(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this._unsetProperties.remove((Object)Property.NAME);
        return (OrgModel.Builder)this;
    }

    public OrgModel.Builder mapName(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setName((String)mapper.apply(this.getName()));
    }

    public String getName() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.NAME) ? 1 : 0) != 0, (Object)"name not set");
        return this.name;
    }

    @JsonProperty(value="planType")
    public OrgModel.Builder setPlanType(PlanType planType) {
        this.planType = (PlanType)((Object)Preconditions.checkNotNull((Object)((Object)planType)));
        this._unsetProperties.remove((Object)Property.PLAN_TYPE);
        return (OrgModel.Builder)this;
    }

    public OrgModel.Builder mapPlanType(UnaryOperator<PlanType> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setPlanType((PlanType)((Object)mapper.apply(this.getPlanType())));
    }

    public PlanType getPlanType() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.PLAN_TYPE) ? 1 : 0) != 0, (Object)"planType not set");
        return this.planType;
    }

    public OrgModel.Builder mergeFrom(OrgModel value) {
        OrgModel.Builder _defaults = new OrgModel.Builder();
        if (_defaults._unsetProperties.contains((Object)Property.ID) || !Objects.equals(value.getId(), ((OrgModel_Builder)_defaults).getId())) {
            this.setId(value.getId());
        }
        if (_defaults._unsetProperties.contains((Object)Property.NAME) || !Objects.equals(value.getName(), ((OrgModel_Builder)_defaults).getName())) {
            this.setName(value.getName());
        }
        if (_defaults._unsetProperties.contains((Object)Property.PLAN_TYPE) || !Objects.equals((Object)value.getPlanType(), (Object)((OrgModel_Builder)_defaults).getPlanType())) {
            this.setPlanType(value.getPlanType());
        }
        return (OrgModel.Builder)this;
    }

    public OrgModel.Builder mergeFrom(OrgModel.Builder template) {
        OrgModel.Builder base = template;
        OrgModel.Builder _defaults = new OrgModel.Builder();
        if (!(base._unsetProperties.contains((Object)Property.ID) || !_defaults._unsetProperties.contains((Object)Property.ID) && Objects.equals(template.getId(), ((OrgModel_Builder)_defaults).getId()))) {
            this.setId(template.getId());
        }
        if (!(base._unsetProperties.contains((Object)Property.NAME) || !_defaults._unsetProperties.contains((Object)Property.NAME) && Objects.equals(template.getName(), ((OrgModel_Builder)_defaults).getName()))) {
            this.setName(template.getName());
        }
        if (!(base._unsetProperties.contains((Object)Property.PLAN_TYPE) || !_defaults._unsetProperties.contains((Object)Property.PLAN_TYPE) && Objects.equals((Object)template.getPlanType(), (Object)((OrgModel_Builder)_defaults).getPlanType()))) {
            this.setPlanType(template.getPlanType());
        }
        return (OrgModel.Builder)this;
    }

    public OrgModel.Builder clear() {
        OrgModel.Builder _defaults = new OrgModel.Builder();
        this.id = _defaults.id;
        this.name = _defaults.name;
        this.planType = _defaults.planType;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(_defaults._unsetProperties);
        return (OrgModel.Builder)this;
    }

    public OrgModel build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", (Object[])new Object[]{this._unsetProperties});
        return new Value(this);
    }

    @VisibleForTesting
    public OrgModel buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    implements OrgModel {
        private final long id;
        private final String name;
        private final PlanType planType;
        private final EnumSet<Property> _unsetProperties;

        Partial(OrgModel_Builder builder) {
            this.id = builder.id;
            this.name = builder.name;
            this.planType = builder.planType;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        @JsonProperty(value="id")
        public long getId() {
            if (this._unsetProperties.contains((Object)Property.ID)) {
                throw new UnsupportedOperationException("id not set");
            }
            return this.id;
        }

        @Override
        @JsonProperty(value="name")
        public String getName() {
            if (this._unsetProperties.contains((Object)Property.NAME)) {
                throw new UnsupportedOperationException("name not set");
            }
            return this.name;
        }

        @Override
        @JsonProperty(value="planType")
        public PlanType getPlanType() {
            if (this._unsetProperties.contains((Object)Property.PLAN_TYPE)) {
                throw new UnsupportedOperationException("planType not set");
            }
            return this.planType;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals((Object)this.planType, (Object)other.planType) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.id, this.name, this.planType, this._unsetProperties});
        }

        public String toString() {
            return "partial OrgModel{" + COMMA_JOINER.join((Object)(!this._unsetProperties.contains((Object)Property.ID) ? "id=" + this.id : null), (Object)(!this._unsetProperties.contains((Object)Property.NAME) ? "name=" + this.name : null), new Object[]{!this._unsetProperties.contains((Object)Property.PLAN_TYPE) ? "planType=" + (Object)((Object)this.planType) : null}) + "}";
        }
    }

    private static final class Value
    implements OrgModel {
        private final long id;
        private final String name;
        private final PlanType planType;

        private Value(OrgModel_Builder builder) {
            this.id = builder.id;
            this.name = builder.name;
            this.planType = builder.planType;
        }

        @Override
        @JsonProperty(value="id")
        public long getId() {
            return this.id;
        }

        @Override
        @JsonProperty(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        @JsonProperty(value="planType")
        public PlanType getPlanType() {
            return this.planType;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals((Object)this.planType, (Object)other.planType);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.id, this.name, this.planType});
        }

        public String toString() {
            return "OrgModel{id=" + this.id + ", name=" + this.name + ", planType=" + (Object)((Object)this.planType) + "}";
        }
    }

    private static enum Property {
        ID("id"),
        NAME("name"),
        PLAN_TYPE("planType");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

