/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.sourceclear.api.data.events.WorkspaceModel;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.UnaryOperator;

abstract class WorkspaceModel_Builder {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    private long id;
    private String name;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    WorkspaceModel_Builder() {
    }

    public static WorkspaceModel.Builder from(WorkspaceModel value) {
        return new WorkspaceModel.Builder().mergeFrom(value);
    }

    @JsonProperty(value="id")
    public WorkspaceModel.Builder setId(long id) {
        this.id = id;
        this._unsetProperties.remove((Object)Property.ID);
        return (WorkspaceModel.Builder)this;
    }

    public WorkspaceModel.Builder mapId(UnaryOperator<Long> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setId((Long)mapper.apply(this.getId()));
    }

    public long getId() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.ID) ? 1 : 0) != 0, (Object)"id not set");
        return this.id;
    }

    @JsonProperty(value="name")
    public WorkspaceModel.Builder setName(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this._unsetProperties.remove((Object)Property.NAME);
        return (WorkspaceModel.Builder)this;
    }

    public WorkspaceModel.Builder mapName(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setName((String)mapper.apply(this.getName()));
    }

    public String getName() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.NAME) ? 1 : 0) != 0, (Object)"name not set");
        return this.name;
    }

    public WorkspaceModel.Builder mergeFrom(WorkspaceModel value) {
        WorkspaceModel.Builder _defaults = new WorkspaceModel.Builder();
        if (_defaults._unsetProperties.contains((Object)Property.ID) || !Objects.equals(value.getId(), ((WorkspaceModel_Builder)_defaults).getId())) {
            this.setId(value.getId());
        }
        if (_defaults._unsetProperties.contains((Object)Property.NAME) || !Objects.equals(value.getName(), ((WorkspaceModel_Builder)_defaults).getName())) {
            this.setName(value.getName());
        }
        return (WorkspaceModel.Builder)this;
    }

    public WorkspaceModel.Builder mergeFrom(WorkspaceModel.Builder template) {
        WorkspaceModel.Builder base = template;
        WorkspaceModel.Builder _defaults = new WorkspaceModel.Builder();
        if (!(base._unsetProperties.contains((Object)Property.ID) || !_defaults._unsetProperties.contains((Object)Property.ID) && Objects.equals(template.getId(), ((WorkspaceModel_Builder)_defaults).getId()))) {
            this.setId(template.getId());
        }
        if (!(base._unsetProperties.contains((Object)Property.NAME) || !_defaults._unsetProperties.contains((Object)Property.NAME) && Objects.equals(template.getName(), ((WorkspaceModel_Builder)_defaults).getName()))) {
            this.setName(template.getName());
        }
        return (WorkspaceModel.Builder)this;
    }

    public WorkspaceModel.Builder clear() {
        WorkspaceModel.Builder _defaults = new WorkspaceModel.Builder();
        this.id = _defaults.id;
        this.name = _defaults.name;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(_defaults._unsetProperties);
        return (WorkspaceModel.Builder)this;
    }

    public WorkspaceModel build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", (Object[])new Object[]{this._unsetProperties});
        return new Value(this);
    }

    @VisibleForTesting
    public WorkspaceModel buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    implements WorkspaceModel {
        private final long id;
        private final String name;
        private final EnumSet<Property> _unsetProperties;

        Partial(WorkspaceModel_Builder builder) {
            this.id = builder.id;
            this.name = builder.name;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        @JsonProperty(value="id")
        public long getId() {
            if (this._unsetProperties.contains((Object)Property.ID)) {
                throw new UnsupportedOperationException("id not set");
            }
            return this.id;
        }

        @Override
        @JsonProperty(value="name")
        public String getName() {
            if (this._unsetProperties.contains((Object)Property.NAME)) {
                throw new UnsupportedOperationException("name not set");
            }
            return this.name;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this._unsetProperties);
        }

        public String toString() {
            return "partial WorkspaceModel{" + COMMA_JOINER.join((Object)(!this._unsetProperties.contains((Object)Property.ID) ? "id=" + this.id : null), !this._unsetProperties.contains((Object)Property.NAME) ? "name=" + this.name : null, new Object[0]) + "}";
        }
    }

    private static final class Value
    implements WorkspaceModel {
        private final long id;
        private final String name;

        private Value(WorkspaceModel_Builder builder) {
            this.id = builder.id;
            this.name = builder.name;
        }

        @Override
        @JsonProperty(value="id")
        public long getId() {
            return this.id;
        }

        @Override
        @JsonProperty(value="name")
        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name);
        }

        public String toString() {
            return "WorkspaceModel{id=" + this.id + ", name=" + this.name + "}";
        }
    }

    private static enum Property {
        ID("id"),
        NAME("name");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

