/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.evidence;

import com.google.common.base.Strings;
import com.sourceclear.api.data.evidence.Evidence;
import com.sourceclear.api.data.evidence.EvidenceType;
import com.sourceclear.api.data.evidence.ValidEvidence;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class EvidenceValidator
implements ConstraintValidator<ValidEvidence, Evidence> {
    public void initialize(ValidEvidence constraintAnnotation) {
    }

    public boolean isValid(Evidence value, ConstraintValidatorContext context) {
        EvidenceType evidenceType = value.getEvidenceType();
        if (evidenceType == null) {
            return false;
        }
        switch (evidenceType) {
            case COORDINATES: {
                return value.getCoordinates() != null;
            }
            case SHA1: {
                return !Strings.isNullOrEmpty((String)value.getSha1());
            }
            case JAR: 
            case SHA2: {
                return !Strings.isNullOrEmpty((String)value.getSha2());
            }
            case BYTECODE: {
                return !Strings.isNullOrEmpty((String)value.getBytecodeHash());
            }
            case COMMIT: {
                return value.getCoordinates() != null && !Strings.isNullOrEmpty((String)value.getCommitHash());
            }
            case FILEPATH: {
                return false;
            }
            case SO: {
                return value.getCoordinates() != null || !Strings.isNullOrEmpty((String)value.getSha2());
            }
        }
        return true;
    }
}

