/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.match;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.sourceclear.api.data.match.LibDeltaQuery;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.BaseStream;

abstract class LibDeltaQuery_Builder {
    private Set<LibDeltaQuery.QueryPair> queryPairs = ImmutableSet.of();

    LibDeltaQuery_Builder() {
    }

    public static LibDeltaQuery.Builder from(LibDeltaQuery value) {
        return new LibDeltaQuery.Builder().mergeFrom(value);
    }

    public LibDeltaQuery.Builder addQueryPairs(LibDeltaQuery.QueryPair element) {
        if (this.queryPairs instanceof ImmutableSet) {
            this.queryPairs = new LinkedHashSet<LibDeltaQuery.QueryPair>(this.queryPairs);
        }
        this.queryPairs.add((LibDeltaQuery.QueryPair)Preconditions.checkNotNull((Object)element));
        return (LibDeltaQuery.Builder)this;
    }

    public LibDeltaQuery.Builder addQueryPairs(LibDeltaQuery.QueryPair ... elements) {
        return this.addAllQueryPairs(Arrays.asList(elements));
    }

    public LibDeltaQuery.Builder addAllQueryPairs(Spliterator<? extends LibDeltaQuery.QueryPair> elements) {
        elements.forEachRemaining(this::addQueryPairs);
        return (LibDeltaQuery.Builder)this;
    }

    public LibDeltaQuery.Builder addAllQueryPairs(BaseStream<? extends LibDeltaQuery.QueryPair, ?> elements) {
        return this.addAllQueryPairs(elements.spliterator());
    }

    @JsonProperty(value="queryPairs")
    public LibDeltaQuery.Builder addAllQueryPairs(Iterable<? extends LibDeltaQuery.QueryPair> elements) {
        elements.forEach(this::addQueryPairs);
        return (LibDeltaQuery.Builder)this;
    }

    public LibDeltaQuery.Builder removeQueryPairs(LibDeltaQuery.QueryPair element) {
        if (this.queryPairs instanceof ImmutableSet) {
            this.queryPairs = new LinkedHashSet<LibDeltaQuery.QueryPair>(this.queryPairs);
        }
        this.queryPairs.remove(Preconditions.checkNotNull((Object)element));
        return (LibDeltaQuery.Builder)this;
    }

    public LibDeltaQuery.Builder mutateQueryPairs(Consumer<? super Set<LibDeltaQuery.QueryPair>> mutator) {
        if (this.queryPairs instanceof ImmutableSet) {
            this.queryPairs = new LinkedHashSet<LibDeltaQuery.QueryPair>(this.queryPairs);
        }
        mutator.accept(this.queryPairs);
        return (LibDeltaQuery.Builder)this;
    }

    public LibDeltaQuery.Builder clearQueryPairs() {
        if (this.queryPairs instanceof ImmutableSet) {
            this.queryPairs = ImmutableSet.of();
        } else {
            this.queryPairs.clear();
        }
        return (LibDeltaQuery.Builder)this;
    }

    public Set<LibDeltaQuery.QueryPair> getQueryPairs() {
        if (this.queryPairs instanceof ImmutableSet) {
            this.queryPairs = new LinkedHashSet<LibDeltaQuery.QueryPair>(this.queryPairs);
        }
        return Collections.unmodifiableSet(this.queryPairs);
    }

    public LibDeltaQuery.Builder mergeFrom(LibDeltaQuery value) {
        if (value instanceof Value && this.queryPairs == ImmutableSet.of()) {
            this.queryPairs = ImmutableSet.copyOf(value.getQueryPairs());
        } else {
            this.addAllQueryPairs(value.getQueryPairs());
        }
        return (LibDeltaQuery.Builder)this;
    }

    public LibDeltaQuery.Builder mergeFrom(LibDeltaQuery.Builder template) {
        LibDeltaQuery.Builder base = template;
        this.addAllQueryPairs(base.queryPairs);
        return (LibDeltaQuery.Builder)this;
    }

    public LibDeltaQuery.Builder clear() {
        this.clearQueryPairs();
        return (LibDeltaQuery.Builder)this;
    }

    public LibDeltaQuery build() {
        return new Value(this);
    }

    @VisibleForTesting
    public LibDeltaQuery buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    implements LibDeltaQuery {
        private final Set<LibDeltaQuery.QueryPair> queryPairs;

        Partial(LibDeltaQuery_Builder builder) {
            this.queryPairs = ImmutableSet.copyOf((Collection)builder.queryPairs);
        }

        @Override
        @JsonProperty(value="queryPairs")
        public Set<LibDeltaQuery.QueryPair> getQueryPairs() {
            return this.queryPairs;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.queryPairs, other.queryPairs);
        }

        public int hashCode() {
            return Objects.hash(this.queryPairs);
        }

        public String toString() {
            return "partial LibDeltaQuery{queryPairs=" + this.queryPairs + "}";
        }
    }

    private static final class Value
    implements LibDeltaQuery {
        private final Set<LibDeltaQuery.QueryPair> queryPairs;

        private Value(LibDeltaQuery_Builder builder) {
            this.queryPairs = ImmutableSet.copyOf((Collection)builder.queryPairs);
        }

        @Override
        @JsonProperty(value="queryPairs")
        public Set<LibDeltaQuery.QueryPair> getQueryPairs() {
            return this.queryPairs;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.queryPairs, other.queryPairs);
        }

        public int hashCode() {
            return Objects.hash(this.queryPairs);
        }

        public String toString() {
            return "LibDeltaQuery{queryPairs=" + this.queryPairs + "}";
        }
    }
}

