/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.match;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.sourceclear.api.data.match.LibDeltaQuery;
import com.sourceclear.api.data.match.LibDeltaResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.BaseStream;

abstract class LibDeltaResponse_Builder {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    private List<LibDeltaResponse.QueryPairAndLibDelta> queryPairAndLibDeltas = ImmutableList.of();
    private Set<LibDeltaQuery.QueryPair> assumedBrokenUpdates = ImmutableSet.of();

    LibDeltaResponse_Builder() {
    }

    public static LibDeltaResponse.Builder from(LibDeltaResponse value) {
        return new LibDeltaResponse.Builder().mergeFrom(value);
    }

    public LibDeltaResponse.Builder addQueryPairAndLibDeltas(LibDeltaResponse.QueryPairAndLibDelta element) {
        if (this.queryPairAndLibDeltas instanceof ImmutableList) {
            this.queryPairAndLibDeltas = new ArrayList<LibDeltaResponse.QueryPairAndLibDelta>(this.queryPairAndLibDeltas);
        }
        this.queryPairAndLibDeltas.add((LibDeltaResponse.QueryPairAndLibDelta)Preconditions.checkNotNull((Object)element));
        return (LibDeltaResponse.Builder)this;
    }

    public LibDeltaResponse.Builder addQueryPairAndLibDeltas(LibDeltaResponse.QueryPairAndLibDelta ... elements) {
        return this.addAllQueryPairAndLibDeltas(Arrays.asList(elements));
    }

    public LibDeltaResponse.Builder addAllQueryPairAndLibDeltas(Spliterator<? extends LibDeltaResponse.QueryPairAndLibDelta> elements) {
        long elementsSize;
        if ((elements.characteristics() & 0x40) != 0 && (elementsSize = elements.estimateSize()) > 0L && elementsSize <= Integer.MAX_VALUE) {
            if (this.queryPairAndLibDeltas instanceof ImmutableList) {
                this.queryPairAndLibDeltas = new ArrayList<LibDeltaResponse.QueryPairAndLibDelta>(this.queryPairAndLibDeltas);
            }
            ((ArrayList)this.queryPairAndLibDeltas).ensureCapacity(this.queryPairAndLibDeltas.size() + (int)elementsSize);
        }
        elements.forEachRemaining(this::addQueryPairAndLibDeltas);
        return (LibDeltaResponse.Builder)this;
    }

    public LibDeltaResponse.Builder addAllQueryPairAndLibDeltas(BaseStream<? extends LibDeltaResponse.QueryPairAndLibDelta, ?> elements) {
        return this.addAllQueryPairAndLibDeltas(elements.spliterator());
    }

    @JsonProperty(value="queryPairAndLibDeltas")
    public LibDeltaResponse.Builder addAllQueryPairAndLibDeltas(Iterable<? extends LibDeltaResponse.QueryPairAndLibDelta> elements) {
        return this.addAllQueryPairAndLibDeltas(elements.spliterator());
    }

    public LibDeltaResponse.Builder mutateQueryPairAndLibDeltas(Consumer<? super List<LibDeltaResponse.QueryPairAndLibDelta>> mutator) {
        if (this.queryPairAndLibDeltas instanceof ImmutableList) {
            this.queryPairAndLibDeltas = new ArrayList<LibDeltaResponse.QueryPairAndLibDelta>(this.queryPairAndLibDeltas);
        }
        mutator.accept(this.queryPairAndLibDeltas);
        return (LibDeltaResponse.Builder)this;
    }

    public LibDeltaResponse.Builder clearQueryPairAndLibDeltas() {
        if (this.queryPairAndLibDeltas instanceof ImmutableList) {
            this.queryPairAndLibDeltas = ImmutableList.of();
        } else {
            this.queryPairAndLibDeltas.clear();
        }
        return (LibDeltaResponse.Builder)this;
    }

    public List<LibDeltaResponse.QueryPairAndLibDelta> getQueryPairAndLibDeltas() {
        if (this.queryPairAndLibDeltas instanceof ImmutableList) {
            this.queryPairAndLibDeltas = new ArrayList<LibDeltaResponse.QueryPairAndLibDelta>(this.queryPairAndLibDeltas);
        }
        return Collections.unmodifiableList(this.queryPairAndLibDeltas);
    }

    public LibDeltaResponse.Builder addAssumedBrokenUpdates(LibDeltaQuery.QueryPair element) {
        if (this.assumedBrokenUpdates instanceof ImmutableSet) {
            this.assumedBrokenUpdates = new LinkedHashSet<LibDeltaQuery.QueryPair>(this.assumedBrokenUpdates);
        }
        this.assumedBrokenUpdates.add((LibDeltaQuery.QueryPair)Preconditions.checkNotNull((Object)element));
        return (LibDeltaResponse.Builder)this;
    }

    public LibDeltaResponse.Builder addAssumedBrokenUpdates(LibDeltaQuery.QueryPair ... elements) {
        return this.addAllAssumedBrokenUpdates(Arrays.asList(elements));
    }

    public LibDeltaResponse.Builder addAllAssumedBrokenUpdates(Spliterator<? extends LibDeltaQuery.QueryPair> elements) {
        elements.forEachRemaining(this::addAssumedBrokenUpdates);
        return (LibDeltaResponse.Builder)this;
    }

    public LibDeltaResponse.Builder addAllAssumedBrokenUpdates(BaseStream<? extends LibDeltaQuery.QueryPair, ?> elements) {
        return this.addAllAssumedBrokenUpdates(elements.spliterator());
    }

    @JsonProperty(value="assumedBrokenUpdates")
    public LibDeltaResponse.Builder addAllAssumedBrokenUpdates(Iterable<? extends LibDeltaQuery.QueryPair> elements) {
        elements.forEach(this::addAssumedBrokenUpdates);
        return (LibDeltaResponse.Builder)this;
    }

    public LibDeltaResponse.Builder removeAssumedBrokenUpdates(LibDeltaQuery.QueryPair element) {
        if (this.assumedBrokenUpdates instanceof ImmutableSet) {
            this.assumedBrokenUpdates = new LinkedHashSet<LibDeltaQuery.QueryPair>(this.assumedBrokenUpdates);
        }
        this.assumedBrokenUpdates.remove(Preconditions.checkNotNull((Object)element));
        return (LibDeltaResponse.Builder)this;
    }

    public LibDeltaResponse.Builder mutateAssumedBrokenUpdates(Consumer<? super Set<LibDeltaQuery.QueryPair>> mutator) {
        if (this.assumedBrokenUpdates instanceof ImmutableSet) {
            this.assumedBrokenUpdates = new LinkedHashSet<LibDeltaQuery.QueryPair>(this.assumedBrokenUpdates);
        }
        mutator.accept(this.assumedBrokenUpdates);
        return (LibDeltaResponse.Builder)this;
    }

    public LibDeltaResponse.Builder clearAssumedBrokenUpdates() {
        if (this.assumedBrokenUpdates instanceof ImmutableSet) {
            this.assumedBrokenUpdates = ImmutableSet.of();
        } else {
            this.assumedBrokenUpdates.clear();
        }
        return (LibDeltaResponse.Builder)this;
    }

    public Set<LibDeltaQuery.QueryPair> getAssumedBrokenUpdates() {
        if (this.assumedBrokenUpdates instanceof ImmutableSet) {
            this.assumedBrokenUpdates = new LinkedHashSet<LibDeltaQuery.QueryPair>(this.assumedBrokenUpdates);
        }
        return Collections.unmodifiableSet(this.assumedBrokenUpdates);
    }

    public LibDeltaResponse.Builder mergeFrom(LibDeltaResponse value) {
        if (value instanceof Value && this.queryPairAndLibDeltas == ImmutableList.of()) {
            this.queryPairAndLibDeltas = ImmutableList.copyOf(value.getQueryPairAndLibDeltas());
        } else {
            this.addAllQueryPairAndLibDeltas(value.getQueryPairAndLibDeltas());
        }
        if (value instanceof Value && this.assumedBrokenUpdates == ImmutableSet.of()) {
            this.assumedBrokenUpdates = ImmutableSet.copyOf(value.getAssumedBrokenUpdates());
        } else {
            this.addAllAssumedBrokenUpdates(value.getAssumedBrokenUpdates());
        }
        return (LibDeltaResponse.Builder)this;
    }

    public LibDeltaResponse.Builder mergeFrom(LibDeltaResponse.Builder template) {
        LibDeltaResponse.Builder base = template;
        this.addAllQueryPairAndLibDeltas(base.queryPairAndLibDeltas);
        this.addAllAssumedBrokenUpdates(base.assumedBrokenUpdates);
        return (LibDeltaResponse.Builder)this;
    }

    public LibDeltaResponse.Builder clear() {
        this.clearQueryPairAndLibDeltas();
        this.clearAssumedBrokenUpdates();
        return (LibDeltaResponse.Builder)this;
    }

    public LibDeltaResponse build() {
        return new Value(this);
    }

    @VisibleForTesting
    public LibDeltaResponse buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    implements LibDeltaResponse {
        private final List<LibDeltaResponse.QueryPairAndLibDelta> queryPairAndLibDeltas;
        private final Set<LibDeltaQuery.QueryPair> assumedBrokenUpdates;

        Partial(LibDeltaResponse_Builder builder) {
            this.queryPairAndLibDeltas = ImmutableList.copyOf((Collection)builder.queryPairAndLibDeltas);
            this.assumedBrokenUpdates = ImmutableSet.copyOf((Collection)builder.assumedBrokenUpdates);
        }

        @Override
        @JsonProperty(value="queryPairAndLibDeltas")
        public List<LibDeltaResponse.QueryPairAndLibDelta> getQueryPairAndLibDeltas() {
            return this.queryPairAndLibDeltas;
        }

        @Override
        @JsonProperty(value="assumedBrokenUpdates")
        public Set<LibDeltaQuery.QueryPair> getAssumedBrokenUpdates() {
            return this.assumedBrokenUpdates;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.queryPairAndLibDeltas, other.queryPairAndLibDeltas) && Objects.equals(this.assumedBrokenUpdates, other.assumedBrokenUpdates);
        }

        public int hashCode() {
            return Objects.hash(this.queryPairAndLibDeltas, this.assumedBrokenUpdates);
        }

        public String toString() {
            return "partial LibDeltaResponse{" + COMMA_JOINER.join((Object)("queryPairAndLibDeltas=" + this.queryPairAndLibDeltas), (Object)("assumedBrokenUpdates=" + this.assumedBrokenUpdates), new Object[0]) + "}";
        }
    }

    private static final class Value
    implements LibDeltaResponse {
        private final List<LibDeltaResponse.QueryPairAndLibDelta> queryPairAndLibDeltas;
        private final Set<LibDeltaQuery.QueryPair> assumedBrokenUpdates;

        private Value(LibDeltaResponse_Builder builder) {
            this.queryPairAndLibDeltas = ImmutableList.copyOf((Collection)builder.queryPairAndLibDeltas);
            this.assumedBrokenUpdates = ImmutableSet.copyOf((Collection)builder.assumedBrokenUpdates);
        }

        @Override
        @JsonProperty(value="queryPairAndLibDeltas")
        public List<LibDeltaResponse.QueryPairAndLibDelta> getQueryPairAndLibDeltas() {
            return this.queryPairAndLibDeltas;
        }

        @Override
        @JsonProperty(value="assumedBrokenUpdates")
        public Set<LibDeltaQuery.QueryPair> getAssumedBrokenUpdates() {
            return this.assumedBrokenUpdates;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.queryPairAndLibDeltas, other.queryPairAndLibDeltas) && Objects.equals(this.assumedBrokenUpdates, other.assumedBrokenUpdates);
        }

        public int hashCode() {
            return Objects.hash(this.queryPairAndLibDeltas, this.assumedBrokenUpdates);
        }

        public String toString() {
            return "LibDeltaResponse{queryPairAndLibDeltas=" + this.queryPairAndLibDeltas + ", assumedBrokenUpdates=" + this.assumedBrokenUpdates + "}";
        }
    }
}

