/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.match;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sourceclear.api.data.analytics.AgentRuntimeData;
import com.sourceclear.api.data.evidence.Evidence;
import com.sourceclear.api.data.git.MetaGit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MatchQuery
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="scanId")
    private String scanId;
    @JsonProperty(value="projectId")
    private Long projectId;
    @JsonProperty(value="projectName")
    private String projectName;
    @JsonProperty(value="organization")
    private String organization;
    @Deprecated
    @JsonProperty(value="commitHash")
    private String commitHash;
    @Deprecated
    @JsonProperty(value="repoUrl")
    private String repoUrl;
    @JsonProperty(value="vulnMethods")
    private boolean vulnMethods;
    @JsonProperty(value="persist")
    private boolean persist;
    @Deprecated
    @JsonProperty(value="branch")
    private String branch;
    @Valid
    @JsonProperty(value="evidence")
    private Collection<Evidence> evidence = new ArrayList<Evidence>();
    @JsonProperty(value="linesOfCode")
    private Long linesOfCode;
    @JsonProperty(value="metaGit")
    private MetaGit metaGit;
    @JsonProperty(value="agentRuntimeData")
    private AgentRuntimeData agentRuntimeData;
    @JsonProperty(value="workspaceSlug")
    private String workspaceSlug;

    public MatchQuery() {
    }

    public MatchQuery(Builder builder) {
        this.scanId = builder.scanId;
        this.projectId = builder.projectId;
        this.projectName = builder.projectName;
        this.organization = builder.organization;
        this.commitHash = builder.commitHash;
        this.repoUrl = builder.repoUrl;
        this.vulnMethods = builder.vulnMethods;
        this.persist = builder.persist;
        this.branch = builder.branch;
        this.evidence = builder.evidence;
        this.linesOfCode = builder.linesOfCode;
        this.metaGit = builder.metaGit;
        this.agentRuntimeData = builder.agentRuntimeData;
        this.workspaceSlug = builder.workspaceSlug;
    }

    public String getScanId() {
        return this.scanId;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getOrganization() {
        return this.organization;
    }

    @Deprecated
    public String getCommitHash() {
        return this.commitHash;
    }

    @Deprecated
    public String getRepoUrl() {
        return this.repoUrl;
    }

    public boolean isVulnMethods() {
        return this.vulnMethods;
    }

    public boolean isPersist() {
        return this.persist;
    }

    @Deprecated
    public String getBranch() {
        return this.branch;
    }

    @Nullable
    public Collection<Evidence> getEvidence() {
        return this.evidence;
    }

    @Nullable
    public Long getLinesOfCode() {
        return this.linesOfCode;
    }

    public MetaGit getMetaGit() {
        return this.metaGit;
    }

    @Nullable
    public AgentRuntimeData getAgentRuntimeData() {
        return this.agentRuntimeData;
    }

    @Nullable
    public String getWorkspaceSlug() {
        return this.workspaceSlug;
    }

    public static class Builder {
        private String scanId = UUID.randomUUID().toString();
        private Long projectId;
        private String projectName;
        private String organization;
        @Deprecated
        private String commitHash;
        @Deprecated
        private String repoUrl;
        private boolean vulnMethods;
        private boolean publicMethods;
        private boolean persist;
        @Deprecated
        private String branch;
        private Collection<Evidence> evidence = new ArrayList<Evidence>();
        private Long linesOfCode;
        private MetaGit metaGit;
        private boolean needsMetaGit = true;
        private AgentRuntimeData agentRuntimeData;
        private String workspaceSlug;

        public Builder withScanId(String scanId) {
            this.scanId = scanId;
            return this;
        }

        public Builder withProjectId(Long projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder withProjectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public Builder withOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        @Deprecated
        public Builder withCommitHash(String commitHash) {
            this.commitHash = commitHash;
            return this;
        }

        @Deprecated
        public Builder withRepoUrl(String repoUrl) {
            this.repoUrl = repoUrl;
            return this;
        }

        public Builder requestVulnMethods(boolean vulnMethods) {
            this.vulnMethods = vulnMethods;
            return this;
        }

        public Builder requestPublicMethods(boolean publicMethods) {
            this.publicMethods = publicMethods;
            return this;
        }

        public Builder persist(boolean persist) {
            this.persist = persist;
            return this;
        }

        @Deprecated
        public Builder withBranch(String branch) {
            this.branch = branch;
            return this;
        }

        public Builder withEvidence(Collection<Evidence> evidence) {
            this.evidence = evidence;
            return this;
        }

        public Builder withLinesOfCode(Long linesOfCode) {
            this.linesOfCode = linesOfCode;
            return this;
        }

        public Builder withMetaGit(MetaGit metaGit) {
            this.metaGit = metaGit;
            return this;
        }

        public Builder withAgentRuntimeData(AgentRuntimeData agentRuntimeData) {
            this.agentRuntimeData = agentRuntimeData;
            return this;
        }

        public Builder withoutMetaGit() {
            this.needsMetaGit = false;
            return this;
        }

        public Builder withWorkspaceSlug(String workspaceSlug) {
            this.workspaceSlug = workspaceSlug;
            return this;
        }

        public MatchQuery build() throws IllegalStateException {
            if (this.needsMetaGit && this.metaGit == null) {
                throw new IllegalStateException("MetaGit is required for Match Queries");
            }
            return new MatchQuery(this);
        }
    }
}

