/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.match;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sourceclear.api.data.HATEOASApiModel;
import com.sourceclear.api.data.Link;
import com.sourceclear.api.data.artifact.LibraryArtifactApiModel;
import com.sourceclear.api.data.artifact.LibraryMatchWithArtifactsApiModel;
import com.sourceclear.api.data.match.ConsoleUploadStatus;
import com.sourceclear.api.data.match.MatchQuery;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MatchResponse
extends HATEOASApiModel {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="scanId")
    private String scanId;
    @JsonProperty(value="projectId")
    private Long projectId;
    @JsonProperty(value="projectName")
    private String projectName;
    @JsonProperty(value="organization")
    private String organization;
    @JsonProperty(value="commitHash")
    private String commitHash;
    @JsonProperty(value="repoUrl")
    private String repoUrl;
    @JsonProperty(value="consoleUploadStatus")
    private ConsoleUploadStatus consoleUploadStatus;
    @JsonProperty(value="vulnMethods")
    private boolean vulnMethods;
    @JsonProperty(value="branch")
    private String branch;
    @JsonProperty(value="components")
    private List<LibraryMatchWithArtifactsApiModel> components = new ArrayList<LibraryMatchWithArtifactsApiModel>();

    public MatchResponse() {
    }

    public MatchResponse(Builder builder) {
        this.scanId = builder.scanId;
        this.projectId = builder.projectId;
        this.projectName = builder.projectName;
        this.organization = builder.organization;
        this.commitHash = builder.commitHash;
        this.repoUrl = builder.repoUrl;
        this.consoleUploadStatus = builder.consoleUploadStatus;
        this.vulnMethods = builder.vulnMethods;
        this.branch = builder.branch;
        this.components = builder.components;
        for (Link link : builder.links) {
            this.addLink(link);
        }
    }

    public int countVulnerableComponents() {
        HashSet<Long> ids = new HashSet<Long>();
        for (LibraryMatchWithArtifactsApiModel libraryModel : this.components) {
            for (LibraryArtifactApiModel artifact : libraryModel.getArtifacts()) {
                ids.add(artifact.getId());
            }
        }
        return ids.size();
    }

    public String getScanId() {
        return this.scanId;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getCommitHash() {
        return this.commitHash;
    }

    public String getRepoUrl() {
        return this.repoUrl;
    }

    public ConsoleUploadStatus getConsoleUploadStatus() {
        return this.consoleUploadStatus;
    }

    public boolean isVulnMethods() {
        return this.vulnMethods;
    }

    public String getBranch() {
        return this.branch;
    }

    public List<LibraryMatchWithArtifactsApiModel> getComponents() {
        return this.components;
    }

    public static class Builder {
        private String scanId;
        private Long projectId;
        private String projectName;
        private String organization;
        private String commitHash;
        private String repoUrl;
        private ConsoleUploadStatus consoleUploadStatus;
        private boolean vulnMethods = false;
        private String branch;
        private List<LibraryMatchWithArtifactsApiModel> components = new ArrayList<LibraryMatchWithArtifactsApiModel>();
        private List<Link> links = new ArrayList<Link>();

        public Builder fromMatchQuery(MatchQuery matchQuery) {
            this.scanId = matchQuery.getScanId();
            this.projectId = matchQuery.getProjectId();
            this.projectName = matchQuery.getProjectName();
            this.organization = matchQuery.getOrganization();
            this.commitHash = matchQuery.getCommitHash();
            this.repoUrl = matchQuery.getRepoUrl();
            this.vulnMethods = matchQuery.isVulnMethods();
            this.branch = matchQuery.getBranch();
            return this;
        }

        public Builder withScanId(String scanId) {
            this.scanId = scanId;
            return this;
        }

        public Builder withProjectId(Long projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder withProjectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public Builder withOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder withCommitHash(String commitHash) {
            this.commitHash = commitHash;
            return this;
        }

        public Builder withRepoUrl(String repoUrl) {
            this.repoUrl = repoUrl;
            return this;
        }

        public Builder withConsoleUploadStatus(ConsoleUploadStatus consoleUploadStatus) {
            this.consoleUploadStatus = consoleUploadStatus;
            return this;
        }

        public Builder requestVulnMethods(boolean vulnMethods) {
            this.vulnMethods = vulnMethods;
            return this;
        }

        public Builder withBranch(String branch) {
            this.branch = branch;
            return this;
        }

        public Builder withComponents(List<LibraryMatchWithArtifactsApiModel> components) {
            this.components = components;
            return this;
        }

        public Builder withLink(Link link) {
            this.links.add(link);
            return this;
        }

        public MatchResponse build() {
            return new MatchResponse(this);
        }
    }
}

