/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.bytecode;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class CompClassMethodVisitor
extends MethodVisitor {
    private String lastStr = "";
    private final Set<String> algorithms;
    private final String methodName;
    private final Map<String, List<Integer>> methodMap;
    private final Set<String> calledMethods;

    public CompClassMethodVisitor(String methodName, Map<String, List<Integer>> methodMap, Set<String> cM, Set<String> algoSet, int ver) {
        super(ver);
        this.algorithms = algoSet;
        this.methodName = methodName;
        this.methodMap = methodMap;
        this.calledMethods = cM;
    }

    public void visitCode() {
        this.methodMap.put(this.methodName, new LinkedList());
    }

    public void visitMethodInsn(int opc, String owner, String name, String desc, boolean itf) {
        if (!this.lastStr.isEmpty()) {
            if (name.startsWith("getInstance") && Type.getArgumentTypes((String)desc).length > 0 && (owner.startsWith("java/security/") || owner.startsWith("javax/security/") || owner.startsWith("javax/crypto/"))) {
                this.algorithms.add(this.lastStr);
            }
            this.lastStr = "";
        }
        this.calledMethods.add(name);
        this.methodMap.get(this.methodName).add(opc);
    }

    public void visitLdcInsn(Object o) {
        if (o instanceof String) {
            this.lastStr = (String)o;
        }
    }

    public void visitInsn(int opcode) {
        this.methodMap.get(this.methodName).add(opcode);
    }

    public void visitIntInsn(int opcode, int operand) {
        this.methodMap.get(this.methodName).add(opcode);
    }

    public void visitVarInsn(int opcode, int var) {
        this.methodMap.get(this.methodName).add(opcode);
    }

    public void visitJumpInsn(int opcode, Label lbl) {
        this.methodMap.get(this.methodName).add(opcode);
    }

    public void visitTypeInsn(int opcode, String desc) {
        this.methodMap.get(this.methodName).add(opcode);
    }

    public void visitFieldInsn(int opc, String owner, String name, String desc) {
        this.methodMap.get(this.methodName).add(opc);
    }
}

