/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.common;

import com.google.common.collect.Sets;
import com.sourceclear.engine.common.StoredFileVisitor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;

public class SOFileVisitor
extends StoredFileVisitor {
    private static final Set<String> SOFILE_GLOBS = Sets.newHashSet((Object[])new String[]{"*.so", "*.so.*"});
    private static final byte[] ELF_MAGIC = new byte[]{127, 69, 76, 70};
    private final Set<String> ignoredDirectories;
    private final Logger logger;

    public SOFileVisitor(Set<String> ignoredDirectories, Logger logger) {
        this.ignoredDirectories = ignoredDirectories;
        this.logger = logger;
    }

    @Override
    public Set<String> getFileTypesLookedFor() {
        return SOFILE_GLOBS;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        return this.ignoredDirectories.contains(dir.getFileName().toString()) ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        for (String glob : SOFILE_GLOBS) {
            if (!FilenameUtils.wildcardMatch((String)file.getFileName().toString(), (String)glob) || !SOFileVisitor.isELF(file)) continue;
            this.files.add(file.toRealPath(new LinkOption[0]));
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        this.logger.info("Couldn't visit file: " + file.toString(), (Throwable)exc);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    public static boolean isELF(Path file) throws IOException {
        byte[] supposedMagicBytes = new byte[ELF_MAGIC.length];
        try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
            inputStream.read(supposedMagicBytes);
        }
        return Arrays.equals(supposedMagicBytes, ELF_MAGIC);
    }
}

