/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.cocoapods;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.sourceclear.engine.component.cocoapods.Dependency;
import com.sourceclear.engine.component.cocoapods.Pod;
import com.sourceclear.engine.component.cocoapods.Utils;
import java.io.IOException;
import java.util.Iterator;

public class PodDeserializer
extends JsonDeserializer<Pod> {
    private static final String NULL_POD = "NullPod (null)";

    public Pod deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        int lineNumber = jsonParser.getCurrentLocation().getLineNr();
        if (node.isValueNode()) {
            String nameVersion = node.asText(NULL_POD);
            String name = Utils.nameFromNameVersionString(nameVersion);
            String version = Utils.versionFromNameVersionString(nameVersion);
            return Pod.builder().withName(name).withVersion(version).withLineNumber(lineNumber).build();
        }
        if (node.isObject()) {
            Iterator fieldNames = node.fieldNames();
            if (!fieldNames.hasNext()) {
                throw new IOException("Unable to parse PODS section of Podfile.lock: map has no fields ");
            }
            String nameVersion = (String)fieldNames.next();
            Pod.Builder builder = Pod.builder().withName(Utils.nameFromNameVersionString(nameVersion)).withVersion(Utils.versionFromNameVersionString(nameVersion)).withLineNumber(lineNumber);
            JsonNode dependenciesNode = node.get(nameVersion);
            if (!dependenciesNode.isArray()) {
                throw new IOException(String.format("Unable to parse PODS section of Podfile.lock: dependency section of %s is not an array", nameVersion));
            }
            for (JsonNode jsonNode : dependenciesNode) {
                String depNameVersion = jsonNode.asText(NULL_POD);
                builder.withDependency(new Dependency(Utils.nameFromNameVersionString(depNameVersion), Utils.versionFromNameVersionString(depNameVersion)));
            }
            return builder.build();
        }
        throw new IOException("Unable to parse PODS section of Podfile.lock: PODS section contains an unexpected type: " + node.getNodeType());
    }
}

