/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.collectors;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.sourceclear.api.data.analytics.CollectorData;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.common.logging.Stage;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.collectors.CollectorUtils;
import com.sourceclear.engine.component.collectors.NativeCollector;
import com.srcclr.sdk.CoordinateType;
import com.srcclr.sdk.Coords;
import com.srcclr.sdk.LibraryGraph;
import com.srcclr.sdk.LibraryGraphContainer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BowerNativeCollector
implements NativeCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(BowerNativeCollector.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String BOWER_FILE_NAME = "bower.json";
    private final LogStream logStream;
    private final boolean isProduction;
    private final ImmutableMap<String, Object> attributes;
    private final Boolean allowRoot;

    public BowerNativeCollector(LogStream logStream, ImmutableMap<String, Object> attributes) {
        this.logStream = logStream;
        this.isProduction = BowerNativeCollector.isProduction(attributes);
        this.attributes = attributes;
        this.allowRoot = Boolean.valueOf(String.valueOf(this.attributes.get((Object)"ALLOW_ROOT")));
    }

    @Override
    public String getName() {
        return "Bower";
    }

    @Override
    public boolean supports(File projectPath) {
        return CollectorUtils.fileExistsWithinFolder(projectPath, BOWER_FILE_NAME);
    }

    @Override
    public Set<Pattern> patternsOfInterest() {
        return CollectorUtils.regexifyFileNames(BOWER_FILE_NAME);
    }

    @Override
    public boolean systemIsReady(File projectDir) {
        String exeName = "bower";
        String flavorText = "Please ensure that Bower is installed and can be found on PATH.\nAfter that, you may run:\n  srcclr test --bower\nto confirm that your system can scan Bower projects.";
        try {
            CollectorUtils.resolveExeOrThrow("bower", "Please ensure that Bower is installed and can be found on PATH.\nAfter that, you may run:\n  srcclr test --bower\nto confirm that your system can scan Bower projects.");
        }
        catch (CollectionException e) {
            this.logStream.log("com.srcclr.engineconfig.issue", Stage.ENGINE_CONFIGURATION, e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public LibraryGraphContainer collect(File projectRoot) throws CollectionException {
        String genericStatement = "Because of this, SourceClear cannot continue scanning the project.\nPlease ensure that the error is resolved before scanning the project.";
        File bowerDotJson = new File(projectRoot, BOWER_FILE_NAME);
        if (!bowerDotJson.exists() || !bowerDotJson.canRead()) {
            throw new CollectionException(CollectionErrorType.PACKAGE_MANAGER, "SourceClear could not read bower.json.\n" + genericStatement);
        }
        try {
            this.runBowerInstall(projectRoot);
            LibraryGraph graph = this.runBowerListGetComponentsAndVersions(projectRoot);
            return new LibraryGraphContainer.Builder().withGraph(graph).build();
        }
        catch (CollectionException ce) {
            throw new CollectionException(ce.getExceptionType(), ce.getMessage() + "\n" + genericStatement, ce.getErrorLog());
        }
    }

    @Override
    public boolean isMethodsSupported(File projectRoot) {
        return false;
    }

    @Override
    @Nonnull
    public CollectorData getCollectorData() {
        return new CollectorData.Builder().setCollectorName(this.getName()).build();
    }

    void runBowerInstall(File projectDir) throws CollectionException {
        Process bowerInstall;
        ProcessBuilder bowerInstallBuilder = new ProcessBuilder(new String[0]);
        bowerInstallBuilder.redirectErrorStream(true);
        CollectorUtils.populateEnvVars(this.attributes, bowerInstallBuilder);
        bowerInstallBuilder.directory(projectDir);
        bowerInstallBuilder.command("bower", "install");
        if (this.allowRoot.booleanValue()) {
            bowerInstallBuilder.command().add("--allow-root");
        }
        try {
            LOGGER.debug("Running bower install command: " + Joiner.on((String)" ").join(bowerInstallBuilder.command()));
            bowerInstall = bowerInstallBuilder.start();
        }
        catch (IOException e) {
            throw this.debugOutputAndCreateCollectionException(e, CollectionErrorType.PACKAGE_MANAGER, "An error occurred while running bower install: " + e.getMessage());
        }
        try {
            String output = CollectorUtils.readAndLog(bowerInstall.getInputStream(), this.logStream, LOGGER, "com.srcclr.evidence.compilation", Stage.EVIDENCE_COLLECTION);
            int retCode = bowerInstall.waitFor();
            if (retCode != 0) {
                String suggestHelpMsg = "\"bower install\" did not complete successfully.\nPlease check that all packages in bower.json can be installed via\n\"bower install\" command before proceeding.";
                throw new CollectionException(CollectionErrorType.PACKAGE_MANAGER, suggestHelpMsg, output);
            }
        }
        catch (IOException | InterruptedException e) {
            throw this.debugOutputAndCreateCollectionException(e, CollectionErrorType.PACKAGE_MANAGER, "An error occurred while running bower install: " + e.getMessage());
        }
    }

    private LibraryGraph getComponentGraphFromPkgNode(JsonNode node, boolean isDev, boolean isTop, Map<Coords, LibraryGraph> alreadySeen) throws CollectionException {
        LibraryGraph graph;
        Coords coords;
        String transitiveOrDirect;
        String string = transitiveOrDirect = isTop ? "direct" : "transitive";
        if (node == null || !node.isObject()) {
            throw new CollectionException(CollectionErrorType.PACKAGE_MANAGER, "Unexpected format for bower list: expected top-level JSON object.");
        }
        LibraryGraph.Builder builder = new LibraryGraph.Builder();
        JsonNode endpointNode = node.get("endpoint");
        JsonNode pkgMetaNode = node.get("pkgMeta");
        JsonNode nameNode = endpointNode.get("name");
        if (nameNode == null || !nameNode.isTextual()) {
            throw new CollectionException(CollectionErrorType.PACKAGE_MANAGER, "Unexpected format for bower list: expected a string bower package name");
        }
        if (pkgMetaNode == null) {
            this.logStream.log("com.srcclr.evidence.issue", Stage.EVIDENCE_COLLECTION, "Package metadata is missing for " + transitiveOrDirect + " dependency " + nameNode.textValue() + ". This dependency will not be computed.");
            return builder.build();
        }
        if (!isTop) {
            JsonNode versionNode = pkgMetaNode.get("version");
            if (versionNode == null || !versionNode.isTextual()) {
                this.logStream.log("com.srcclr.evidence.issue", Stage.EVIDENCE_COLLECTION, "\"version\" field is missing for " + transitiveOrDirect + " dependency " + nameNode.textValue() + ". This dependency will not be computed.");
                return builder.build();
            }
            Coords.Builder coordsBuilder = new Coords.Builder().withCoordinateType(CoordinateType.BOWER);
            coordsBuilder.withCoordinate1(nameNode.textValue());
            if (isDev) {
                coordsBuilder.withScope("dev");
            }
            coordsBuilder.withVersion(versionNode.textValue());
            Coords coords2 = coordsBuilder.build();
            LibraryGraph alreadySeenGraph = alreadySeen.get(coords2);
            if (alreadySeenGraph != null) {
                return alreadySeenGraph;
            }
            builder.withCoords(coords2);
        }
        HashSet<String> devDependencyNames = new HashSet<String>();
        JsonNode devDependenciesMetaNode = pkgMetaNode.get("devDependencies");
        if (devDependenciesMetaNode != null) {
            for (String devDepName : new IteratorIterable(devDependenciesMetaNode.fieldNames())) {
                devDependencyNames.add(devDepName);
            }
        }
        HashSet<LibraryGraph> directDependencies = new HashSet<LibraryGraph>();
        JsonNode dependenciesNode = node.get("dependencies");
        if (dependenciesNode != null) {
            for (Map.Entry dependencyEntry : new IteratorIterable(dependenciesNode.fields())) {
                LibraryGraph dependencyGraph;
                LOGGER.debug("Processing " + transitiveOrDirect + " dependency: " + (String)dependencyEntry.getKey());
                boolean isDevDependency = devDependencyNames.contains(dependencyEntry.getKey());
                if (this.isProduction && isDevDependency || (dependencyGraph = this.getComponentGraphFromPkgNode((JsonNode)dependencyEntry.getValue(), isDev || isDevDependency, false, alreadySeen)).getCoords() == null) continue;
                directDependencies.add(dependencyGraph);
            }
        }
        if ((coords = (graph = builder.withDirects(directDependencies).withFilename(BOWER_FILE_NAME).build()).getCoords()) != null) {
            alreadySeen.put(coords, graph);
        }
        return graph;
    }

    private CollectionException debugOutputAndCreateCollectionException(Exception cause, CollectionErrorType type, String message) {
        LOGGER.debug(message, (Throwable)cause);
        return new CollectionException(type, message);
    }

    LibraryGraph getLibraryGraphFromListInputStream(InputStream listJson) throws CollectionException, IOException {
        JsonNode node = MAPPER.readTree(listJson);
        return this.getComponentGraphFromPkgNode(node, false, true, new HashMap<Coords, LibraryGraph>());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    LibraryGraph runBowerListGetComponentsAndVersions(File projectDir) throws CollectionException {
        Process bowerList;
        ArrayList commands = Lists.newArrayList((Object[])new String[]{"bower", "list", "--json"});
        ProcessBuilder bowerListBuilder = new ProcessBuilder(new String[0]);
        bowerListBuilder.directory(projectDir);
        if (this.allowRoot.booleanValue()) {
            commands.add("--allow-root");
        }
        bowerListBuilder.command(commands);
        try {
            LOGGER.debug("Running bower list json command: " + Joiner.on((String)" ").join((Iterable)commands));
            bowerList = bowerListBuilder.start();
        }
        catch (IOException e) {
            throw this.debugOutputAndCreateCollectionException(e, CollectionErrorType.PACKAGE_MANAGER, "An error occurred while running bower list: " + e.getMessage());
        }
        try (InputStream listJson = bowerList.getInputStream();){
            LibraryGraph libraryGraph = this.getLibraryGraphFromListInputStream(listJson);
            return libraryGraph;
        }
        catch (IOException e) {
            throw this.debugOutputAndCreateCollectionException(e, CollectionErrorType.PACKAGE_MANAGER, "An error occurred while reading the output of bower list: " + e.getMessage());
        }
    }

    static boolean isProduction(Map<String, Object> attributes) {
        String scope = (String)attributes.get("SCOPE");
        if (Strings.isNullOrEmpty((String)scope)) {
            return false;
        }
        return scope.equals("production");
    }

    private class IteratorIterable<T>
    implements Iterable<T> {
        Iterator<T> iterator;

        IteratorIterable(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public Iterator<T> iterator() {
            return this.iterator;
        }
    }
}

