/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.collectors;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.common.logging.Stage;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.util.io.SrcclrIo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CollectorUtils {
    public static final String BUILD_FAILURE_MESSAGE = "This project does not seem to build.\nBecause of this, SourceClear cannot scan it. Please ensure that the project compiles prior to scanning.";
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectorUtils.class);
    private static final ExecutorService EXECUTORS = Executors.newCachedThreadPool(new ThreadFactory(){
        private final AtomicInteger count = new AtomicInteger();

        @Override
        public Thread newThread(@Nonnull Runnable r) {
            Thread t = new Thread(r);
            t.setName("IO Thread " + this.count.addAndGet(1));
            t.setDaemon(true);
            return t;
        }
    });

    public static Optional<Path> isOrContainFile(Path target, String filename) {
        boolean exists;
        Path checkPath = Files.isDirectory(target, new LinkOption[0]) ? target.resolve(filename) : target;
        boolean bl = exists = Files.exists(checkPath, new LinkOption[0]) && checkPath.getFileName().toString().equals(filename);
        if (exists) {
            return Optional.of((Object)checkPath);
        }
        return Optional.absent();
    }

    static Set<Pattern> regexifyFileNames(Collection<String> filenames) {
        return CollectorUtils.regexifyFileNames(filenames.toArray(new String[0]));
    }

    static Set<Pattern> regexifyFileNames(String ... filenames) {
        HashSet<Pattern> set = new HashSet<Pattern>();
        for (String filename : filenames) {
            set.add(Pattern.compile(filename.replaceAll("\\.", "\\\\.")));
        }
        return set;
    }

    static Future<String> readAsync(InputStream is, LogStream logStream, Logger logger, String logEvent, Stage stage) {
        return EXECUTORS.submit(() -> CollectorUtils.readAndLog(is, logStream, logger, logEvent, stage));
    }

    static String readAndLog(InputStream is, LogStream logStream, Logger logger, String logEvent, Stage stage) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
                logStream.log(logEvent, stage, line);
                logger.info(line);
            }
        }
        return sb.toString();
    }

    @Deprecated
    public static boolean fileExistsWithinFolder(String parentPath, String filename) {
        return CollectorUtils.fileExistsWithinFolder(new File(parentPath), filename);
    }

    public static boolean fileExistsWithinFolder(File parentPath, final String filename) {
        if (parentPath == null) {
            return false;
        }
        if (!parentPath.isDirectory()) {
            return false;
        }
        File[] children = parentPath.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equalsIgnoreCase(filename);
            }
        });
        return children != null && children.length > 0;
    }

    public static File resolveExeOrThrow(String exeName) throws CollectionException {
        return CollectorUtils.resolveExeOrThrow(exeName, "");
    }

    public static File resolveExeOrThrow(String exeName, String flavorText) throws CollectionException {
        String filePath = SrcclrIo.resolveExecutable(exeName);
        if (Strings.isNullOrEmpty((String)filePath)) {
            String exeIs404 = String.format("\"%s\" is not installed or not found on PATH", exeName);
            String msg = flavorText == null || flavorText.isEmpty() ? exeIs404 : String.format("%s%n%s", exeIs404, flavorText);
            throw new CollectionException(CollectionErrorType.SYSTEM, msg);
        }
        return CollectorUtils.ensureExistsAndExecutable(new File(filePath), flavorText);
    }

    public static File ensureExistsAndExecutable(File exe, String flavorText) throws CollectionException {
        if (!exe.exists()) {
            String fileIs0644 = String.format("The \"%s\" file does not exist", exe.getAbsolutePath());
            String msg = flavorText == null || flavorText.isEmpty() ? fileIs0644 : String.format("%s%n%s", fileIs0644, flavorText);
            throw new CollectionException(CollectionErrorType.SYSTEM, msg);
        }
        if (!exe.canExecute()) {
            String fileIs0644 = String.format("The \"%s\" file is not executable", exe.getAbsolutePath());
            String msg = flavorText == null || flavorText.isEmpty() ? fileIs0644 : String.format("%s%n%s", fileIs0644, flavorText);
            throw new CollectionException(CollectionErrorType.SYSTEM, msg);
        }
        return exe;
    }

    public static void populateEnvVars(@Nonnull Map<String, Object> attributes, @Nonnull ProcessBuilder pb) {
        Map envVars = (Map)attributes.get("ENV_VARS");
        if (envVars != null) {
            pb.environment().putAll(envVars);
        }
    }

    public static List<String> launchProcess(List<String> command, File workingDirectory, Map<String, String> envVars, Logger logger) throws CollectionException {
        return CollectorUtils.launchProcess(command, workingDirectory, envVars, logger, BUILD_FAILURE_MESSAGE);
    }

    public static List<String> launchProcess(List<String> command, File workingDirectory, Map<String, String> envVars, Logger logger, String errorMessage) throws CollectionException {
        logger.debug("Launching process with commands: {}", (Object)Joiner.on((String)" ").join(command));
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(command);
        processBuilder.redirectErrorStream(true);
        if (envVars != null) {
            processBuilder.environment().putAll(envVars);
        }
        if (workingDirectory != null) {
            processBuilder.directory(workingDirectory);
        }
        File tmpOutputFile = null;
        try {
            List output;
            tmpOutputFile = File.createTempFile("srcclr-", "-output.txt");
            tmpOutputFile.deleteOnExit();
            processBuilder.redirectOutput(tmpOutputFile);
            logger.debug("Redirecting stdout to tmp file: {}", (Object)tmpOutputFile);
            Process process = processBuilder.start();
            try {
                OutputStream ignored = process.getOutputStream();
                Throwable throwable = null;
                if (ignored != null) {
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        ignored.close();
                    }
                }
            }
            catch (IOException ex) {
                throw new CollectionException(CollectionErrorType.IO, errorMessage, ex.getMessage());
            }
            int rc = process.waitFor();
            try (InputStream inputStream = Files.newInputStream(tmpOutputFile.toPath(), new OpenOption[0]);){
                output = IOUtils.readLines((InputStream)inputStream, (Charset)Charset.defaultCharset());
            }
            if (rc != 0) {
                String error = Joiner.on((String)"\n").join((Iterable)output);
                logger.debug("Process ended with non-zero output. rc={}. error: {}", (Object)rc, (Object)error);
                throw new CollectionException(CollectionErrorType.IO, errorMessage, error);
            }
            List list = output;
            return list;
        }
        catch (IOException | InterruptedException e) {
            throw new CollectionException(CollectionErrorType.IO, errorMessage, e.getMessage());
        }
        finally {
            if (tmpOutputFile != null) {
                tmpOutputFile.delete();
            }
        }
    }

    private CollectorUtils() {
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                EXECUTORS.shutdownNow();
            }
        });
    }
}

