/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.collectors;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.collectors.CollectorUtils;
import com.sourceclear.engine.component.collectors.GoPackageManagerCollector;
import com.sourceclear.engine.component.golang.GlideLockFile;
import com.sourceclear.engine.component.golang.GoDependencyGraph;
import com.sourceclear.engine.component.golang.GoPackage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class GlideNativeCollector
extends GoPackageManagerCollector {
    public static final String GLIDE_LOCK_FILE = "glide.lock";
    private static final String GLIDE_YAML_FILE = "glide.yaml";
    private static final String GLIDE = "glide";
    private GlideLockFile glideLockFile = new GlideLockFile();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GlideLockFile readLockFile(Path filepath) throws CollectionException {
        try (InputStream inputStream = Files.newInputStream(filepath, new OpenOption[0]);){
            GlideLockFile glideLockFile = GlideLockFile.parse(inputStream);
            return glideLockFile;
        }
        catch (IOException e) {
            throw new CollectionException(CollectionErrorType.IO, e.getMessage()).initCause(e);
        }
    }

    public GlideNativeCollector(LogStream logStream, ImmutableMap<String, Object> attributes) {
        super(logStream, attributes);
    }

    @Override
    public String getName() {
        return "Glide";
    }

    @Override
    public boolean supports(File projectPath) {
        return Files.exists(projectPath.toPath().resolve(GLIDE_LOCK_FILE), new LinkOption[0]) || Files.exists(projectPath.toPath().resolve(GLIDE_YAML_FILE), new LinkOption[0]);
    }

    @Override
    public Set<Pattern> patternsOfInterest() {
        return CollectorUtils.regexifyFileNames(GLIDE_LOCK_FILE, GLIDE_YAML_FILE);
    }

    @Override
    protected List<GoPackage> getResolvedImports(File projectRoot, GoDependencyGraph goDependencyGraph, List<String> goPaths) throws CollectionException {
        Path glideLockDependencyFilePath = Paths.get(projectRoot.getAbsolutePath(), GLIDE_LOCK_FILE);
        if (!Files.exists(glideLockDependencyFilePath, new LinkOption[0])) {
            throw new CollectionException(CollectionErrorType.PACKAGE_MANAGER, "Unable to collect dependencies information because glide.lock is not present.\nSet 'FORCE_GO_INSTALL' to true to install dependencies and generate glide.lock.\nThe dependencies will be installed in a temporary folder and will not affect your workspace.");
        }
        this.glideLockFile = GlideNativeCollector.readLockFile(glideLockDependencyFilePath);
        List<GoPackage> list = this.glideLockFile.getImports();
        list.addAll(this.glideLockFile.getTestImports());
        return list;
    }

    @Override
    @Nullable
    protected String getPackageNameUnderScan() {
        return this.glideLockFile.getPackageName();
    }

    @Override
    protected String getIdentityFilename() {
        return GLIDE_LOCK_FILE;
    }

    @Override
    @Nullable
    protected String getBinName() {
        return GLIDE;
    }

    @Override
    @Nullable
    protected List<String> getInstallArgs() {
        return Lists.newArrayList((Object[])new String[]{"install"});
    }
}

