/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.collectors;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.sourceclear.api.client.Client;
import com.sourceclear.api.client.SourceClearClient;
import com.sourceclear.api.data.analytics.CollectorData;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.common.ClassFileVisitor;
import com.sourceclear.engine.common.FileTypeVisitor;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.common.logging.Stage;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.collectors.CollectorUtils;
import com.sourceclear.engine.component.collectors.NativeCollector;
import com.srcclr.sdk.Coords;
import com.srcclr.sdk.LibraryGraph;
import com.srcclr.sdk.LibraryGraphContainer;
import com.srcclr.sdk.LibraryGraphSerializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class JsonComponentGraphNativeCollector
implements NativeCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonComponentGraphNativeCollector.class);
    private static final String UNDEFINED_VALUE = "<undefined>";
    protected final LogStream logStream;
    private final String builderName;
    protected final ImmutableMap<String, Object> attributes;
    protected final Client client;
    final List<Path> filesToDelete = new ArrayList<Path>();
    CollectorData.Builder collectorDataBuilder = new CollectorData.Builder();

    JsonComponentGraphNativeCollector(LogStream logStream, String builderName, ImmutableMap<String, Object> attributes) {
        this.logStream = logStream;
        this.builderName = builderName;
        this.attributes = attributes;
        SourceClearClient.Builder builder = new SourceClearClient.Builder().withExpBackOffInitial(0);
        URI apiBase = (URI)attributes.get((Object)"API_BASE_URI");
        if (apiBase != null) {
            builder.withBaseURI(apiBase);
        }
        this.client = builder.build();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nonnull
    public LibraryGraphContainer collect(File projectRoot) throws CollectionException {
        LibraryGraphContainer libraryGraphContainer;
        Object object;
        this.collectorDataBuilder.setCollectorName(this.getName());
        File graphFile = this.createTmpGraphFile();
        Pair<String, Integer> outputAndRc = this.getGraphBuildingProcessOutputAndRc(projectRoot, graphFile, false);
        String output = (String)outputAndRc.getLeft();
        int rc = (Integer)outputAndRc.getRight();
        if (rc != 0 && this.hasFallbackBuildProcess()) {
            LOGGER.debug("Build process non-zero rc: {}. Output:\n{}", (Object)rc, (Object)output);
            LOGGER.debug("Collector has fallback build process. Trying fallback process.");
            graphFile = this.createTmpGraphFile();
            Pair<String, Integer> fallbackOutputAndRc = this.getGraphBuildingProcessOutputAndRc(projectRoot, graphFile, true);
            output = (String)fallbackOutputAndRc.getLeft();
            rc = (Integer)fallbackOutputAndRc.getRight();
        }
        try {
            Set graphs;
            if (rc != 0) {
                LOGGER.error("Encountered errors while collecting component information.");
                this.collectorDataBuilder.setBuildCommandSuccessful(false);
                this.handleNonZeroProcessExit(rc, projectRoot.getAbsolutePath(), output);
            }
            this.collectorDataBuilder.setBuildCommandSuccessful(true);
            this.afterGraphBuildingProcess(projectRoot, graphFile);
            try {
                FileInputStream is = new FileInputStream(graphFile);
                object = null;
                try {
                    graphs = LibraryGraphSerializer.read((InputStream)is).getGraphs();
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (is != null) {
                        if (object != null) {
                            try {
                                ((InputStream)is).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ((InputStream)is).close();
                        }
                    }
                }
            }
            catch (IOException ex) {
                throw new CollectionException(CollectionErrorType.IO, "Couldn't read generated graph file: " + ex.getMessage()).initCause(ex);
            }
            libraryGraphContainer = new LibraryGraphContainer.Builder().withGraphs(this.validateRoot(graphs)).build();
        }
        catch (CollectionException ex) {
            try {
                throw ex;
                catch (Exception ex2) {
                    throw new CollectionException(CollectionErrorType.UNKNOWN, ex2.getMessage());
                }
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly((File)graphFile);
                Iterator<Path> iterator = this.filesToDelete.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        throw throwable;
                    }
                    Path temporaryFile = iterator.next();
                    FileUtils.deleteQuietly((File)temporaryFile.toFile());
                }
            }
        }
        FileUtils.deleteQuietly((File)graphFile);
        object = this.filesToDelete.iterator();
        while (object.hasNext()) {
            Path temporaryFile = (Path)object.next();
            FileUtils.deleteQuietly((File)temporaryFile.toFile());
        }
        return libraryGraphContainer;
    }

    protected void afterGraphBuildingProcess(File projectRoot, File graphFile) throws IOException {
    }

    protected void handleNonZeroProcessExit(int exitCode, String projectRoot, String output) throws CollectionException {
        throw new CollectionException(CollectionErrorType.PACKAGE_MANAGER, "This project does not seem to build.\nBecause of this, SourceClear cannot scan it. Please ensure that the project compiles prior to scanning.", output);
    }

    @Override
    public boolean isMethodsSupported(File projectRoot) {
        try {
            FileTypeVisitor visitor = ClassFileVisitor.getVisitor();
            Files.walkFileTree(Paths.get(projectRoot.getCanonicalPath(), new String[0]), visitor);
            return !visitor.getFiles().isEmpty();
        }
        catch (Exception ex) {
            this.logStream.log("com.srcclr.evidence.info", Stage.EVIDENCE_COLLECTION, "Unable to determine vulnerable methods support, skipping.");
            LOGGER.error("Couldn't scan for class files.", (Throwable)ex);
            return false;
        }
    }

    @Override
    @Nonnull
    public CollectorData getCollectorData() {
        return this.collectorDataBuilder.build();
    }

    private Set<LibraryGraph> validateRoot(Set<LibraryGraph> graphs) {
        if (graphs.size() == 1) {
            LibraryGraph root = graphs.toArray(new LibraryGraph[1])[0];
            Coords coords = root.getCoords();
            String coord1 = coords.getCoordinate1();
            String coord2 = coords.getCoordinate2();
            String version = coords.getVersion();
            boolean isCoord1Missing = Strings.isNullOrEmpty((String)coord1);
            boolean isCoord2Missing = coords.getCoordinateType().getCoordinateCount() == 2 && Strings.isNullOrEmpty((String)coord2);
            boolean isVersionMissing = Strings.isNullOrEmpty((String)version);
            if (isCoord1Missing || isCoord2Missing || isVersionMissing) {
                LibraryGraph newRoot = new LibraryGraph.Builder().withBytecodeHash(root.getBytecodeHash()).withSha1(root.getSha1()).withSha2(root.getSha2()).withFilename(root.getFilename()).withLineNumber(root.getLineNumber()).withCoords(new Coords.Builder().withCoordinate1(isCoord1Missing ? UNDEFINED_VALUE : coord1).withCoordinate2(isCoord2Missing ? UNDEFINED_VALUE : coord2).withVersion(isVersionMissing ? UNDEFINED_VALUE : version).withCoordinateType(coords.getCoordinateType()).withScope(coords.getScope()).withPlatform(coords.getPlatform()).build()).withDirects(root.getDirects()).build();
                return new LinkedHashSet<LibraryGraph>(Arrays.asList(newRoot));
            }
        }
        return graphs;
    }

    private File createTmpGraphFile() throws CollectionException {
        try {
            return File.createTempFile("graph-", ".json");
        }
        catch (IOException ex) {
            throw new CollectionException(CollectionErrorType.IO, "Couldn't create a temporary graph file: " + ex.getMessage()).initCause(ex);
        }
    }

    private Pair<String, Integer> getGraphBuildingProcessOutputAndRc(File projectRoot, File graphFile, boolean useFallback) throws CollectionException {
        int result;
        Process process;
        try {
            process = this.makeGraphBuildingProcess(projectRoot, graphFile, useFallback);
        }
        catch (IOException ex) {
            throw new CollectionException(CollectionErrorType.IO, "Couldn't execute " + this.builderName + ": " + ex.getMessage()).initCause(ex);
        }
        String output = null;
        try {
            try {
                OutputStream ignored = process.getOutputStream();
                Throwable throwable = null;
                if (ignored != null) {
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        ignored.close();
                    }
                }
            }
            catch (IOException ex) {
                throw new CollectionException(CollectionErrorType.IO, "An error occurred while waiting for the build to finish: " + ex.getMessage());
            }
            Future<String> outputFuture = CollectorUtils.readAsync(process.getInputStream(), this.logStream, LOGGER, "com.srcclr.evidence.compilation", Stage.EVIDENCE_COLLECTION);
            CollectorUtils.readAsync(process.getErrorStream(), this.logStream, LOGGER, "com.srcclr.evidence.info", Stage.EVIDENCE_COLLECTION);
            result = process.waitFor();
            output = outputFuture.get();
        }
        catch (InterruptedException ex) {
            throw new CollectionException(CollectionErrorType.IO, "An error occurred while waiting for the build to finish: " + ex.getMessage(), output);
        }
        catch (Exception ex) {
            throw new CollectionException(CollectionErrorType.UNKNOWN, ex.getMessage());
        }
        return Pair.of((Object)output, (Object)result);
    }

    protected abstract Process makeGraphBuildingProcess(File var1, File var2, boolean var3) throws CollectionException, IOException;

    protected boolean hasFallbackBuildProcess() {
        return false;
    }
}

