/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.collectors;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.sourceclear.api.data.analytics.BuildCommandType;
import com.sourceclear.api.data.analytics.CollectorData;
import com.sourceclear.engine.common.FeatureFlag;
import com.sourceclear.engine.common.SOFileVisitor;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.common.logging.Stage;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.collectors.NativeCollector;
import com.sourceclear.engine.component.linuxso.SOFileAnalyzer;
import com.srcclr.sdk.LibraryGraph;
import com.srcclr.sdk.LibraryGraphContainer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOFileNativeCollector
implements NativeCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOFileNativeCollector.class);
    private final LogStream logStream;
    private final ImmutableMap<String, Object> attributes;
    private ImmutableSet<Path> soFilesInProject;

    public SOFileNativeCollector(LogStream logStream, ImmutableMap<String, Object> attributes) {
        this.logStream = logStream;
        this.attributes = attributes;
    }

    @Override
    public String getName() {
        return "SOFile";
    }

    @Override
    public boolean supports(File projectPath) {
        if (!FeatureFlag.featureIsOn(FeatureFlag.Flag.ENABLE_CPP, this.attributes)) {
            this.soFilesInProject = ImmutableSet.of();
            return false;
        }
        try {
            this.searchSOFilesInProject(projectPath);
            return !this.soFilesInProject.isEmpty();
        }
        catch (IOException ex) {
            this.logStream.log("com.srcclr.engineconfig.issue", Stage.ENGINE_CONFIGURATION, "Error while checking whether SOFileNativeCollector supports project: " + ex.getMessage());
            return false;
        }
    }

    @Override
    public Set<Pattern> patternsOfInterest() {
        return Sets.newHashSet((Object[])new Pattern[]{Pattern.compile(".+\\.so"), Pattern.compile(".+\\.so\\..+")});
    }

    @Override
    public boolean systemIsReady(File projectDir) {
        if (this.soFilesInProject == null) {
            try {
                this.searchSOFilesInProject(projectDir);
            }
            catch (IOException ex) {
                this.logStream.log("com.srcclr.engineconfig.issue", Stage.ENGINE_CONFIGURATION, "Unable to check whether system is ready in SOFileNativeCollector: " + ex.getMessage());
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isMethodsSupported(File projectRoot) {
        return false;
    }

    @Override
    @Nonnull
    public LibraryGraphContainer collect(File projectRoot) throws CollectionException {
        LibraryGraphContainer.Builder graphsBuilder = new LibraryGraphContainer.Builder();
        HashSet<LibraryGraph> libraryGraphs = new HashSet<LibraryGraph>();
        for (Path soFilePath : this.soFilesInProject) {
            String relativeFileName = projectRoot.toPath().relativize(soFilePath).toString();
            libraryGraphs.add(SOFileAnalyzer.analyze(soFilePath, relativeFileName));
        }
        graphsBuilder.withGraphs(libraryGraphs);
        return graphsBuilder.build();
    }

    @Override
    @Nonnull
    public CollectorData getCollectorData() {
        return new CollectorData.Builder().setCollectorName(this.getName()).setBuildCommandType(BuildCommandType.NOT_NEEDED).build();
    }

    private void searchSOFilesInProject(File projectPath) throws IOException {
        SOFileVisitor soFileVisitor = new SOFileVisitor(new HashSet<String>(), LOGGER);
        Files.walkFileTree(projectPath.toPath(), soFileVisitor);
        this.soFilesInProject = soFileVisitor.getFiles();
    }
}

