/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.composer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.composer.ComposerJson;
import com.sourceclear.engine.component.composer.ComposerLock;
import com.sourceclear.engine.component.composer.ComposerLockPackage;
import com.sourceclear.engine.component.composer.ComposerTreeNode;
import com.srcclr.sdk.CoordinateType;
import com.srcclr.sdk.Coords;
import com.srcclr.sdk.LibraryGraph;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class ComposerParser {
    public static final String NO_DEV = "--no-dev";
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ComposerJson parseComposerJsonFile(Path jsonFile) throws CollectionException {
        try (InputStream inputStream = Files.newInputStream(jsonFile, new OpenOption[0]);){
            ComposerJson composerJson = (ComposerJson)JSON_MAPPER.readValue(inputStream, ComposerJson.class);
            return composerJson;
        }
        catch (IOException e) {
            throw new CollectionException(CollectionErrorType.IO, String.format("Unable to parse %s. Error: %s", jsonFile, e.getMessage()), e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ComposerLock parseComposerLockFile(Path lockFile) throws CollectionException {
        try (InputStream inputStream = Files.newInputStream(lockFile, new OpenOption[0]);){
            ComposerLock composerLock = (ComposerLock)JSON_MAPPER.readValue(inputStream, ComposerLock.class);
            return composerLock;
        }
        catch (IOException e) {
            throw new CollectionException(CollectionErrorType.IO, String.format("Unable to parse %s. Error: %s", lockFile, e.getMessage()), e.getMessage());
        }
    }

    public static ComposerTreeNode parseComposerTree(List<String> tree) throws CollectionException {
        ComposerTreeNode rootComposerTreeNode = new ComposerTreeNode(".");
        HashMap<Integer, ComposerTreeNode> lastPackageAtIndent = new HashMap<Integer, ComposerTreeNode>();
        lastPackageAtIndent.put(-1, rootComposerTreeNode);
        int previousIndent = -1;
        for (String currentLine : tree) {
            if (!StringUtils.isNotBlank((String)currentLine)) continue;
            Optional<String> packageName = ComposerParser.getPackageName(currentLine);
            if (!packageName.isPresent()) {
                throw new CollectionException(CollectionErrorType.PACKAGE_MANAGER, "Unable to get package name from composer tree output line: " + currentLine);
            }
            ComposerTreeNode currentPackage = new ComposerTreeNode((String)packageName.get());
            int currentIndent = ComposerParser.getIndent(currentLine);
            if (currentIndent > previousIndent) {
                ((ComposerTreeNode)lastPackageAtIndent.get(previousIndent)).addChild(currentPackage);
            } else {
                ((ComposerTreeNode)lastPackageAtIndent.get(currentIndent - 1)).addChild(currentPackage);
            }
            lastPackageAtIndent.put(currentIndent, currentPackage);
            previousIndent = currentIndent;
        }
        return rootComposerTreeNode;
    }

    public static Map<String, Coords> composerLockPackagesToCoords(boolean noDev, ComposerLock composerLock) {
        HashMap<String, Coords> coordsMap = new HashMap<String, Coords>();
        List<ComposerLockPackage> composerLockPackages = noDev ? composerLock.getProdPackages() : composerLock.getAllPackages();
        for (ComposerLockPackage composerLockPackage : composerLockPackages) {
            coordsMap.put(composerLockPackage.getName(), ComposerParser.composerLockPackageToCoords(composerLockPackage));
        }
        return coordsMap;
    }

    public static Map<String, ComposerLockPackage> composerLockPackagesToMap(boolean noDev, ComposerLock composerLock) {
        HashMap<String, ComposerLockPackage> map = new HashMap<String, ComposerLockPackage>();
        List<ComposerLockPackage> composerLockPackages = noDev ? composerLock.getProdPackages() : composerLock.getAllPackages();
        for (ComposerLockPackage composerLockPackage : composerLockPackages) {
            map.put(composerLockPackage.getName(), composerLockPackage);
        }
        return map;
    }

    public static Set<LibraryGraph> coordsToDirects(String filename, Collection<Coords> coordsCollection) {
        HashSet<LibraryGraph> projectDirects = new HashSet<LibraryGraph>();
        for (Coords coords : coordsCollection) {
            projectDirects.add(new LibraryGraph.Builder().withCoords(coords).withFilename(filename).build());
        }
        return projectDirects;
    }

    public static Set<LibraryGraph> composerPackagesToGraphs(boolean noDev, String filename, Set<String> directs, Map<String, Coords> coordsMap, Map<String, ComposerLockPackage> packagesMap, Set<String> seen) {
        HashSet<LibraryGraph> projectDirects = new HashSet<LibraryGraph>();
        for (String packageName : directs) {
            if (seen.contains(packageName) || !packagesMap.containsKey(packageName)) continue;
            ComposerLockPackage composerLockPackage = packagesMap.get(packageName);
            Coords packageCoords = coordsMap.containsKey(packageName) ? coordsMap.get(packageName) : ComposerParser.composerLockPackageToCoords(composerLockPackage);
            HashSet<String> transitiveNames = new HashSet<String>();
            transitiveNames.addAll((Collection<String>)composerLockPackage.getRequires().keySet());
            if (!noDev) {
                transitiveNames.addAll((Collection<String>)composerLockPackage.getRequireDevs().keySet());
            }
            seen.add(packageName);
            projectDirects.add(new LibraryGraph.Builder().withCoords(packageCoords).withDirects(ComposerParser.composerPackagesToGraphs(noDev, filename, transitiveNames, coordsMap, packagesMap, seen)).withFilename(filename).build());
            seen.remove(packageName);
        }
        return projectDirects;
    }

    private static Coords composerLockPackageToCoords(ComposerLockPackage composerLockPackage) {
        return new Coords.Builder().withCoordinateType(CoordinateType.PACKAGIST).withCoordinate1(composerLockPackage.getName()).withVersion(composerLockPackage.getVersion()).withScope(composerLockPackage.getScope()).build();
    }

    static Optional<String> getPackageName(String line) {
        Pattern pattern = Pattern.compile("[|\\-\\`\\s]*([a-zA-Z_0-9-/]+)\\s");
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            return Optional.of((Object)matcher.group(1));
        }
        return Optional.absent();
    }

    static int getIndent(String line) {
        char c;
        int indentChars = 0;
        for (int i = 0; i < line.length() && !Character.isLetterOrDigit(c = line.charAt(i)); ++i) {
            ++indentChars;
        }
        return indentChars / 3;
    }
}

