/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.gem;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.sourceclear.api.data.evidence.Coordinates;
import java.util.Collection;
import java.util.LinkedHashSet;

public class GemSpec {
    private final Coordinates coordinates;
    private final ImmutableSet<Coordinates> transitives;
    private final Integer lineNumber;

    private GemSpec(Builder builder) {
        this.coordinates = builder.coordinates;
        this.transitives = ImmutableSet.copyOf((Collection)builder.transitives);
        this.lineNumber = builder.lineNumber;
    }

    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    public ImmutableSet<Coordinates> getTransitives() {
        return this.transitives;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public String toString() {
        return "GemSpec{coordinates=" + this.coordinates + ", transitives=" + this.transitives + ", lineNumber=" + this.lineNumber + '}';
    }

    public static class Builder {
        private Coordinates coordinates;
        private Integer lineNumber;
        private LinkedHashSet<Coordinates> transitives = Sets.newLinkedHashSet();

        public Builder withCoordinates(Coordinates coordinates) {
            this.coordinates = coordinates;
            return this;
        }

        public Builder withLineNumber(Integer lineNumber) {
            this.lineNumber = lineNumber;
            return this;
        }

        public Builder withTransitive(Coordinates coordinates) {
            this.transitives.add(coordinates);
            return this;
        }

        public GemSpec build() {
            return new GemSpec(this);
        }
    }
}

