/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.gem;

import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.gem.GemfileDotLock;
import com.sourceclear.engine.component.gem.GemfileDotLockParser;
import com.srcclr.sdk.LibraryGraph;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GemfileDotLockToGraph {
    public static final String GEMFILE_LOCK = "Gemfile.lock";
    private static final Logger LOGGER = LoggerFactory.getLogger(GemfileDotLockToGraph.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LibraryGraph convert(Path lockFile) throws CollectionException {
        String lockFileContents = null;
        try (InputStream fin = Files.newInputStream(lockFile, new OpenOption[0]);){
            lockFileContents = IOUtils.toString((InputStream)fin, (Charset)Charset.defaultCharset());
            LOGGER.debug("Found {}, using it for evidence collection", (Object)lockFile.toString());
            GemfileDotLockParser parser = new GemfileDotLockParser(lockFileContents);
            parser.parse();
            GemfileDotLock dotLock = parser.getLockFile();
            LibraryGraph libraryGraph = dotLock.graph();
            return libraryGraph;
        }
        catch (Exception ex) {
            throw new CollectionException(CollectionErrorType.PACKAGE_MANAGER, "An error occurred while parsing Gemfile.lock: " + ex.getMessage() + "\nBecause of this, SourceClear cannot continue scanning the project.\nPlease ensure that the error is resolved before scanning.", lockFileContents).initCause(ex);
        }
    }
}

