/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.gem;

import com.sourceclear.engine.component.gem.Gem;
import java.util.ArrayList;
import java.util.List;
import org.jrubyparser.ast.ArrayNode;
import org.jrubyparser.ast.FCallNode;
import org.jrubyparser.ast.FalseNode;
import org.jrubyparser.ast.HashNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.StrNode;
import org.jrubyparser.ast.SymbolNode;
import org.jrubyparser.ast.TrueNode;
import org.jrubyparser.ast.visitor.AbstractNodeVisitor;
import org.jrubyparser.util.KeyValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GemfileVisitor
extends AbstractNodeVisitor<Expr> {
    private Gem.GemBuilder gemBuilder;
    private List<String> currentGroups = new ArrayList<String>();
    private List<Gem> gems = new ArrayList<Gem>();
    private static final Logger LOGGER = LoggerFactory.getLogger(GemfileVisitor.class);

    GemfileVisitor() {
    }

    @Override
    protected Expr defaultVisit(Node node) {
        for (Node n : node.childNodes()) {
            this.visitNode(n);
        }
        return null;
    }

    @Override
    public ArrayExpr visitArrayNode(ArrayNode arrayNode) {
        ArrayList<Expr> result = new ArrayList<Expr>();
        for (Node node : arrayNode.children()) {
            Expr value;
            if (node == null || !((value = this.visitNode(node)) instanceof Str) && !(value instanceof Symbol)) continue;
            result.add(value);
        }
        return new ArrayExpr(result);
    }

    @Override
    public Expr visitFCallNode(FCallNode fCallNode) {
        if (fCallNode.getArgsNode().getNodeType().equals((Object)NodeType.ARRAYNODE)) {
            if (fCallNode.getName().equals("gem")) {
                Expr secondArg;
                Expr firstArg;
                this.gemBuilder = new Gem.GemBuilder();
                ArrayExpr gemArgs = this.visitArrayNode((ArrayNode)fCallNode.getArgsNode());
                for (String group : this.currentGroups) {
                    this.gemBuilder.withGroup(group);
                }
                List elements = gemArgs.elements;
                int argsCount = elements.size();
                if (argsCount > 0 && (firstArg = (Expr)elements.get(0)) instanceof Str) {
                    this.gemBuilder.withName(((Str)firstArg).value);
                }
                if (argsCount > 1 && (secondArg = (Expr)elements.get(1)) instanceof Str) {
                    this.gemBuilder.withVersion(((Str)secondArg).value);
                }
                Gem gem = this.gemBuilder.build();
                LOGGER.trace("Found gem: {}", (Object)gem);
                this.gems.add(gem);
                this.gemBuilder = null;
            } else if (fCallNode.getName().equals("group")) {
                ArrayExpr gemArgs = this.visitArrayNode((ArrayNode)fCallNode.getArgsNode());
                for (Expr element : gemArgs.elements) {
                    if (!(element instanceof StringLike)) continue;
                    String value = ((StringLike)element).getValue();
                    this.currentGroups.add(value);
                }
                this.visitFunctionCallBlock(fCallNode);
                this.currentGroups = new ArrayList<String>();
            } else {
                this.visitFunctionCallBlock(fCallNode);
            }
        } else {
            this.visitFunctionCallBlock(fCallNode);
        }
        return null;
    }

    private void visitFunctionCallBlock(FCallNode fCallNode) {
        if (fCallNode.getIterNode() != null) {
            this.defaultVisit(fCallNode.getIterNode());
        }
    }

    @Override
    public Expr visitHashNode(HashNode hashNode) {
        if (this.gemBuilder != null) {
            List<KeyValuePair<Node, Node>> pairs = hashNode.getPairs();
            block12: for (KeyValuePair<Node, Node> pair : pairs) {
                Expr key = this.visitNode(pair.getKey());
                Expr val = this.visitNode(pair.getValue());
                if (key == null || val == null || !(key instanceof StringLike)) continue;
                switch (((StringLike)key).getValue()) {
                    case "group": {
                        if (val instanceof StringLike) {
                            String group = ((StringLike)val).getValue();
                            this.gemBuilder.withGroup(group);
                            break;
                        }
                        if (!(val instanceof ArrayExpr)) break;
                        for (String group : ((ArrayExpr)val).getValuesIfLiteral()) {
                            this.gemBuilder.withGroup(group);
                        }
                        continue block12;
                    }
                    case "platforms": {
                        if (!(val instanceof ArrayExpr)) break;
                        for (String platform : ((ArrayExpr)val).getValuesIfLiteral()) {
                            this.gemBuilder.withPlatform(platform);
                        }
                        continue block12;
                    }
                    case "path": {
                        if (!(val instanceof StringLike)) break;
                        this.gemBuilder.withPath(((StringLike)val).getValue());
                        break;
                    }
                    case "require": {
                        if (val instanceof StringLike) {
                            this.gemBuilder.withRequireAs(((StringLike)val).getValue());
                            break;
                        }
                        if (!(val instanceof Bool)) break;
                        this.gemBuilder.withRequire(((Bool)val).getValue());
                    }
                }
            }
        }
        return null;
    }

    @Override
    public Expr visitStrNode(StrNode strNode) {
        return new Str(strNode.getValue().toString());
    }

    @Override
    public Expr visitSymbolNode(SymbolNode symbolNode) {
        return new Symbol(symbolNode.getName());
    }

    @Override
    public Expr visitTrueNode(TrueNode node) {
        return new Bool(true);
    }

    @Override
    public Expr visitFalseNode(FalseNode node) {
        return new Bool(false);
    }

    public List<Gem> getGems() {
        return this.gems;
    }

    private Expr visitNode(Node node) {
        if (node != null) {
            return node.accept(this);
        }
        return null;
    }

    private class ArrayExpr
    extends Expr {
        private final List<Expr> elements;

        ArrayExpr(List<Expr> elements) {
            this.elements = elements;
        }

        List<String> getValuesIfLiteral() {
            ArrayList<String> result = new ArrayList<String>();
            for (Expr element : this.elements) {
                if (!(element instanceof StringLike)) continue;
                result.add(((StringLike)element).getValue());
            }
            return result;
        }
    }

    private class Symbol
    extends StringLike {
        private final String value;

        Symbol(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    private class Str
    extends StringLike {
        private final String value;

        Str(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    private class Bool
    extends Expr {
        private final boolean value;

        private Bool(boolean value) {
            this.value = value;
        }

        boolean getValue() {
            return this.value;
        }
    }

    abstract class StringLike
    extends Expr {
        StringLike() {
        }

        abstract String getValue();
    }

    static class Expr {
        Expr() {
        }
    }
}

