/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.gem;

import com.google.common.collect.ImmutableList;
import com.sourceclear.engine.component.gem.GemSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Source {
    private final String remote;
    private final ImmutableList<GemSpec> gems;

    Source(Builder builder) {
        this.remote = builder.remote;
        this.gems = ImmutableList.copyOf((Collection)builder.gems);
    }

    public String getRemote() {
        return this.remote;
    }

    public ImmutableList<GemSpec> getGems() {
        return this.gems;
    }

    static class Builder {
        private String remote;
        private List<GemSpec> gems = new ArrayList<GemSpec>();

        Builder() {
        }

        public Builder withRemote(String remote) {
            this.remote = remote;
            return this;
        }

        public Builder withGem(GemSpec gem) {
            this.gems.add(gem);
            return this;
        }

        public Source build() {
            return new Source(this);
        }
    }
}

