/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.golang;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.sourceclear.engine.component.golang.GoPackage;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.commons.lang.StringUtils;

public abstract class CommonDeserializer
extends JsonDeserializer<GoPackage> {
    protected abstract String getNameField();

    protected abstract String getVersionField();

    protected abstract String getRepoField();

    protected abstract String getDeserializerName();

    protected boolean isVersionFieldCompulsory() {
        return true;
    }

    public GoPackage deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        String nameField = this.getNameField();
        String versionField = this.getVersionField();
        String repoField = this.getRepoField();
        String deserializerName = this.getDeserializerName();
        boolean versionFieldIsCompulsory = this.isVersionFieldCompulsory();
        int lineNumber = jsonParser.getTokenLocation().getLineNr();
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        if (node.isObject()) {
            String importPath = node.path(nameField).textValue();
            String version = node.path(versionField) != null ? node.path(versionField).textValue() : "";
            String repo = StringUtils.isNotBlank((String)repoField) ? node.path(repoField).textValue() : null;
            CommonDeserializer.checkNotBlankOrThrow(importPath, nameField, lineNumber, deserializerName);
            if (versionFieldIsCompulsory) {
                CommonDeserializer.checkNotBlankOrThrow(version, versionField, lineNumber, deserializerName);
            }
            try {
                return new GoPackage(importPath, version, lineNumber, repo);
            }
            catch (URISyntaxException ex) {
                throw new IOException("URISyntaxException occurred. Ex message: " + ex.getMessage(), ex);
            }
        }
        throw new IOException("Error in " + deserializerName + ". Unexpected nodeType: " + node.getNodeType() + " at line " + lineNumber);
    }

    private static void checkNotBlankOrThrow(String str, String fieldName, int lineNumber, String deserializerName) throws IOException {
        if (StringUtils.isBlank((String)str)) {
            throw new IOException("Error in " + deserializerName + ". Missing expected property '" + fieldName + "' from lock file at node ending at line " + lineNumber);
        }
    }
}

