/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.golang;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.sourceclear.engine.component.golang.GoPackage;
import com.sourceclear.engine.component.golang.TrashVendorConfDeserializer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TrashVendorConf {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrashVendorConf.class);
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static final SimpleModule SIMPLE_MODULE = new SimpleModule("SimpleModule", new Version(1, 0, 0, null, null, null)).addDeserializer(GoPackage.class, (JsonDeserializer)new TrashVendorConfDeserializer());
    private String packageName = "";
    @JsonProperty(value="import")
    private List<GoPackage> imports = new ArrayList<GoPackage>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TrashVendorConf parse(File trashFile) throws IOException, URISyntaxException {
        YAML_MAPPER.registerModule((Module)SIMPLE_MODULE);
        try (InputStream inputStream = Files.newInputStream(trashFile.toPath(), new OpenOption[0]);){
            TrashVendorConf throwable3 = (TrashVendorConf)YAML_MAPPER.readValue(inputStream, TrashVendorConf.class);
            return throwable3;
        }
        catch (IOException e) {
            LOGGER.debug("Trash's config file is not Yaml format. Error: {}", (Object)e.getMessage());
            try (InputStream inputStream2 = Files.newInputStream(trashFile.toPath(), new OpenOption[0]);){
                LOGGER.debug("Trying line format.");
                TrashVendorConf trashVendorConf2 = new TrashVendorConf();
                trashVendorConf2.setImports(trashVendorConf2.parseLines(inputStream2));
                TrashVendorConf trashVendorConf = trashVendorConf2;
                return trashVendorConf;
            }
            catch (IOException | URISyntaxException e2) {
                LOGGER.debug("Error parsing file based on lines format: {}", (Object)e2.getMessage());
                throw e2;
            }
        }
    }

    private List<GoPackage> parseLines(InputStream inputStream) throws IOException, URISyntaxException {
        String inputString = IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
        String[] lines = inputString.split("\\n");
        ArrayList<GoPackage> results = new ArrayList<GoPackage>(lines.length);
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (StringUtils.isBlank((String)line) || line.trim().startsWith("#")) continue;
            String[] tokens = TrashVendorConf.stripComments(line);
            LOGGER.debug("comments removed from tokens.");
            if (tokens.length == 1 && results.isEmpty()) {
                this.packageName = tokens[0];
                LOGGER.debug("Encountered line with only one token. packageName set to the value: {}", (Object)this.packageName);
                continue;
            }
            String name = tokens[0];
            String version = tokens[1];
            String repo = tokens.length > 2 ? tokens[2] : null;
            results.add(new GoPackage(name, version, i + 1, repo));
        }
        return results;
    }

    static String[] stripComments(@Nonnull String line) {
        int indexOfCommentStart = line.indexOf(" #");
        return indexOfCommentStart < 0 ? line.split("\\s+") : line.substring(0, indexOfCommentStart).split("\\s+");
    }

    private void setImports(List<GoPackage> imports) {
        this.imports = imports;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public List<GoPackage> getImports() {
        return this.imports;
    }
}

