/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.linecount;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.sourceclear.analysis.dotnet.Executable;
import com.sourceclear.api.client.Client;
import com.sourceclear.engine.common.FileTypeVisitor;
import com.sourceclear.engine.component.collectors.MSBuildDotNetNativeCollector;
import com.sourceclear.engine.component.linecount.Counter;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DotNetDLLCounter
implements Counter {
    private static final Set<String> EXTENSIONS = Sets.newHashSet((Object[])new String[]{".dll"});
    private static final Set<String> IGNORED_DIRECTORIES = Sets.newHashSet((Object[])new String[]{"obj", "packages"});
    private static final Logger LOGGER = LoggerFactory.getLogger(DotNetDLLCounter.class);
    private final Client client;
    private ImmutableSet<Path> dllsFound;
    private Executable executable;

    public DotNetDLLCounter(Client client) {
        this.client = client;
    }

    @Override
    public boolean shouldCount(File projectRoot) throws IOException {
        ProjectDLLVisitor projectDLLVisitor = new ProjectDLLVisitor(EXTENSIONS, IGNORED_DIRECTORIES, LOGGER);
        Files.walkFileTree(projectRoot.toPath(), projectDLLVisitor);
        this.dllsFound = projectDLLVisitor.getFiles();
        LOGGER.debug("project DLLs found: {}", this.dllsFound);
        return !this.dllsFound.isEmpty();
    }

    @Override
    @Nonnull
    public String getName() {
        return "DotNetDLLCounter";
    }

    @Override
    public long count(File projectRoot) throws IOException {
        this.executable = new Executable(this.client);
        Map<Path, Set<Path>> projectFolderToDLLs = this.organiseDLLsByProject(projectRoot);
        LOGGER.debug("projectFolderToDLLs: {}", projectFolderToDLLs);
        return projectFolderToDLLs.values().stream().mapToLong(this::averageLineCount).sum();
    }

    @VisibleForTesting
    Map<Path, Set<Path>> organiseDLLsByProject(File projectRoot) throws IOException {
        FileTypeVisitor fileTypeVisitor = new FileTypeVisitor((Set<String>)MSBuildDotNetNativeCollector.PROJECT_EXTENSIONS, (Set<String>)new HashSet<String>(), LOGGER);
        Files.walkFileTree(projectRoot.toPath(), fileTypeVisitor);
        Set parentFolders = fileTypeVisitor.getFiles().stream().map(Path::getParent).collect(Collectors.toSet());
        return this.dllsFound.stream().map(dll -> parentFolders.stream().filter(dll::startsWith).findFirst().map(parent -> new AbstractMap.SimpleEntry<Path, Path>((Path)parent, (Path)dll)).orElse(new AbstractMap.SimpleEntry<Path, Path>((Path)dll, (Path)dll))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toSet())));
    }

    @VisibleForTesting
    long averageLineCount(Set<Path> dlls) {
        double avg = dlls.stream().mapToLong(this::countDLL).average().orElse(0.0);
        return Math.round(avg);
    }

    @VisibleForTesting
    long countDLL(Path dll) {
        try {
            return this.executable.countInstructions(dll);
        }
        catch (Exception ex) {
            LOGGER.debug("Exception occurred while attempting to count instructions for {}. Returning 0 as line count. ", (Object)dll, (Object)ex);
            return 0L;
        }
    }

    private static class ProjectDLLVisitor
    extends FileTypeVisitor {
        ProjectDLLVisitor(Set<String> extensions, Set<String> ignoredDirectories, Logger logger) {
            super(extensions, ignoredDirectories, logger);
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            for (String extension : this.extensions) {
                if (!file.getFileName().toString().endsWith(extension) || !ProjectDLLVisitor.withinBinDir(file)) continue;
                this.files.add(file);
            }
            return FileVisitResult.CONTINUE;
        }

        private static boolean withinBinDir(Path file) {
            for (Path part : file) {
                if (!part.toString().equalsIgnoreCase("bin")) continue;
                return true;
            }
            return false;
        }
    }
}

