/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.natives.parsing;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class NPMPackage {
    private final String name;
    private final String versionDeclared;
    private final Integer lineNumber;

    public NPMPackage(String name, String versionDeclared) {
        this.name = name;
        this.versionDeclared = versionDeclared;
        this.lineNumber = null;
    }

    public NPMPackage(String name, String versionDeclared, int lineNumber) {
        this.name = name;
        this.versionDeclared = versionDeclared;
        this.lineNumber = lineNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NPMPackage that = (NPMPackage)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.versionDeclared, that.versionDeclared) && Objects.equals(this.lineNumber, that.lineNumber);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.versionDeclared, this.lineNumber);
    }

    public String toString() {
        return "NPMPackage{name='" + this.name + '\'' + ", versionDeclared='" + this.versionDeclared + '\'' + ", lineNumber=" + this.lineNumber + '}';
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getVersionDeclared() {
        return this.versionDeclared;
    }

    public Optional<Integer> getLineNumber() {
        return Optional.ofNullable(this.lineNumber);
    }
}

