/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.natives.parsing;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.annotations.VisibleForTesting;
import com.sourceclear.engine.component.natives.parsing.NPMPackage;
import com.sourceclear.engine.component.natives.parsing.NPMPackageListDeserializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PackageDotJson {
    @JsonProperty
    private String name;
    @JsonProperty
    private String version;
    @JsonProperty
    @JsonDeserialize(using=NPMPackageListDeserializer.class)
    private List<NPMPackage> dependencies = new ArrayList<NPMPackage>();
    @JsonProperty
    @JsonDeserialize(using=NPMPackageListDeserializer.class)
    private List<NPMPackage> devDependencies = new ArrayList<NPMPackage>();
    @JsonProperty
    @JsonDeserialize(using=NPMPackageListDeserializer.class)
    private List<NPMPackage> optionalDependencies = new ArrayList<NPMPackage>();
    @JsonProperty
    @JsonDeserialize(using=NPMPackageListDeserializer.class)
    private List<NPMPackage> peerDependencies = new ArrayList<NPMPackage>();

    PackageDotJson() {
    }

    @VisibleForTesting
    PackageDotJson(String name, String version, List<NPMPackage> dependencies, List<NPMPackage> devDependencies, List<NPMPackage> optionalDependencies, List<NPMPackage> peerDependencies) {
        this.name = name;
        this.version = version;
        this.dependencies = dependencies;
        this.devDependencies = devDependencies;
        this.optionalDependencies = optionalDependencies;
        this.peerDependencies = peerDependencies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageDotJson that = (PackageDotJson)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.version, that.version) && Objects.equals(this.dependencies, that.dependencies) && Objects.equals(this.devDependencies, that.devDependencies) && Objects.equals(this.optionalDependencies, that.optionalDependencies) && Objects.equals(this.peerDependencies, that.peerDependencies);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.dependencies, this.devDependencies, this.optionalDependencies, this.peerDependencies);
    }

    public String toString() {
        return "PackageDotJson{name='" + this.name + '\'' + ", version='" + this.version + '\'' + ", dependencies=" + this.dependencies + ", devDependencies=" + this.devDependencies + ", optionalDependencies=" + this.optionalDependencies + ", peerDependencies=" + this.peerDependencies + '}';
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    public List<NPMPackage> getDependencies() {
        return this.dependencies;
    }

    public List<NPMPackage> getDevDependencies() {
        return this.devDependencies;
    }

    public List<NPMPackage> getOptionalDependencies() {
        return this.optionalDependencies;
    }

    public List<NPMPackage> getPeerDependencies() {
        return this.peerDependencies;
    }
}

