/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.quickscancollectors;

import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.golang.GoPackage;
import com.sourceclear.engine.component.golang.GodepJson;
import com.sourceclear.engine.component.quickscancollectors.GoQuickscanCollector;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import javax.annotation.Nonnull;

public class GodepQuickscanCollector
extends GoQuickscanCollector {
    @Override
    @Nonnull
    public String getName() {
        return "Godeps quickscan";
    }

    @Override
    @Nonnull
    String lockDir() {
        return "Godeps";
    }

    @Override
    @Nonnull
    String lockFile() {
        return "Godeps.json";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nonnull
    List<GoPackage> dependencies(Path lockfile) throws CollectionException {
        try (InputStream inputStream = Files.newInputStream(lockfile, new OpenOption[0]);){
            List<GoPackage> list = GodepJson.parse(inputStream).getImports();
            return list;
        }
        catch (IOException e) {
            throw new CollectionException(CollectionErrorType.IO, e.getMessage()).initCause(e);
        }
    }
}

