/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.quickscancollectors;

import com.google.common.collect.ImmutableMap;
import com.sourceclear.api.data.analytics.BuildCommandType;
import com.sourceclear.api.data.analytics.CollectorData;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.common.logging.Stage;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.JarUtils;
import com.sourceclear.engine.component.quickscancollectors.QuickscanCollector;
import com.srcclr.sdk.LibraryGraphContainer;
import java.io.File;
import java.util.HashSet;
import javax.annotation.Nonnull;

public class JarQuickscanCollector
implements QuickscanCollector {
    private final LogStream logStream;

    public JarQuickscanCollector(LogStream logStream) {
        this.logStream = logStream;
    }

    @Override
    @Nonnull
    public String getName() {
        return "Jar Quickscan";
    }

    @Override
    @Nonnull
    public LibraryGraphContainer collect(File scanTarget, ImmutableMap<String, Object> attributes) throws CollectionException {
        if (scanTarget.isFile()) {
            LibraryGraphContainer.Builder builder = new LibraryGraphContainer.Builder();
            builder.withGraphs(JarUtils.JarAnalyzer.analyze(scanTarget, scanTarget.getName()));
            return builder.build();
        }
        return JarUtils.collect(scanTarget, new HashSet<String>(), this.logStream);
    }

    @Override
    public boolean supports(File file) {
        try {
            return file.isFile() && file.getName().endsWith(".jar") || file.isDirectory() && JarUtils.containsJarFile(file, new HashSet<String>());
        }
        catch (CollectionException ex) {
            this.logStream.log("com.srcclr.evidence.issue", Stage.ENGINE_CONFIGURATION, "Couldn't scan for jar files: " + ex.getMessage());
            return false;
        }
    }

    @Override
    @Nonnull
    public CollectorData getCollectorData() {
        return new CollectorData.Builder().setCollectorName(this.getName()).setBuildCommandType(BuildCommandType.NOT_NEEDED).build();
    }
}

