/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.yarn;

import com.sourceclear.engine.component.natives.parsing.NPMPackage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class YarnPackage {
    private static final String FULL_DECLARATION_DELIMITER = "@";
    private static final Pattern SCOPED_NAME_PATTERN = Pattern.compile("(@.*/.*)@.*");
    private static final Pattern NONSCOPED_NAME_PATTERN = Pattern.compile("(.*)@.*");
    private String declaration;
    private String version;
    private String resolved;
    private List<NPMPackage> dependencies;
    private List<NPMPackage> optionalDependencies;
    private List<NPMPackage> peerDependencies;
    private List<NPMPackage> devDependencies;

    public static String getFullDeclaration(@Nonnull String packageName, @Nonnull String versionDeclaration) {
        return packageName + FULL_DECLARATION_DELIMITER + versionDeclaration;
    }

    public static String getPackageNameFromFullDeclaration(@Nonnull String fullDeclaration) {
        if (!fullDeclaration.contains(FULL_DECLARATION_DELIMITER)) {
            return fullDeclaration;
        }
        Matcher matchScopedName = SCOPED_NAME_PATTERN.matcher(fullDeclaration);
        Matcher matchNonScopedName = NONSCOPED_NAME_PATTERN.matcher(fullDeclaration);
        if (matchScopedName.find()) {
            return matchScopedName.group(1);
        }
        if (matchNonScopedName.find()) {
            return matchNonScopedName.group(1);
        }
        throw new IllegalArgumentException("Unexpected declaration format: '" + fullDeclaration + "'.");
    }

    private YarnPackage(Builder builder) {
        this.declaration = builder.declaration;
        this.version = builder.version;
        this.resolved = builder.resolved;
        this.dependencies = builder.dependencies;
        this.optionalDependencies = builder.optionalDependencies;
        this.peerDependencies = builder.peerDependencies;
        this.devDependencies = builder.devDependencies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        YarnPackage yarnPackage = (YarnPackage)o;
        return Objects.equals(this.declaration, yarnPackage.getDeclaration()) && Objects.equals(this.version, yarnPackage.getVersion()) && Objects.equals(this.resolved, yarnPackage.getResolved()) && Objects.equals(this.dependencies, yarnPackage.getDependencies()) && Objects.equals(this.optionalDependencies, yarnPackage.getOptionalDependencies()) && Objects.equals(this.peerDependencies, yarnPackage.getPeerDependencies()) && Objects.equals(this.devDependencies, yarnPackage.getDevDependencies());
    }

    public int hashCode() {
        return Objects.hash(this.declaration, this.version, this.resolved, this.dependencies, this.optionalDependencies, this.peerDependencies, this.devDependencies);
    }

    public String toString() {
        return "YarnPackage{declaration='" + this.declaration + "', version='" + this.version + "', resolved='" + this.resolved + "', no. of deps='" + this.dependencies.size() + "', no. of optDeps='" + this.optionalDependencies.size() + "', no. of peerDeps='" + this.peerDependencies.size() + "', no. of devDeps='" + this.devDependencies.size() + "}";
    }

    public String getDeclaration() {
        return this.declaration;
    }

    public String getVersion() {
        return this.version;
    }

    public String getResolved() {
        return this.resolved;
    }

    public List<NPMPackage> getDependencies() {
        return this.dependencies;
    }

    public List<NPMPackage> getOptionalDependencies() {
        return this.optionalDependencies;
    }

    public List<NPMPackage> getPeerDependencies() {
        return this.peerDependencies;
    }

    public List<NPMPackage> getDevDependencies() {
        return this.devDependencies;
    }

    public static class Builder {
        private String declaration;
        private String version;
        private String resolved;
        private List<NPMPackage> dependencies = new ArrayList<NPMPackage>();
        private List<NPMPackage> optionalDependencies = new ArrayList<NPMPackage>();
        private List<NPMPackage> peerDependencies = new ArrayList<NPMPackage>();
        private List<NPMPackage> devDependencies = new ArrayList<NPMPackage>();

        public Builder withDeclaration(String declaration) {
            this.declaration = declaration;
            return this;
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withResolved(String resolved) {
            this.resolved = resolved;
            return this;
        }

        public Builder withDependencies(List<NPMPackage> dependencies) {
            if (dependencies != null) {
                this.dependencies = dependencies;
            }
            return this;
        }

        public Builder withDependency(String name, String version) {
            this.dependencies.add(new NPMPackage(name, version));
            return this;
        }

        public Builder withOptionalDependencies(List<NPMPackage> optionalDependencies) {
            if (optionalDependencies != null) {
                this.optionalDependencies = optionalDependencies;
            }
            return this;
        }

        public Builder withOptionalDependency(String name, String version) {
            this.optionalDependencies.add(new NPMPackage(name, version));
            return this;
        }

        public Builder withPeerDependencies(List<NPMPackage> peerDependencies) {
            if (peerDependencies != null) {
                this.peerDependencies = peerDependencies;
            }
            return this;
        }

        public Builder withPeerDependency(String name, String version) {
            this.peerDependencies.add(new NPMPackage(name, version));
            return this;
        }

        public Builder withDevDependencies(List<NPMPackage> devDependencies) {
            if (devDependencies != null) {
                this.devDependencies = devDependencies;
            }
            return this;
        }

        public Builder withDevDependency(String name, String version) {
            this.devDependencies.add(new NPMPackage(name, version));
            return this;
        }

        public YarnPackage build() {
            return new YarnPackage(this);
        }
    }
}

