/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.scan;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.sourceclear.api.client.Client;
import com.sourceclear.api.client.SourceClearClient;
import com.sourceclear.api.data.PlanType;
import com.sourceclear.api.data.analytics.AgentRuntimeData;
import com.sourceclear.api.data.evidence.CoordinateType;
import com.sourceclear.api.data.evidence.Coordinates;
import com.sourceclear.api.data.evidence.Evidence;
import com.sourceclear.api.data.evidence.EvidenceType;
import com.sourceclear.api.data.evidence.LanguageType;
import com.sourceclear.api.data.git.MetaGit;
import com.sourceclear.api.data.match.MatchQuery;
import com.sourceclear.api.data.match.MatchResponse;
import com.sourceclear.api.data.match.ScanFinishUploadResponse;
import com.sourceclear.api.data.methods.InstanceVulnMethod;
import com.sourceclear.api.data.methods.InstanceVulnMethodUpload;
import com.sourceclear.engine.common.ClassFileVisitor;
import com.sourceclear.engine.common.FileTypeVisitor;
import com.sourceclear.engine.common.PythonFileVisitor;
import com.sourceclear.engine.common.StoredFileVisitor;
import com.sourceclear.engine.common.logging.NoopLogStream;
import com.sourceclear.engine.component.CollectionResult;
import com.sourceclear.engine.component.linecount.LineCounter;
import com.sourceclear.engine.methods.VulnerableMethodsCollatorImpl;
import com.sourceclear.engine.scan.SrcclrScanFailureException;
import com.sourceclear.engine.scan.SrcclrScanUnexpectedCondition;
import com.sourceclear.methods.CallGraph;
import com.sourceclear.util.config.FailureLevel;
import com.sourceclear.util.config.ScanConfig;
import com.sourceclear.util.config.Verbosity;
import com.sourceclear.util.io.EvidenceUtils;
import com.sourceclear.util.io.GitUtils;
import com.sourceclear.util.io.renderers.ScanReport;
import com.sourceclear.util.io.renderers.SummaryRenderer;
import com.srcclr.sdk.LibraryGraphContainer;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibraryGraphContainerScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(LibraryGraphContainerScanner.class);
    private final ScanConfig config;
    private final Client client;
    private final boolean withPolicy;

    public LibraryGraphContainerScanner(@Nonnull ScanConfig config) {
        this.config = config;
        this.withPolicy = false;
        this.client = LibraryGraphContainerScanner.buildClient(this.config);
    }

    public LibraryGraphContainerScanner(@Nonnull ScanConfig config, @Nonnull Client sourceClearClient) {
        this(config, sourceClearClient, false);
    }

    public LibraryGraphContainerScanner(@Nonnull ScanConfig config, @Nonnull Client sourceClearClient, boolean withPolicy) {
        this.config = config;
        this.client = sourceClearClient;
        this.withPolicy = withPolicy;
    }

    public void consumeAndReport(LibraryGraphContainer projectDependencyTrees) throws SrcclrScanFailureException, SrcclrScanUnexpectedCondition {
        String policyExitMessage;
        Integer policyExitCode;
        MetaGit metaGit;
        ImmutableSet evidence = new ImmutableSet.Builder().addAll(EvidenceUtils.evidenceFromLibraryGraphs(projectDependencyTrees.getGraphs())).build();
        String pathToTop = this.config.getPathToTop().toString();
        boolean doVulnMethods = this.isMethodsSupported(pathToTop, (ImmutableSet<Evidence>)evidence);
        if (!doVulnMethods) {
            LOGGER.debug("No files found in {}. Skipping vulnerable methods check.", (Object)pathToTop);
        }
        long loc = this.countLoc();
        AgentRuntimeData agentRuntimeData = this.fillInAgentRuntimeDataForPlugins();
        CollectionResult collectionResult = new CollectionResult.Builder().withMethodsSupported(doVulnMethods).withLineCount(loc).withGraphs(projectDependencyTrees).withAgentRuntimeData(this.withPolicy ? null : agentRuntimeData).build();
        try {
            metaGit = this.getMetaGit();
        }
        catch (Exception ex) {
            throw new SrcclrScanUnexpectedCondition("An error occurred while getting the git data for this project.", ex);
        }
        boolean shouldUpload = GitUtils.isValidRemote(metaGit.getRemote()) && this.config.getUpload();
        MatchResponse response = this.match(collectionResult, metaGit, shouldUpload, null);
        List vulnMethods = null;
        Optional<Object> scanFinishUploadResponse = Optional.empty();
        if (this.withPolicy || doVulnMethods && response.isVulnMethods()) {
            Pair<List<InstanceVulnMethod>, Multimap<LanguageType, CallGraph>> vulnMethodsCallData = this.doVulnMethodsScan(response);
            vulnMethods = (List)vulnMethodsCallData.getLeft();
            if (this.config.getUpload()) {
                scanFinishUploadResponse = this.finishScan(response.getScanId(), vulnMethods, agentRuntimeData);
            } else if (this.withPolicy) {
                scanFinishUploadResponse = Optional.of(new ScanFinishUploadResponse.Builder().withExitCode(0).withIssues("").withMessage("You specified upload=false. Issues were not created as a result.").build());
            }
        } else {
            LOGGER.debug("Skipping vulnerable methods scanning.");
        }
        ScanReport report = this.buildReport((ImmutableSet<Evidence>)evidence, vulnMethods, response, loc, scanFinishUploadResponse.orElse(null));
        this.renderReport(report);
        if (this.withPolicy && !scanFinishUploadResponse.isPresent()) {
            throw new SrcclrScanUnexpectedCondition("There was an error saving your scan data. Please try scanning again.");
        }
        if (scanFinishUploadResponse.isPresent()) {
            ScanFinishUploadResponse scanFinishUploadResponseObj = (ScanFinishUploadResponse)scanFinishUploadResponse.get();
            policyExitCode = scanFinishUploadResponseObj.getExitCode();
            policyExitMessage = scanFinishUploadResponseObj.getMessage();
        } else {
            policyExitCode = null;
            policyExitMessage = null;
        }
        if (policyExitCode != null) {
            this.config.getFailureThreshold().ifPresent(v -> System.out.printf("NOTICE: You set the failure level to '%s'. This configuration is now deprecated.%nFailure values are determined by Custom Policies, available to Enterprise organizations.%nFor information about upgrading to Enterprise, email sales@sourceclear.com.%nIf you need assistance, please contact support@sourceclear.com.%n", v));
            this.maybeFailOnPolicy(policyExitCode, StringUtils.trimToEmpty((String)policyExitMessage));
        } else {
            this.maybeFailOnVulns(this.config.getFailureThreshold().orElse(FailureLevel.METHOD), report.getVulnerableMethods(), report.getVulnerableComponents());
        }
    }

    public MatchResponse match(@Nonnull CollectionResult collectionResult, @Nonnull MetaGit metaGit, boolean shouldUpload, @Nullable AgentRuntimeData agentRuntimeData) throws SrcclrScanUnexpectedCondition {
        ImmutableSet<Evidence> evidence = collectionResult.getEvidence();
        try {
            Stopwatch executionStopwatch = Stopwatch.createStarted();
            MatchResponse matchResponse = this.client.match(this.buildMatchQuery(evidence, metaGit, collectionResult.isMethodsSupported(), shouldUpload, collectionResult.getLineCount(), agentRuntimeData != null ? agentRuntimeData : collectionResult.getAgentRuntimeData()));
            LOGGER.debug("Matched in {} seconds.", (Object)executionStopwatch.elapsed(TimeUnit.SECONDS));
            return matchResponse;
        }
        catch (IOException ex) {
            LOGGER.debug("IOException when sending match request:", (Throwable)ex);
            throw new SrcclrScanUnexpectedCondition(ex.getMessage(), ex);
        }
    }

    public void completeForFailedScans(@Nonnull MetaGit metaGit, boolean shouldUpload, @Nonnull AgentRuntimeData agentRuntimeData) throws SrcclrScanUnexpectedCondition {
        try {
            Stopwatch executionStopwatch = Stopwatch.createStarted();
            this.client.match(this.buildMatchQuery(null, metaGit, false, shouldUpload, null, agentRuntimeData));
            LOGGER.debug("Matched in {} seconds.", (Object)executionStopwatch.elapsed(TimeUnit.SECONDS));
        }
        catch (IOException ex) {
            LOGGER.debug("IOException when sending match request:", (Throwable)ex);
            throw new SrcclrScanUnexpectedCondition(ex.getMessage(), ex);
        }
    }

    public Pair<List<InstanceVulnMethod>, Multimap<LanguageType, CallGraph>> doVulnMethodsScan(MatchResponse response) {
        VulnerableMethodsCollatorImpl collator = new VulnerableMethodsCollatorImpl(response.getComponents(), new NoopLogStream());
        List<InstanceVulnMethod> vulnMethods = collator.scanPath(this.config.getPathToTop().toPath());
        Multimap<LanguageType, CallGraph> callgraph = collator.getCallGraph();
        return Pair.of(vulnMethods, callgraph);
    }

    public Optional<ScanFinishUploadResponse> finishScan(String scanId, List<InstanceVulnMethod> vulnMethods, @Nonnull AgentRuntimeData agentRuntimeData) {
        Optional<ScanFinishUploadResponse> response;
        block5: {
            InstanceVulnMethodUpload.Builder builder = new InstanceVulnMethodUpload.Builder().setAgentRuntimeData(agentRuntimeData);
            if (vulnMethods != null) {
                builder.addAllVulnMethods(vulnMethods);
            }
            InstanceVulnMethodUpload vmUpload = builder.build();
            response = Optional.empty();
            try {
                if (this.withPolicy) {
                    ScanFinishUploadResponse scanFinishUploadResponse = this.client.callScanFinishAndUploadVulnMethods(scanId, vmUpload);
                    response = Optional.ofNullable(scanFinishUploadResponse);
                } else {
                    this.client.uploadVulnerableMethods(scanId, vmUpload);
                }
            }
            catch (Exception e) {
                LOGGER.error("Encountered error during vulnerable method upload.", (Throwable)e);
                if (this.withPolicy) break block5;
                LOGGER.error("Vulnerable methods upload failed for non-policy scan.");
            }
        }
        return response;
    }

    private void maybeFailOnPolicy(int exitCode, @Nonnull String exitMessage) throws SrcclrScanFailureException {
        System.out.println(exitMessage);
        if (exitCode > 0) {
            throw new SrcclrScanFailureException(exitMessage);
        }
    }

    void maybeFailOnVulns(FailureLevel failureThreshold, Integer optVulnMethodCount, int vulnComponentCount) throws SrcclrScanFailureException {
        FailureLevel failureLevel = null;
        if (optVulnMethodCount != null && optVulnMethodCount > 0) {
            failureLevel = FailureLevel.METHOD;
        } else if (vulnComponentCount > 0) {
            failureLevel = FailureLevel.COMPONENT;
        }
        if (failureLevel != null && failureLevel.compareTo(failureThreshold) >= 0) {
            throw new SrcclrScanFailureException("The current scan found vulnerable " + failureLevel.toString().toLowerCase() + "s, failing as failureThreshold is set to " + (Object)((Object)failureThreshold) + ".");
        }
    }

    private void renderReport(ScanReport report) {
        Verbosity verbosity = this.config.getReportVerbosity();
        if (verbosity == Verbosity.SILENT) {
            return;
        }
        String clientVersion = this.config.getClientVersion() != null ? this.config.getClientVersion() : "Unknown";
        new SummaryRenderer(clientVersion, "Unknown", System.out, this.withPolicy).accept(report);
    }

    private ScanReport buildReport(ImmutableSet<Evidence> evidence, List<InstanceVulnMethod> methodScanResult, MatchResponse response, @Nullable Long loc, @Nullable ScanFinishUploadResponse scanFinishUploadResponse) {
        ScanReport.Builder reportBuilder = new ScanReport.Builder().withScanConfig(this.config).withAppBase(URI.create("https://srcclr.com")).withScanPath(this.config.getPathToTop().toString()).withDuration((System.currentTimeMillis() - this.config.getScanStart()) / 1000L).withEvidence((Collection<Evidence>)evidence).withMatchResponse(response).withMethodScanResult(methodScanResult).withUpload(this.config.getUpload()).withLineCount(loc);
        if (scanFinishUploadResponse != null) {
            reportBuilder.withScanFinishUploadResponse(scanFinishUploadResponse);
        }
        return reportBuilder.build();
    }

    private static Client buildClient(ScanConfig config) {
        SourceClearClient.Builder clientBuilder = new SourceClearClient.Builder().withApiToken(config.getApiToken()).withBaseURI(config.getApiURL()).withClientType(SourceClearClient.Type.CLI).withClientVersion(config.getClientVersion()).withExpBackOffInitial(5);
        return clientBuilder.build();
    }

    private long countLoc() {
        try {
            return LineCounter.countLOC(this.config.getPathToTop(), this.client);
        }
        catch (Exception ex) {
            LOGGER.error("Skipping counting lines-of-code because an exception occurred:", (Throwable)ex);
            return 0L;
        }
    }

    MatchQuery buildMatchQuery(@Nullable ImmutableSet<Evidence> evidence, @Nonnull MetaGit metaGit, boolean methodsSupported, boolean shouldUpload, @Nullable Long loc, @Nullable AgentRuntimeData agentRuntimeData) {
        MatchQuery.Builder builder = new MatchQuery.Builder().withProjectId(this.config.getUserProjectID()).withScanId(this.config.getScanID()).withProjectName(this.config.getProjectName()).withMetaGit(metaGit).persist(shouldUpload).withAgentRuntimeData(agentRuntimeData).withWorkspaceSlug(this.config.getWorkspaceSlug().orElse(null));
        if (evidence != null) {
            builder.withEvidence(new ArrayList<Evidence>((Collection<Evidence>)evidence)).requestVulnMethods(methodsSupported).requestPublicMethods(methodsSupported).withLinesOfCode(loc);
        } else {
            LOGGER.debug("Evidence set is empty after collection.");
            builder.withEvidence(null);
        }
        return builder.build();
    }

    private Map<String, String> getEnv() {
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        if (this.isLicensedForGenericSCM()) {
            env.put("__WITHOUT_GIT__", "1");
        }
        return env;
    }

    MetaGit getMetaGit() throws Exception {
        return GitUtils.getGitMetaData(this.config.getPathToTop(), 30, this.getEnv(), new HashSet<GitUtils.CommitInfoPerms>());
    }

    private boolean isLicensedForGenericSCM() {
        PlanType planType = Optional.ofNullable(this.config.getLicenseData().getPlanType()).orElse(PlanType.OPEN);
        return planType.compareTo(PlanType.TRIAL) >= 0;
    }

    private boolean isMethodsSupported(String projectRoot, ImmutableSet<Evidence> evidence) {
        if (evidence == null || evidence.size() == 0) {
            return false;
        }
        for (Evidence ev : evidence) {
            LanguageType languageType;
            CoordinateType coordinateType;
            if (ev.getEvidenceType() == EvidenceType.JAR) {
                Optional<FileTypeVisitor> fileVisitor = this.getVulnMethodVisitorForLanguageType(LanguageType.JAVA);
                return fileVisitor.isPresent() && this.internalIsMethodsSupported(projectRoot, fileVisitor.get());
            }
            Coordinates coordinates = ev.getCoordinates();
            if (coordinates == null || (coordinateType = coordinates.getCoordinateType()) == null || (languageType = coordinateType.getPrimaryLanguage()) == null) continue;
            Optional<FileTypeVisitor> fileVisitor = this.getVulnMethodVisitorForLanguageType(languageType);
            return fileVisitor.isPresent() && this.internalIsMethodsSupported(projectRoot, fileVisitor.get());
        }
        return false;
    }

    private boolean internalIsMethodsSupported(@Nonnull String projectRoot, @Nonnull StoredFileVisitor storedFileVisitor) {
        try {
            Files.walkFileTree(Paths.get(projectRoot, new String[0]), storedFileVisitor);
            return !storedFileVisitor.getFiles().isEmpty();
        }
        catch (Exception ex) {
            LOGGER.error("Unable to determine vulnerable methods support due to exception:", (Throwable)ex);
            return false;
        }
    }

    private Optional<FileTypeVisitor> getVulnMethodVisitorForLanguageType(@Nonnull LanguageType languageType) {
        switch (languageType) {
            case JAVA: {
                return Optional.of(ClassFileVisitor.getVisitor());
            }
            case PYTHON: {
                return Optional.of(PythonFileVisitor.getVisitor());
            }
        }
        return Optional.empty();
    }

    private AgentRuntimeData fillInAgentRuntimeDataForPlugins() {
        return new AgentRuntimeData.Builder().setAgentType(this.config.getClientType() != null ? this.config.getClientType().name() : "").setAgentVersion(StringUtils.trimToEmpty((String)this.config.getClientVersion())).setJVMVersion(System.getProperty("java.runtime.version", System.getProperty("java.version", "UNKNOWN"))).setOS(System.getProperty("os.name", "UNKNOWN")).setOSVersion(System.getProperty("os.version", "UNKNOWN")).build();
    }
}

