/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.librarydiffs.delta;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.annotations.VisibleForTesting;
import com.sourceclear.librarydiffs.DeltaComposition;
import com.sourceclear.librarydiffs.delta.Deserializer;
import com.sourceclear.librarydiffs.delta.Op;
import com.sourceclear.librarydiffs.delta.Serializer;
import com.sourceclear.methods.MethodInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class LibDelta {
    private final Map<MethodInfo, Op> methods;

    public LibDelta(Map<MethodInfo, Op> methods) {
        this.methods = methods;
    }

    public LibDelta() {
        this(new HashMap<MethodInfo, Op>());
    }

    public DeltaComposition compose(LibDelta later) {
        HashSet<DeltaComposition.Error> errors = new HashSet<DeltaComposition.Error>();
        HashMap<MethodInfo, Op> rawResult = new HashMap<MethodInfo, Op>();
        for (Map.Entry<MethodInfo, Op> md : this.methods.entrySet()) {
            if (!later.methods.containsKey(md.getKey())) {
                LibDelta.compose(md.getValue(), Op.UNKNOWN, md.getKey(), rawResult, errors);
                continue;
            }
            Op laterOp = later.methods.get(md.getKey());
            LibDelta.compose(md.getValue(), laterOp, md.getKey(), rawResult, errors);
        }
        for (Map.Entry<MethodInfo, Op> md : later.methods.entrySet()) {
            if (this.methods.containsKey(md.getKey())) continue;
            LibDelta.compose(Op.UNKNOWN, md.getValue(), md.getKey(), rawResult, errors);
        }
        return new DeltaComposition(new LibDelta(rawResult), errors);
    }

    private static void compose(Op a, Op b, MethodInfo key, Map<MethodInfo, Op> rawResult, Set<DeltaComposition.Error> errors) {
        try {
            Op o = LibDelta.compose(a, b);
            if (o != Op.UNKNOWN) {
                rawResult.put(key, o);
            }
        }
        catch (Exception e) {
            errors.add(new DeltaComposition.Error(key, e.getMessage()));
        }
    }

    public static Op compose(Op earlier, Op later) throws IllegalStateException {
        switch (earlier) {
            case INSERT: {
                switch (later) {
                    case INSERT: {
                        throw LibDelta.fail(earlier, later);
                    }
                    case DELETE: {
                        return Op.UNKNOWN;
                    }
                    case CHANGE: 
                    case UNKNOWN: {
                        return Op.INSERT;
                    }
                }
                break;
            }
            case CHANGE: {
                switch (later) {
                    case INSERT: {
                        throw LibDelta.fail(earlier, later);
                    }
                    case DELETE: {
                        return Op.DELETE;
                    }
                    case CHANGE: 
                    case UNKNOWN: {
                        return Op.CHANGE;
                    }
                }
            }
            case DELETE: {
                switch (later) {
                    case INSERT: {
                        return Op.CHANGE;
                    }
                    case UNKNOWN: {
                        return Op.DELETE;
                    }
                    case DELETE: 
                    case CHANGE: {
                        throw LibDelta.fail(earlier, later);
                    }
                }
            }
            case UNKNOWN: {
                return later;
            }
        }
        throw LibDelta.fail(earlier, later);
    }

    public Set<MethodInfo> getAffectedMethods() {
        HashSet<MethodInfo> result = new HashSet<MethodInfo>();
        for (Map.Entry<MethodInfo, Op> methodEntry : this.methods.entrySet()) {
            switch (methodEntry.getValue()) {
                case INSERT: {
                    break;
                }
                case DELETE: 
                case CHANGE: {
                    result.add(methodEntry.getKey());
                }
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LibDelta libDelta = (LibDelta)o;
        return Objects.equals(this.methods, libDelta.methods);
    }

    public int hashCode() {
        return Objects.hash(this.methods);
    }

    public String toString() {
        return "LibDelta{methods=" + this.methods + '}';
    }

    private static IllegalStateException fail(Op earlier, Op later) {
        return new IllegalStateException(String.format("%s . %s is invalid", new Object[]{earlier, later}));
    }

    @VisibleForTesting
    public Map<MethodInfo, Op> getExplicitChanges() {
        return this.methods;
    }
}

