/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods;

import com.google.common.base.MoreObjects;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.sourceclear.methods.CallSite;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.sgl.TinkerPop;
import com.sourceclear.sgl.dsl.SGLSchema;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import org.javatuples.Pair;

public class CallGraph {
    private final Graph graph;
    private final BiMap<MethodInfo, Vertex> cache = HashBiMap.create();

    public CallGraph() {
        this(TinkerGraph.open());
    }

    public CallGraph(TinkerGraph graph) {
        this.graph = graph;
    }

    public Set<CallSite> callersFor(MethodInfo callee) {
        return this.graph.traversal().V(new Object[]{CallGraph.method((MethodInfo)callee).id}).inE(new String[]{"calls"}).map(t -> CallGraph.toCallSite((Edge)t.get())).toSet();
    }

    public boolean containsVertex(MethodInfo vertex) {
        return this.cache.containsKey((Object)vertex);
    }

    public Vertex getVertex(MethodInfo vertex) {
        return (Vertex)this.cache.get((Object)vertex);
    }

    public MethodInfo getMethodInfo(Vertex vertex) {
        return (MethodInfo)this.cache.inverse().get((Object)vertex);
    }

    public void addEdge(CallSite callSite) {
        MethodInfo caller = callSite.getCaller();
        MethodInfo callee = callSite.getCallee();
        Vertex from = this.addVertex(caller);
        Vertex to = this.addVertex(callee);
        from.addEdge("calls", to, new Object[]{"at", String.format("%s:%s", callSite.getFileName(), callSite.getLineNumber())});
    }

    public Vertex addVertex(MethodInfo method) {
        return (Vertex)this.cache.computeIfAbsent((Object)method, m -> this.addVertex(CallGraph.method(method)));
    }

    private Vertex addVertex(TinkerPop.VertexArgs args) {
        try {
            return this.graph.addVertex(args.args);
        }
        catch (IllegalArgumentException e) {
            return (Vertex)this.graph.traversal().V(new Object[]{args.id}).next();
        }
    }

    public Stream<MethodInfo> vertices() {
        return Streams.stream((Iterator)this.graph.vertices(new Object[0])).map(CallGraph::toMethodInfo);
    }

    public Stream<CallSite> edges() {
        return Streams.stream((Iterator)this.graph.edges(new Object[0])).filter(e -> e.label().equals("calls")).map(CallGraph::toCallSite);
    }

    private static boolean graphEquals(Graph g1, Graph g2) {
        HashSet v2;
        HashSet v1 = Sets.newHashSet((Iterator)g1.vertices(new Object[0]));
        if (!v1.equals(v2 = Sets.newHashSet((Iterator)g2.vertices(new Object[0])))) {
            return false;
        }
        Set e1 = Streams.stream((Iterator)g1.edges(new Object[0])).map(e -> new Pair((Object)e.outVertex(), (Object)e.inVertex())).collect(Collectors.toSet());
        Set e2 = Streams.stream((Iterator)g1.edges(new Object[0])).map(e -> new Pair((Object)e.outVertex(), (Object)e.inVertex())).collect(Collectors.toSet());
        return e1.equals(e2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallGraph callGraph = (CallGraph)o;
        return CallGraph.graphEquals(this.graph, callGraph.graph) && Objects.equals(this.cache, callGraph.cache);
    }

    public int hashCode() {
        return Objects.hash(this.graph, this.cache);
    }

    public static CallSite toCallSite(Edge edge) {
        return CallGraph.toCallSite(edge.outVertex(), edge, edge.inVertex());
    }

    public static CallSite toCallSite(Vertex from, Edge edge, Vertex to) {
        return CallGraph.toCallSite(CallGraph.toMethodInfo(from), edge, CallGraph.toMethodInfo(to));
    }

    public static CallSite toCallSite(MethodInfo from, Edge edge, MethodInfo to) {
        String at = (String)edge.property("at").value();
        String[] parts = at.split(":");
        return new CallSite(from, to, parts[0], Integer.parseInt(parts[1]));
    }

    public static MethodInfo toMethodInfo(Vertex vertex) {
        String moduleName = (String)vertex.property("module_name").value();
        String className = (String)vertex.property("class_name").value();
        String methodName = (String)vertex.property("method_name").value();
        String descriptor = (String)vertex.property("descriptor").value();
        return new MethodInfo(moduleName.equals("null") ? null : moduleName, className.equals("null") ? null : className, methodName.equals("null") ? null : methodName, descriptor.equals("null") ? null : descriptor);
    }

    public static TinkerPop.VertexArgs method(MethodInfo v) {
        return SGLSchema.TinkerPop.method("null", "null", "null", "null", (String)MoreObjects.firstNonNull((Object)v.getModuleName(), (Object)"null"), (String)MoreObjects.firstNonNull((Object)v.getClassName(), (Object)"null"), (String)MoreObjects.firstNonNull((Object)v.getMethodName(), (Object)"null"), (String)MoreObjects.firstNonNull((Object)v.getDesc(), (Object)"null"));
    }

    public Iterable<MethodInfo> verticesIt() {
        return this.vertices()::iterator;
    }

    public Iterable<CallSite> edgesIt() {
        return this.edges()::iterator;
    }

    public Graph getGraph() {
        return this.graph;
    }
}

