/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.sourceclear.analysis.utils.Utils;
import com.sourceclear.methods.CallGraph;
import com.sourceclear.methods.CallGraphBuilder;
import com.sourceclear.methods.CallGraphClassVisitor;
import com.sourceclear.methods.CallSite;
import com.sourceclear.methods.ClassHierarchyClassVisitor;
import com.sourceclear.methods.ClassInfo;
import com.sourceclear.methods.Constants;
import com.sourceclear.methods.MethodInfo;
import com.zaxxer.sparsebits.SparseBitSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaCallGraphBuilder
implements CallGraphBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaCallGraphBuilder.class);
    private final CallGraph callGraph = new CallGraph();
    private final List<ClassReader> classReaders;
    private final Map<ClassReader, Path> classReaderPathMap = new HashMap<ClassReader, Path>();
    private final Map<String, SparseBitSet> cones = new HashMap<String, SparseBitSet>();
    private Map<String, Set<String>> classToDirectSubclasses;
    private Map<String, Set<String>> interfaceToImplementers;
    private Map<String, Set<MethodInfo>> classToAppliesToMethods;
    private ImmutableMap<String, Integer> classToInteger;
    private Map<MethodInfo, SparseBitSet> appliesTos;
    private Set<MethodInfo> methodsDefined;
    private Set<MethodInfo> reflectedMethods;
    private ImmutableList<String> integerToClassNames;
    private SparseBitSet instantiatedTypes;
    private Map<String, ClassInfo> classNameToClassInfo;
    private final boolean parallel;

    public JavaCallGraphBuilder(List<ClassReader> classReaders, boolean parallel) {
        this.classReaders = classReaders;
        this.parallel = parallel;
        this.collectClassHierarchyInformation();
    }

    public JavaCallGraphBuilder(JarInputStream jarInputStream, boolean parallel) throws IOException {
        this.parallel = parallel;
        ArrayList<ClassReader> classReaders = new ArrayList<ClassReader>();
        Utils.readEntries(jarInputStream, classReader -> {
            classReaders.add(classReader);
            return Optional.empty();
        });
        this.classReaders = classReaders;
        this.collectClassHierarchyInformation();
    }

    public JavaCallGraphBuilder(Collection<Path> paths, boolean parallel) throws IOException {
        this.parallel = parallel;
        ArrayList<ClassReader> classReaders = new ArrayList<ClassReader>();
        for (Path path : paths) {
            ClassReader cr;
            try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                cr = new ClassReader(in);
                cr.getClassName();
            }
            catch (RuntimeException e) {
                this.handleClassFileError((Exception)e, path);
                continue;
            }
            classReaders.add(cr);
            this.classReaderPathMap.put(cr, path);
        }
        this.classReaders = classReaders;
        this.collectClassHierarchyInformation();
    }

    public JavaCallGraphBuilder(JarFile jarFile, boolean parallel) {
        this.classReaders = Utils.classReaders(jarFile);
        this.parallel = parallel;
        this.collectClassHierarchyInformation();
    }

    @Override
    public void build() {
        this.getClassReaderStream().flatMap(cr -> {
            try {
                String className = cr.getClassName();
                CallGraphClassVisitor visitor = CallGraphClassVisitor.builder().withVersion(327680).withClassName(className).withCones(this.cones).withAppliesTo(this.appliesTos).withIntegerToClass((List<String>)this.integerToClassNames).withClassNameToClassInfo(this.classNameToClassInfo).withInstantiatedTypes(this.instantiatedTypes).withClassToAppliesToMethods(this.classToAppliesToMethods).withReflectedMethods(this.reflectedMethods).withClassToInteger((Map<String, Integer>)this.classToInteger).build();
                cr.accept((ClassVisitor)visitor, 0);
                return visitor.getCallSites().stream();
            }
            catch (RuntimeException e) {
                this.handleClassFileError((Exception)e, (ClassReader)cr);
                return Stream.empty();
            }
        }).forEachOrdered(callSite -> this.callGraph.addEdge((CallSite)callSite));
    }

    private Set<MethodInfo> getMethodsWithName(Collection<MethodInfo> methods, String methodName) {
        HashSet<MethodInfo> result = new HashSet<MethodInfo>();
        for (MethodInfo method : methods) {
            if (!method.getMethodName().equals(methodName)) continue;
            result.add(method);
        }
        return result;
    }

    private void collectClassHierarchyInformation() {
        Set<ClassInfo> classInfos = this.getClassReaderStream().map(cr -> {
            try {
                String className = cr.getClassName();
                ClassHierarchyClassVisitor classHierarchyVisitor = new ClassHierarchyClassVisitor(327680, className);
                cr.accept((ClassVisitor)classHierarchyVisitor, 0);
                return Optional.of(classHierarchyVisitor.getClassInfo());
            }
            catch (RuntimeException e) {
                this.handleClassFileError((Exception)e, (ClassReader)cr);
                return Optional.empty();
            }
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        this.classNameToClassInfo = Collections.unmodifiableMap(this.getClassInfoStream(classInfos).collect(Collectors.toMap(ci -> ci.getClassName(), Function.identity(), (c1, ignored) -> c1)));
        BinaryOperator mergeMultiMaps = (x, y) -> {
            HashMap result = new HashMap(x);
            for (Map.Entry entry : y.entrySet()) {
                HashSet xValue = new HashSet(result.getOrDefault(entry.getKey(), Collections.emptySet()));
                xValue.addAll((Collection)entry.getValue());
                result.put(entry.getKey(), xValue);
            }
            return result;
        };
        HashMap<String, ImmutableSet<String>> initialClasses = new HashMap<String, ImmutableSet<String>>();
        initialClasses.put("java/lang/Object", Constants.CONCURRENT_CLASSES);
        this.classToDirectSubclasses = Collections.unmodifiableMap(this.getClassInfoStream(classInfos).reduce(initialClasses, (accum, classInfo) -> {
            HashMap result = new HashMap(accum);
            classInfo.getSuperName().ifPresent(superName -> {
                HashSet<String> subclasses = new HashSet<String>(result.computeIfAbsent(superName, x -> Collections.emptySet()));
                subclasses.add(classInfo.getClassName());
                result.put(superName, subclasses);
            });
            return result;
        }, mergeMultiMaps));
        this.methodsDefined = Collections.unmodifiableSet(this.getClassInfoStream(classInfos).flatMap(ci -> ci.getMethods().stream()).collect(Collectors.toSet()));
        HashMap<String, Set<String>> initial = new HashMap<String, Set<String>>();
        initial.put("java/lang/Runnable", Collections.singleton("java/lang/Thread"));
        initial.put("java/util/concurrent/Executor", (Set<String>)Constants.EXECUTOR_IMPLEMENTORS);
        initial.put("java/util/concurrent/ExecutorService", (Set<String>)Constants.EXECUTOR_SERVICE_IMPLEMENTORS);
        initial.put("java/util/concurrent/CompletionService", Constants.COMPLETION_SERVICE_IMPLEMENTORS);
        this.interfaceToImplementers = Collections.unmodifiableMap(this.getClassInfoStream(classInfos).reduce(initial, (accum, classInfo) -> {
            HashMap<String, Set> result = new HashMap<String, Set>((Map<String, Set>)accum);
            for (String i : classInfo.getImplementedInterfaces()) {
                HashSet<String> implementers = new HashSet<String>(result.computeIfAbsent(i, x -> Collections.emptySet()));
                implementers.add(classInfo.getClassName());
                result.put(i, implementers);
            }
            return result;
        }, mergeMultiMaps));
        Set<String> instantiatedTypes = Collections.unmodifiableSet(this.getClassInfoStream(classInfos).flatMap(ci -> ci.getInstantiatedTypes().stream()).collect(Collectors.toSet()));
        this.initializeMappers();
        this.instantiatedTypes = this.mapClassesToBitSet(instantiatedTypes);
        Set<Type> reflectedClasses = Collections.unmodifiableSet(this.getClassInfoStream(classInfos).flatMap(ci -> ci.getReflectedClasses().stream()).collect(Collectors.toSet()));
        Set<String> reflectedMethodNames = Collections.unmodifiableSet(this.getClassInfoStream(classInfos).flatMap(ci -> ci.getReflectedMethodNames().stream()).collect(Collectors.toSet()));
        HashSet<MethodInfo> reflectedMethods = new HashSet<MethodInfo>();
        for (Type classType : reflectedClasses) {
            for (String methodName : reflectedMethodNames) {
                String className = classType.getInternalName();
                if (!this.classNameToClassInfo.containsKey(className)) continue;
                ClassInfo classInfo2 = this.classNameToClassInfo.get(className);
                reflectedMethods.addAll(this.getMethodsWithName(classInfo2.getMethods(), methodName));
            }
        }
        this.reflectedMethods = Collections.unmodifiableSet(reflectedMethods);
        this.buildDataStructuresForAnalysis();
    }

    private Stream<ClassInfo> getClassInfoStream(Collection<ClassInfo> classInfos) {
        return this.parallel ? classInfos.parallelStream() : classInfos.stream();
    }

    private Stream<ClassReader> getClassReaderStream() {
        return this.parallel ? this.classReaders.parallelStream() : this.classReaders.stream();
    }

    private void buildDataStructuresForAnalysis() {
        this.buildConesForClasses();
        this.buildConesForInterfaces();
        this.buildConeForObject();
        this.buildAppliesTo();
        this.buildCache();
    }

    private void buildCache() {
        Stream conesEntries = this.parallel ? this.cones.entrySet().parallelStream() : this.cones.entrySet().stream();
        this.classToAppliesToMethods = conesEntries.collect(Collectors.toMap(e -> (String)e.getKey(), entry -> {
            SparseBitSet cone = (SparseBitSet)entry.getValue();
            Stream appliesTosEntries = this.parallel ? this.appliesTos.entrySet().parallelStream() : this.appliesTos.entrySet().stream();
            Set appliesToMethods = appliesTosEntries.map(appliesToEntry -> {
                SparseBitSet appliesTo = (SparseBitSet)appliesToEntry.getValue();
                MethodInfo methodInfo = (MethodInfo)appliesToEntry.getKey();
                SparseBitSet bs = Utils.setDifference(cone, appliesTo);
                return new AbstractMap.SimpleImmutableEntry<MethodInfo, SparseBitSet>(methodInfo, bs);
            }).filter(pair -> ((SparseBitSet)pair.getValue()).isEmpty()).map(AbstractMap.SimpleImmutableEntry::getKey).collect(Collectors.toSet());
            return appliesToMethods;
        }));
    }

    private void initializeMappers() {
        int count = 0;
        ImmutableMap.Builder classToIntegerBuilder = ImmutableMap.builder();
        classToIntegerBuilder.put((Object)"java/lang/Object", (Object)count);
        ImmutableList.Builder integerToClassBuilder = ImmutableList.builder();
        integerToClassBuilder.add((Object)"java/lang/Object");
        ++count;
        Set<String> classNames = this.classNameToClassInfo.keySet();
        HashSet subclassNames = new HashSet(this.classToDirectSubclasses.get("java/lang/Object"));
        Sets.SetView union = Sets.union(classNames, subclassNames);
        for (String className : union) {
            classToIntegerBuilder.put((Object)className, (Object)count);
            integerToClassBuilder.add((Object)className);
            ++count;
        }
        this.classToInteger = classToIntegerBuilder.build();
        this.integerToClassNames = integerToClassBuilder.build();
    }

    private void buildConeForObject() {
        SparseBitSet bs = this.cones.get("java/lang/Object");
        for (String subclasses : this.classToDirectSubclasses.get("java/lang/Object")) {
            SparseBitSet b = Objects.requireNonNull(this.cones.get(subclasses), String.format("Expected cone for \"%s\"", subclasses));
            bs.or(b);
        }
    }

    private void buildConesForClasses() {
        String root = "java/lang/Object";
        ArrayDeque<String> stack = new ArrayDeque<String>();
        stack.push("java/lang/Object");
        HashSet<String> visited = new HashSet<String>();
        while (!stack.isEmpty()) {
            SparseBitSet bs;
            String currentClass = (String)stack.peek();
            if (this.isInterface(currentClass)) {
                stack.pop();
                continue;
            }
            Collection classChildren = this.classToDirectSubclasses.get(currentClass);
            boolean isLeafNode = classChildren == null || classChildren.isEmpty();
            int bitIndex = (Integer)this.classToInteger.get((Object)currentClass);
            if (isLeafNode) {
                bs = new SparseBitSet();
                bs.set(bitIndex);
                this.cones.put(currentClass, bs);
                visited.add(currentClass);
                stack.pop();
                continue;
            }
            if (visited.contains(currentClass)) {
                bs = new SparseBitSet();
                bs.set(bitIndex);
                for (String child : classChildren) {
                    if (!this.cones.containsKey(child)) continue;
                    SparseBitSet childCone = this.cones.get(child);
                    bs.or(childCone);
                }
                this.cones.put(currentClass, bs);
                stack.removeFirst();
                continue;
            }
            visited.add(currentClass);
            for (String className : classChildren) {
                stack.push(className);
            }
        }
    }

    private void buildConesForInterfaces() {
        String root = "java/lang/Object";
        Collection subclasses = this.classToDirectSubclasses.get(root);
        ArrayDeque<String> stack = new ArrayDeque<String>();
        HashSet<String> visited = new HashSet<String>();
        stack.addAll(subclasses);
        while (!stack.isEmpty()) {
            String currentInterface = (String)stack.peek();
            if (this.isInterface(currentInterface)) {
                SparseBitSet cone;
                Collection implementersAndDirectSubinterfaces = this.interfaceToImplementers.getOrDefault(currentInterface, Collections.emptySet());
                HashSet<String> directSubinterfaces = new HashSet<String>();
                for (String i : implementersAndDirectSubinterfaces) {
                    if (!this.isInterface(i)) continue;
                    directSubinterfaces.add(i);
                }
                boolean isLeafNode = directSubinterfaces.isEmpty();
                if (isLeafNode) {
                    cone = new SparseBitSet();
                    for (String implementer : implementersAndDirectSubinterfaces) {
                        if (!this.cones.containsKey(implementer)) continue;
                        cone.or(this.cones.get(implementer));
                    }
                    this.cones.put(currentInterface, cone);
                    stack.pop();
                    continue;
                }
                if (visited.contains(currentInterface)) {
                    cone = new SparseBitSet();
                    for (String implementerOrSubInterface : implementersAndDirectSubinterfaces) {
                        if (!this.cones.containsKey(implementerOrSubInterface)) continue;
                        cone.or(this.cones.get(implementerOrSubInterface));
                    }
                    this.cones.put(currentInterface, cone);
                    stack.pop();
                    continue;
                }
                visited.add(currentInterface);
                for (String className : implementersAndDirectSubinterfaces) {
                    stack.push(className);
                }
                continue;
            }
            stack.pop();
        }
    }

    private void buildAppliesTo() {
        Stream stream = this.parallel ? this.methodsDefined.parallelStream() : this.methodsDefined.stream();
        this.appliesTos = stream.collect(Collectors.toMap(Function.identity(), method -> {
            SparseBitSet overridersCone = this.directlyOverridingClasses((MethodInfo)method).orElse(new SparseBitSet());
            SparseBitSet bitSet = this.cones.get(method.getClassName());
            SparseBitSet coneBS = bitSet == null ? new SparseBitSet() : bitSet;
            return Utils.setDifference(coneBS, overridersCone);
        }));
    }

    private Optional<SparseBitSet> directlyOverridingClasses(MethodInfo method) {
        String className = method.getClassName();
        SparseBitSet overridersCone = new SparseBitSet();
        Set directSubclasses = Collections.unmodifiableSet(this.classToDirectSubclasses.getOrDefault(className, Collections.emptySet()));
        if (directSubclasses == null || directSubclasses.isEmpty()) {
            return Optional.empty();
        }
        ArrayDeque queue = new ArrayDeque(directSubclasses);
        while (!queue.isEmpty()) {
            String currentClass = (String)queue.remove();
            MethodInfo overridingMethod = new MethodInfo(currentClass, method.getMethodName(), method.getDesc());
            if (this.methodsDefined.contains(overridingMethod)) {
                SparseBitSet bitSet = this.cones.get(currentClass);
                if (bitSet == null) continue;
                overridersCone.or(bitSet);
                continue;
            }
            if (this.classToDirectSubclasses.get(currentClass) == null || this.classToDirectSubclasses.get(currentClass).isEmpty()) continue;
            queue.addAll((Collection)this.classToDirectSubclasses.get(currentClass));
        }
        return Optional.of(overridersCone);
    }

    private SparseBitSet mapClassesToBitSet(Collection<String> classes) {
        int numberOfClasses = this.classToInteger.size();
        SparseBitSet bs = new SparseBitSet(numberOfClasses);
        for (String className : classes) {
            if (!this.classToInteger.containsKey((Object)className)) continue;
            int bitIndex = (Integer)this.classToInteger.get((Object)className);
            bs.set(bitIndex);
        }
        return bs;
    }

    private boolean isInterface(String className) {
        return this.interfaceToImplementers.containsKey(className);
    }

    private void handleClassFileError(Exception e, @NotNull ClassReader cr) {
        Path path = this.classReaderPathMap.get(cr);
        if (path != null) {
            this.handleClassFileError(e, path);
        } else {
            LOGGER.debug("Error reading bytecode", (Throwable)e);
            LOGGER.warn("Ignoring invalid class found.");
        }
    }

    private void handleClassFileError(Exception e, @NotNull Path path) {
        LOGGER.debug("Error reading bytecode", (Throwable)e);
        LOGGER.warn("Ignoring invalid class found at path: '{}'", (Object)path);
    }

    @Override
    public CallGraph getCallGraph() {
        return this.callGraph;
    }

    @Override
    public Set<MethodInfo> getMethodsDefined() {
        return Collections.unmodifiableSet(this.methodsDefined);
    }
}

