/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

public class MethodInfo {
    @JsonProperty
    private final String moduleName;
    @JsonProperty
    private final String className;
    @JsonProperty
    private final String methodName;
    @JsonProperty
    private final String desc;
    @JsonIgnore
    private final Set<Attribute> attributes;
    private volatile int cachedHashCode = 0;

    @JsonCreator
    public MethodInfo(@JsonProperty(value="module_name") String moduleName, @JsonProperty(value="class_name") String className, @JsonProperty(value="method_name") String methodName, @JsonProperty(value="desc") String desc) {
        this(moduleName, className, methodName, desc, EnumSet.noneOf(Attribute.class));
    }

    public MethodInfo(String className, String methodName, String desc) {
        this(className, methodName, desc, EnumSet.noneOf(Attribute.class));
    }

    public MethodInfo(String className, String methodName, String desc, Set<Attribute> attributes) {
        this(null, className, methodName, desc, attributes);
    }

    public MethodInfo(String moduleName, String className, String methodName, String desc, Set<Attribute> attributes) {
        this.moduleName = moduleName;
        this.className = className;
        this.methodName = methodName;
        this.desc = desc;
        this.attributes = Collections.unmodifiableSet(attributes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodInfo that = (MethodInfo)o;
        return Objects.equals(this.moduleName, that.moduleName) && Objects.equals(this.className, that.className) && Objects.equals(this.methodName, that.methodName) && Objects.equals(this.desc, that.desc);
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            this.cachedHashCode = Objects.hash(this.moduleName, this.className, this.methodName, this.desc);
        }
        return this.cachedHashCode;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.attributes.isEmpty()) {
            stringBuilder.append(this.attributes.toString());
            stringBuilder.append(" ");
        }
        if (this.moduleName != null) {
            stringBuilder.append(this.moduleName);
            stringBuilder.append(".");
        }
        if (this.className != null) {
            stringBuilder.append(this.className);
            stringBuilder.append(".");
        }
        if (this.methodName != null) {
            stringBuilder.append(this.methodName);
        }
        if (this.desc != null) {
            stringBuilder.append(this.desc);
        }
        return stringBuilder.toString();
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getDesc() {
        return this.desc;
    }

    public Set<Attribute> getAttributes() {
        return this.attributes;
    }

    public static enum Attribute {
        SYNTHETIC,
        ABSTRACT;

    }
}

