/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.plugins;

import com.google.common.annotations.VisibleForTesting;
import com.sourceclear.plugins.Config;
import com.sourceclear.plugins.DefaultLifecycle;
import com.sourceclear.plugins.HeadlessLifecycle;
import com.sourceclear.plugins.Lifecycle;
import com.sourceclear.util.config.EnvironmentProvider;
import com.sourceclear.util.config.EnvironmentProviderImpl;
import com.sourceclear.util.config.FailureLevel;
import com.srcclr.sdk.Directives;
import com.srcclr.sdk.LibraryGraph;
import com.srcclr.sdk.LibraryGraphContainer;
import com.srcclr.sdk.build.MavenComponentGraphBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;

@Mojo(name="scan", requiresDependencyCollection=ResolutionScope.TEST, instantiationStrategy=InstantiationStrategy.SINGLETON)
public class ScanMavenMojo
extends AbstractMojo {
    private static final String SCOPE_ENV_VAR = "SRCCLR_SCAN_SCOPE";
    private static final String DIRECTIVES_FILE_NAME = "srcclr.yml";
    private static final Path DIRECTIVES_FILE = Paths.get("srcclr.yml", new String[0]);
    private static final String DIRECTIVES_SCOPE_KEY = "scope";
    private static final String DEFAULT_SCOPE = "compile";
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    public Settings settings;
    @Parameter(property="projectName")
    private String projectName;
    @Parameter(property="apiURL")
    protected URI apiURL;
    @Parameter(property="apiToken")
    protected String apiToken;
    @Parameter(property="projectID")
    private Long userProjectID;
    @Parameter(property="upload", defaultValue="true")
    private boolean upload;
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="useOnlyMavenParams", defaultValue="false")
    private boolean useOnlyMavenParams;
    @Parameter(property="srcclr.maven.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="srcclr.license.provided", defaultValue="false")
    private boolean licenseProvided;
    @Parameter(property="headlessOutputFile")
    private File headlessOutputFile;
    @Parameter(property="workspaceSlug")
    protected String workspaceSlug;
    @Parameter(property="failureThreshold")
    private FailureLevel failureThreshold;
    @Parameter(property="scope")
    private String scopeParameter;
    @Component(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;
    EnvironmentProvider environmentProvider = new EnvironmentProviderImpl();
    LibraryGraphContainer.Builder projectDependencyTreesBuilder = new LibraryGraphContainer.Builder();
    MavenProject lastProject;
    private String pluginVersion;

    protected File getPathToTop() {
        if (this.session != null) {
            return this.session.getTopLevelProject().getFile().getParentFile();
        }
        this.getLog().warn((CharSequence)"Couldn't figure out the top level of the Maven project.");
        return new File(".");
    }

    @VisibleForTesting
    void initialSetup() throws MojoFailureException {
        this.pluginVersion = ((PluginDescriptor)this.getPluginContext().get("pluginDescriptor")).getVersion();
        if (this.lastProject == null) {
            List sortedProjects = this.session.getProjectDependencyGraph().getSortedProjects();
            this.lastProject = (MavenProject)sortedProjects.get(sortedProjects.size() - 1);
        }
    }

    private LibraryGraph getProjectDependencyGraph() throws MojoExecutionException, MojoFailureException {
        try {
            MavenProject currentProject = this.session.getCurrentProject();
            Path pathToCurrPom = currentProject.getFile().toPath();
            String relativePathToCurrPom = Paths.get(this.getPathToTop().toString(), new String[0]).relativize(pathToCurrPom).toString();
            MavenComponentGraphBuilder graphTranslator = new MavenComponentGraphBuilder();
            DependencyNode mavenDependencyTree = this.dependencyGraphBuilder.buildDependencyGraph(currentProject, (ArtifactFilter)new ScopeArtifactFilter(this.getScope()));
            return graphTranslator.buildGraph(mavenDependencyTree, relativePathToCurrPom);
        }
        catch (DependencyGraphBuilderException e) {
            throw new MojoExecutionException("Encountered problem running the SRC:CLR maven plugin: " + e.getMessage());
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping the SRC:CLR Maven Plugin because srcclr.maven.skip is set");
            return;
        }
        this.initialSetup();
        Config config = Config.builder().withPluginVersion(this.pluginVersion).withApiToken(this.apiToken).withApiURL(this.apiURL).withFailureThreshold(this.failureThreshold).withLogger(this.getLog()).withLicenseProvided(this.licenseProvided).withProjectName(this.projectName).withPathToTop(this.getPathToTop()).withSettings(this.settings).withUpload(this.upload).withUseOnlyMavenParams(this.useOnlyMavenParams).withUserProjectID(this.userProjectID).withHeadlessOutputFile(this.headlessOutputFile).withVerbose(this.verbose).withWorkspaceSlug(this.workspaceSlug).build();
        Lifecycle lifecycle = ScanMavenMojo.determineLifecycle(config);
        lifecycle.configure(this.environmentProvider);
        this.projectDependencyTreesBuilder.withGraph(this.getProjectDependencyGraph());
        if (this.lastProject.equals((Object)this.session.getCurrentProject())) {
            LibraryGraphContainer depTrees = this.projectDependencyTreesBuilder.build();
            lifecycle.execute(depTrees);
        }
    }

    static Lifecycle determineLifecycle(Config config) {
        if (config.getHeadlessOutputFile().isPresent()) {
            return new HeadlessLifecycle(config.getHeadlessOutputFile().get());
        }
        return new DefaultLifecycle(config);
    }

    private String getScope() throws MojoFailureException {
        String envVarScope = this.environmentProvider.getenv(SCOPE_ENV_VAR);
        String scope = envVarScope != null ? envVarScope : (this.scopeParameter != null ? this.scopeParameter : (Files.exists(DIRECTIVES_FILE, new LinkOption[0]) ? ScanMavenMojo.getScopeFromDirectivesFile(DIRECTIVES_FILE) : DEFAULT_SCOPE));
        return ScanMavenMojo.toArtifactScopeValue(scope);
    }

    static String getScopeFromDirectivesFile(Path directivesFile) throws MojoFailureException {
        String scope;
        try (InputStream is = Files.newInputStream(directivesFile, new OpenOption[0]);){
            Map directives = Directives.parseDirectives((InputStream)is);
            String scopeValue = (String)directives.get(DIRECTIVES_SCOPE_KEY);
            scope = scopeValue != null ? scopeValue : DEFAULT_SCOPE;
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage());
        }
        return scope;
    }

    static String toArtifactScopeValue(String scope) {
        switch (scope) {
            case "compile": 
            case "test": 
            case "import": 
            case "runtime": 
            case "provided": 
            case "system": {
                return scope;
            }
        }
        return DEFAULT_SCOPE;
    }
}

