/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.publicmethods;

import com.google.common.base.Strings;
import com.sourceclear.analysis.utils.Utils;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.VulnMethodsConfig;
import com.sourceclear.publicmethods.java.JavaVisitor;
import com.sourceclear.publicmethods.python.PythonMethodVisitor;
import com.sourceclear.publicmethods.python.PythonProjectAnalysis;
import com.sourceclear.publicmethods.ruby.RubyMethodsVisitor;
import com.sourceclear.pysonar.Analyzer;
import com.sourceclear.pysonar.ast.Node;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.jar.JarInputStream;
import org.objectweb.asm.ClassVisitor;

public class PublicMethods {
    private PublicMethods() {
    }

    public static MethodInfo pythonMethod(String moduleName, String className, String methodName) {
        return new MethodInfo(moduleName, className, methodName, (String)null);
    }

    public static List<MethodInfo> findPython(Path fileOrDirectory) throws IOException {
        return new PublicMethods().findPythonPublicMethods(fileOrDirectory);
    }

    public static List<MethodInfo> findRuby(Path fileOrDirectory) throws IOException {
        return new PublicMethods().findRubyPublicMethods(fileOrDirectory);
    }

    public static List<MethodInfo> findJava(Path fileOrDirectory) throws IOException {
        return new PublicMethods().findJavaPublicMethods(fileOrDirectory);
    }

    public static List<MethodInfo> findJava(InputStream jarStream) throws IOException {
        return new PublicMethods().findJavaPublicMethods(jarStream);
    }

    public static List<MethodInfo> findPython(InputStream archiveStream) throws IOException {
        return Utils.processPythonArchive(archiveStream, PublicMethods::findPython);
    }

    public static List<MethodInfo> findRuby(InputStream archiveStream) throws IOException {
        return Utils.processRubyGemsArchive(archiveStream, PublicMethods::findRuby);
    }

    private List<MethodInfo> findRubyPublicMethods(Path fileOrDirectory) throws IOException {
        final ArrayList<MethodInfo> result = new ArrayList<MethodInfo>();
        com.sourceclear.rubysonar.Analyzer analyzer = new com.sourceclear.rubysonar.Analyzer(VulnMethodsConfig.Builder.ruby().build());
        RubyMethodsVisitor visitor = new RubyMethodsVisitor(){

            @Override
            public void visitMethod(MethodInfo methodInfo, org.jrubyparser.ast.Node body) {
                result.add(methodInfo);
            }
        };
        analyzer.addVisitor(visitor);
        analyzer.analyze(fileOrDirectory);
        analyzer.finish();
        return result;
    }

    private List<MethodInfo> findPythonPublicMethods(Path fileOrDirectory) throws IOException {
        final ArrayList result = new ArrayList();
        new PythonProjectAnalysis(fileOrDirectory, VulnMethodsConfig.Builder.python().build()){

            @Override
            public void analyseSourceFile(Analyzer analyzer, Path projectDir, Path sourceFile) throws IOException {
                result.addAll(PublicMethods.analysePythonSourceFile(analyzer, projectDir, sourceFile));
            }
        }.run();
        ArrayList<MethodInfo> processedResult = new ArrayList<MethodInfo>();
        for (MethodInfo publicMethod : result) {
            boolean isLambda = publicMethod.getMethodName().contains("%");
            if (isLambda) continue;
            processedResult.add(publicMethod);
        }
        return processedResult;
    }

    private static List<MethodInfo> analysePythonSourceFile(Analyzer analyzer, Path projectDir, Path sourceFile) throws IOException {
        String qualifiedModuleName = Strings.emptyToNull((String)com.sourceclear.pysonar.Utils.getQualifiedModuleName(projectDir, sourceFile));
        Node root = analyzer.getAstForFile(sourceFile);
        final ArrayList<MethodInfo> result = new ArrayList<MethodInfo>();
        new PythonMethodVisitor(qualifiedModuleName){

            @Override
            public void visitMethod(MethodInfo method, Node body) {
                result.add(method);
            }
        }.visit(root);
        return result;
    }

    private List<MethodInfo> findJavaPublicMethods(Path jarFilePath) throws IOException {
        return this.findJavaPublicMethods(new FileInputStream(jarFilePath.toAbsolutePath().toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<MethodInfo> findJavaPublicMethods(InputStream jarFile) throws IOException {
        try (JarInputStream jis = new JarInputStream(jarFile);){
            ArrayList<MethodInfo> result = new ArrayList<MethodInfo>();
            Utils.readEntries(jis, classReader -> {
                JavaVisitor cl = new JavaVisitor();
                classReader.accept((ClassVisitor)cl, 0);
                result.addAll(cl.getResult());
                return Optional.empty();
            });
            ArrayList<MethodInfo> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            throw new IOException("Error reading bytecode", e);
        }
    }
}

