/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.pysonar;

import com.sourceclear.methods.VulnMethodsConfig;
import com.sourceclear.pysonar.Utils;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class PythonProjectFileVisitor
extends SimpleFileVisitor<Path> {
    private final VulnMethodsConfig config;

    public PythonProjectFileVisitor(VulnMethodsConfig config) {
        this.config = config;
    }

    @Override
    public final FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        for (String ignoredDirectory : this.config.ignoredDirectories()) {
            if (!dir.getFileName().endsWith(ignoredDirectory)) continue;
            return FileVisitResult.SKIP_SUBTREE;
        }
        return this.preVisitPythonProjectDirectory(dir, attrs);
    }

    @Override
    public final FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (Utils.isPythonFile(file.getFileName())) {
            return this.visitPythonFile(file, attrs);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        return super.visitFileFailed(file, exc);
    }

    @Override
    public final FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        return this.postVisitPythonProjectDirectory(dir, exc);
    }

    public FileVisitResult preVisitPythonProjectDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    public FileVisitResult visitPythonFile(Path file, BasicFileAttributes attrs) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    public FileVisitResult postVisitPythonProjectDirectory(Path dir, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }
}

