/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.pysonar.types;

import com.sourceclear.pysonar.Analyzer;
import com.sourceclear.pysonar.types.ListType;
import com.sourceclear.pysonar.types.Type;
import com.sourceclear.pysonar.types.TypeVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TupleType
extends Type {
    public List<Type> eltTypes = new ArrayList<Type>();

    public TupleType(Analyzer analyzer) {
        super(analyzer);
        this.table.addSuper(analyzer.builtins.BaseTuple.table);
        this.table.setPath(analyzer.builtins.BaseTuple.table.path);
    }

    public TupleType(Analyzer analyzer, List<Type> eltTypes) {
        this(analyzer);
        this.eltTypes = eltTypes;
    }

    public TupleType(Analyzer analyzer, Type elt0) {
        this(analyzer);
        this.eltTypes.add(elt0);
    }

    public TupleType(Analyzer analyzer, Type elt0, Type elt1) {
        this(analyzer);
        this.eltTypes.add(elt0);
        this.eltTypes.add(elt1);
    }

    public TupleType(Analyzer analyzer, Type ... types) {
        this(analyzer);
        Collections.addAll(this.eltTypes, types);
    }

    public void setElementTypes(List<Type> eltTypes) {
        this.eltTypes = eltTypes;
    }

    public void add(Type elt) {
        this.eltTypes.add(elt);
    }

    public Type get(int i) {
        return this.eltTypes.get(i);
    }

    @NotNull
    public ListType toListType() {
        ListType t = new ListType(this.analyzer);
        for (Type e : this.eltTypes) {
            t.add(e);
        }
        return t;
    }

    @Override
    public boolean typeEquals(Object other) {
        if (this.analyzer.state.typeStack.contains(this, other)) {
            return true;
        }
        if (other instanceof TupleType) {
            List<Type> types1 = this.eltTypes;
            List<Type> types2 = ((TupleType)other).eltTypes;
            if (types1.size() == types2.size()) {
                this.analyzer.state.typeStack.push(this, other);
                for (int i = 0; i < types1.size(); ++i) {
                    if (types1.get(i).typeEquals(types2.get(i))) continue;
                    this.analyzer.state.typeStack.pop(this, other);
                    return false;
                }
                this.analyzer.state.typeStack.pop(this, other);
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return "TupleType".hashCode();
    }

    @Override
    protected String printType(@NotNull Type.CyclicTypeRecorder ctr) {
        StringBuilder sb = new StringBuilder();
        Integer num = ctr.visit(this);
        if (num != null) {
            sb.append("#").append(num);
        } else {
            int newNum = ctr.push(this);
            boolean first = true;
            if (this.eltTypes.size() != 1) {
                sb.append("(");
            }
            for (Type t : this.eltTypes) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(t.printType(ctr));
                first = false;
            }
            if (ctr.isUsed(this)) {
                sb.append("=#").append(newNum).append(":");
            }
            if (this.eltTypes.size() != 1) {
                sb.append(")");
            }
            ctr.pop(this);
        }
        return sb.toString();
    }

    @Override
    public <T> T accept(TypeVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

