/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.rubysonar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jrubyparser.ast.ArgsCatNode;
import org.jrubyparser.ast.ArgsPushNode;
import org.jrubyparser.ast.ArrayNode;
import org.jrubyparser.ast.EmptyArgsNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.SplatNode;
import org.jrubyparser.ast.visitor.AbstractNodeVisitor;

class ArgsFlattener
extends AbstractNodeVisitor<List<Node>> {
    static final ArgsFlattener INSTANCE = new ArgsFlattener();

    ArgsFlattener() {
    }

    @Override
    public List<Node> visitArgsCatNode(ArgsCatNode argsCatNode) {
        Node firstNode = argsCatNode.getFirstNode();
        Node secondNode = argsCatNode.getSecondNode();
        ArrayList<Node> nodes = new ArrayList<Node>();
        block3: for (Node node : Arrays.asList(firstNode, secondNode)) {
            switch (node.getNodeType()) {
                case ARRAYNODE: 
                case ARGSCATNODE: 
                case ARGSPUSHNODE: {
                    nodes.addAll((Collection<Node>)node.accept(this));
                    continue block3;
                }
            }
            nodes.add(new SplatNode(argsCatNode.getPosition(), node));
        }
        return nodes;
    }

    @Override
    public List<Node> visitArgsPushNode(ArgsPushNode node) {
        Node secondNode = node.getSecondNode();
        Node firstNode = node.getFirstNode();
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.addAll((Collection)firstNode.accept(this));
        nodes.addAll((Collection)secondNode.accept(this));
        return nodes;
    }

    @Override
    public List<Node> visitArrayNode(ArrayNode node) {
        return Arrays.asList(node.children());
    }

    @Override
    public List<Node> visitEmptyArgsNode(EmptyArgsNode node) {
        return Collections.emptyList();
    }

    @Override
    protected List<Node> defaultVisit(Node node) {
        return Collections.singletonList(node);
    }
}

