/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.rubysonar.types;

import com.sourceclear.rubysonar.State;
import com.sourceclear.rubysonar.types.ClassType;
import com.sourceclear.rubysonar.types.CyclicTypeRecorder;
import com.sourceclear.rubysonar.types.ListType;
import com.sourceclear.rubysonar.types.TupleType;
import com.sourceclear.rubysonar.types.Type;
import com.sourceclear.rubysonar.types.TypeStack;
import com.sourceclear.rubysonar.types.Types;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jrubyparser.ast.MethodDefNode;

public class FunType
implements Type {
    @NotNull
    public Map<Type, Type> arrows = new HashMap<Type, Type>();
    private MethodDefNode methodDefNode;
    @Nullable
    private ClassType classType = null;
    private final State table;
    private final State env;
    @Nullable
    private Type selfType;
    private List<Type> defaultTypes;
    private boolean isClassMethod = false;
    private static boolean MULTILINE_FUNCTION_TYPE = false;
    private String arrowsString;
    private final CyclicTypeRecorder ctr = new CyclicTypeRecorder();

    public FunType(MethodDefNode methodDefNode, State env) {
        this(State.newGlobalTable(), methodDefNode, env);
    }

    public FunType(State globalTable, MethodDefNode methodDefNode, State env) {
        this.table = new State(globalTable, State.StateType.FUNCTION);
        this.methodDefNode = methodDefNode;
        this.env = env;
    }

    public FunType(Type from, Type to) {
        this(State.newGlobalTable(), null, null);
        this.addMapping(from, to);
    }

    public MethodDefNode getMethodDefNode() {
        return this.methodDefNode;
    }

    public State getEnv() {
        return this.env;
    }

    @NotNull
    public Map<Type, Type> getArrows() {
        return this.arrows;
    }

    @Nullable
    public Type getSelfType() {
        return this.selfType;
    }

    public List<Type> getDefaultTypes() {
        return this.defaultTypes;
    }

    public boolean isClassMethod() {
        return this.isClassMethod;
    }

    public static boolean isMultilineFunctionType() {
        return MULTILINE_FUNCTION_TYPE;
    }

    public void addMapping(Type from, Type to) {
        if (this.arrows.size() < 5) {
            this.arrows.put(from, to);
            Map<Type, Type> oldArrows = this.arrows;
            this.arrows = this.compressArrows(this.arrows);
            if (this.toString().length() > 900) {
                this.arrows = oldArrows;
            }
            this.arrowsString = this.printType(this.ctr);
        }
    }

    @Nullable
    public Type getMapping(@NotNull Type from) {
        return this.arrows.get(from);
    }

    public Type getReturnType() {
        if (!this.arrows.isEmpty()) {
            return this.arrows.values().iterator().next();
        }
        return Types.UNKNOWN;
    }

    @Override
    public State getTable() {
        return this.table;
    }

    @Nullable
    public ClassType getClassType() {
        return this.classType;
    }

    public void setClassType(ClassType cls) {
        this.classType = cls;
    }

    public void setSelfType(Type selfType) {
        this.selfType = selfType;
    }

    public void setDefaultTypes(List<Type> defaultTypes) {
        this.defaultTypes = defaultTypes;
    }

    public void setClassMethod(boolean isClassMethod) {
        this.isClassMethod = isClassMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunType funType = (FunType)o;
        return Objects.equals(this.toString(), funType.toString());
    }

    public int hashCode() {
        return "FunType".hashCode();
    }

    private boolean subsumed(Type type1, Type type2) {
        return this.subsumedInner(type1, type2, new TypeStack());
    }

    private boolean subsumedInner(Type type1, Type type2, TypeStack typeStack) {
        if (typeStack.contains(type1, type2)) {
            return true;
        }
        if (type1.equals(Types.UNKNOWN) || type1.equals(Types.NIL) || type1.equals(type2)) {
            return true;
        }
        if (type1 instanceof TupleType && type2 instanceof TupleType) {
            List<Type> elems1 = ((TupleType)type1).getElementTypes();
            List<Type> elems2 = ((TupleType)type2).getElementTypes();
            if (elems1.size() == elems2.size()) {
                typeStack.push(type1, type2);
                for (int i = 0; i < elems1.size(); ++i) {
                    if (this.subsumedInner(elems1.get(i), elems2.get(i), typeStack)) continue;
                    typeStack.pop(type1, type2);
                    return false;
                }
            }
            return true;
        }
        if (type1 instanceof ListType && type2 instanceof ListType) {
            return this.subsumedInner(((ListType)type1).toTupleType(), ((ListType)type2).toTupleType(), typeStack);
        }
        return false;
    }

    private Map<Type, Type> compressArrows(Map<Type, Type> arrows) {
        HashMap<Type, Type> ret = new HashMap<Type, Type>();
        for (Map.Entry<Type, Type> e1 : arrows.entrySet()) {
            boolean subsumed = false;
            for (Map.Entry<Type, Type> e2 : arrows.entrySet()) {
                if (e1 == e2 || !this.subsumed(e1.getKey(), e2.getKey())) continue;
                subsumed = true;
                break;
            }
            if (subsumed) continue;
            ret.put(e1.getKey(), e1.getValue());
        }
        return ret;
    }

    private TupleType simplifySelf(TupleType from) {
        TupleType simplified = new TupleType();
        if (from.getElementTypes().size() > 0) {
            if (this.classType != null) {
                simplified.add(this.classType.getCanon());
            } else {
                simplified.add(from.get(0));
            }
        }
        for (int i = 1; i < from.getElementTypes().size(); ++i) {
            simplified.add(from.get(i));
        }
        return simplified;
    }

    @Override
    public String printType(@NotNull CyclicTypeRecorder ctr) {
        if (this.arrows.isEmpty()) {
            return "? -> ?";
        }
        StringBuilder sb = new StringBuilder();
        Integer num = ctr.visit(this);
        if (num != null) {
            sb.append("#").append(num);
        } else {
            int newNum = ctr.push(this);
            int i = 0;
            HashSet<String> seen = new HashSet<String>();
            for (Map.Entry<Type, Type> e : this.arrows.entrySet()) {
                Type from = e.getKey();
                String as = from.printType(ctr) + " -> " + e.getValue().printType(ctr);
                if (!seen.contains(as)) {
                    if (i != 0) {
                        if (MULTILINE_FUNCTION_TYPE) {
                            sb.append("\n| ");
                        } else {
                            sb.append(" | ");
                        }
                    }
                    sb.append(as);
                    seen.add(as);
                }
                ++i;
            }
            if (ctr.isUsed(this)) {
                sb.append("=#").append(newNum).append(": ");
            }
            ctr.pop(this);
        }
        return sb.toString();
    }

    @NotNull
    public String toString() {
        if (this.arrowsString == null) {
            this.arrowsString = this.printType(this.ctr);
        }
        return this.arrowsString;
    }
}

