/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.rubysonar.types;

import com.sourceclear.rubysonar.Builtins;
import com.sourceclear.rubysonar.State;
import com.sourceclear.rubysonar.types.ClassType;
import com.sourceclear.rubysonar.types.CyclicTypeRecorder;
import com.sourceclear.rubysonar.types.TupleType;
import com.sourceclear.rubysonar.types.Type;
import com.sourceclear.rubysonar.types.TypeStack;
import com.sourceclear.rubysonar.types.Types;
import com.sourceclear.rubysonar.types.UnionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ListType
implements Type {
    @NotNull
    private final Type elementType;
    @NotNull
    private final List<Type> positional;
    @NotNull
    private TypeStack typeStack = new TypeStack();
    @NotNull
    private final State table;

    public ListType() {
        this(Types.UNKNOWN);
    }

    public ListType(State globalTable) {
        this(globalTable, Types.UNKNOWN, Collections.emptyList());
    }

    public ListType(Type elementType) {
        this(State.newGlobalTable(), elementType, Collections.emptyList());
    }

    public ListType(State globalTable, Type elementType) {
        this(globalTable, elementType, Collections.emptyList());
    }

    public ListType(@NotNull State globalTable, @NotNull Type elementType, @NotNull List<Type> positional) {
        this.elementType = elementType;
        this.positional = positional;
        Type arrayClass = globalTable.lookupType("Array");
        if (!(arrayClass instanceof ClassType)) {
            arrayClass = Builtins.initArrayClass(globalTable, elementType);
        } else {
            Builtins.insertArrayMethods(arrayClass, elementType);
        }
        this.table = new State(globalTable, State.StateType.INSTANCE);
        this.table.setParent(arrayClass.getTable());
        this.table.setPath(arrayClass.getTable().path);
    }

    @NotNull
    public TupleType toTupleType(int n) {
        TupleType ret = new TupleType();
        for (int i = 0; i < n; ++i) {
            ret.add(this.elementType);
        }
        return ret;
    }

    @NotNull
    public TupleType toTupleType() {
        return new TupleType(this.positional);
    }

    public static ListTypeBuilder builder() {
        return new ListTypeBuilder();
    }

    public boolean equals(Object other) {
        if (this.typeStack.contains(this, other)) {
            return true;
        }
        if (other instanceof ListType) {
            ListType co = (ListType)other;
            this.typeStack.push(this, other);
            boolean ret = co.elementType.equals(this.elementType);
            this.typeStack.pop(this, other);
            return ret;
        }
        return false;
    }

    public int hashCode() {
        return "ListType".hashCode();
    }

    @Override
    public String printType(@NotNull CyclicTypeRecorder ctr) {
        StringBuilder sb = new StringBuilder();
        Integer num = ctr.visit(this);
        if (num != null) {
            sb.append("#").append(num);
        } else {
            ctr.push(this);
            sb.append("[");
            sb.append(this.elementType.printType(ctr));
            sb.append("]");
            ctr.pop(this);
        }
        return sb.toString();
    }

    @NotNull
    public Type getElementType() {
        return this.elementType;
    }

    @NotNull
    public List<Type> getPositional() {
        return this.positional;
    }

    @Override
    public State getTable() {
        return this.table;
    }

    @NotNull
    public String toString() {
        return this.printType(new CyclicTypeRecorder());
    }

    public static class ListTypeBuilder {
        private Type elementType = Types.UNKNOWN;
        private List<Type> positional = new ArrayList<Type>();
        private State globalTable = State.newGlobalTable();

        public ListTypeBuilder withGlobalTable(State globalTable) {
            this.globalTable = globalTable;
            return this;
        }

        public ListTypeBuilder addElementType(Type elementType) {
            this.elementType = UnionType.union(this.elementType, elementType);
            this.positional.add(elementType);
            return this;
        }

        public ListType build() {
            return new ListType(this.globalTable, this.elementType, this.positional);
        }
    }
}

